/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.help.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.TGFileUtils;

public class TGDocumentation {
    private static final String RESOURCE_PATH = "help";
    private static final String TEMPORAL_PATH = System.getProperty("java.io.tmpdir") + File.separator + "tuxguitar";

    public void display() throws Throwable {
        URL uRL = this.getIndexUrl();
        if (uRL != null) {
            Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 1264);
            shell.setLayout((Layout)new FillLayout());
            Browser browser = new Browser((Composite)shell, 2048);
            browser.setLayout((Layout)new FillLayout());
            browser.setUrl(uRL.toExternalForm());
            DialogUtils.openDialog(shell, 24);
        }
    }

    private URL getIndexUrl() throws Throwable {
        URL uRL = TGFileUtils.getResourceUrl("help/index.html");
        if (uRL != null && !TGFileUtils.isLocalFile(uRL)) {
            String string = TEMPORAL_PATH + File.separator + RESOURCE_PATH;
            this.copyTemporalResources(string, RESOURCE_PATH, TGFileUtils.getFileNames(RESOURCE_PATH));
            uRL = new File(string + File.separator + "index.html").toURI().toURL();
        }
        return uRL;
    }

    private void copyTemporalResources(String string, String string2, String[] stringArray) throws Throwable {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                InputStream inputStream;
                File file = new File(string + File.separator + stringArray[i]);
                file.getParentFile().mkdirs();
                String string3 = string2 + "/" + stringArray[i];
                String[] stringArray2 = TGFileUtils.getFileNames(string3);
                if (stringArray2 != null && stringArray2.length > 0) {
                    this.copyTemporalResources(file.getAbsolutePath(), string3, stringArray2);
                    continue;
                }
                if (file.exists() || (inputStream = TGFileUtils.getResourceAsStream(string3)) == null) continue;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                int n = 0;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
        }
    }
}

