/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class TGMeasureHeaderImpl
extends TGMeasureHeader {
    private static final int DEFAULT_TIME_SIGNATURE_SPACING = 30;
    private static final int DEFAULT_LEFT_SPACING = 15;
    private static final int DEFAULT_RIGHT_SPACING = 15;
    private static final int PAINT_TEMPO = 1;
    private static final int PAINT_TRIPLET_FEEL = 2;
    private static final int PAINT_TIME_SIGNATURE = 4;
    private int paintFlags;
    private int maxQuarterSpacing;
    private int maxClefSpacing;
    private int maxKeySignatureSpacing;
    private int maxWidth;

    public TGMeasureHeaderImpl(TGFactory tGFactory) {
        super(tGFactory);
    }

    public void reset() {
        this.maxWidth = 0;
        this.paintFlags = 0;
        this.maxQuarterSpacing = 0;
        this.maxClefSpacing = 0;
        this.maxKeySignatureSpacing = 0;
    }

    public void update(ViewLayout viewLayout, int n) {
        this.reset();
        this.calculateMeasureChanges(viewLayout);
        int n2 = this.getSong().countTracks();
        for (int i = 0; i < n2; ++i) {
            TGTrackImpl tGTrackImpl = (TGTrackImpl)this.getSong().getTrack(i);
            TGMeasureImpl tGMeasureImpl = (TGMeasureImpl)tGTrackImpl.getMeasure(n);
            tGMeasureImpl.calculateMeasureChanges(viewLayout);
        }
    }

    public void calculateMeasureChanges(ViewLayout viewLayout) {
        TGMeasureHeader tGMeasureHeader = viewLayout.getSongManager().getPrevMeasureHeader(this);
        if (tGMeasureHeader == null) {
            this.paintFlags |= 1;
            this.paintFlags |= this.getTripletFeel() != 1 ? 2 : 0;
            this.paintFlags |= 4;
        } else {
            if (this.getTempo().getValue() != tGMeasureHeader.getTempo().getValue()) {
                this.paintFlags |= 1;
            }
            if (this.getTripletFeel() != tGMeasureHeader.getTripletFeel()) {
                this.paintFlags |= 2;
            }
            int n = this.getTimeSignature().getNumerator();
            int n2 = this.getTimeSignature().getDenominator().getValue();
            int n3 = tGMeasureHeader.getTimeSignature().getNumerator();
            int n4 = tGMeasureHeader.getTimeSignature().getDenominator().getValue();
            if (n != n3 || n2 != n4) {
                this.paintFlags |= 4;
            }
        }
    }

    public boolean shouldPaintTempo() {
        return (this.paintFlags & 1) != 0;
    }

    public boolean shouldPaintTripletFeel() {
        return (this.paintFlags & 2) != 0;
    }

    public boolean shouldPaintTimeSignature() {
        return (this.paintFlags & 4) != 0;
    }

    public int getMaxQuarterSpacing() {
        return this.maxQuarterSpacing;
    }

    public void notifyQuarterSpacing(int n) {
        this.maxQuarterSpacing = n > this.maxQuarterSpacing ? n : this.maxQuarterSpacing;
    }

    public int getClefSpacing(ViewLayout viewLayout, TGMeasureImpl tGMeasureImpl) {
        return !tGMeasureImpl.isPaintClef() && (viewLayout.getStyle() & 2) == 0 ? 0 : this.maxClefSpacing;
    }

    public int getKeySignatureSpacing(ViewLayout viewLayout, TGMeasureImpl tGMeasureImpl) {
        return !tGMeasureImpl.isPaintKeySignature() && (viewLayout.getStyle() & 2) == 0 ? 0 : this.maxKeySignatureSpacing;
    }

    public int getTempoSpacing(ViewLayout viewLayout) {
        return this.shouldPaintTempo() ? Math.round(45.0f * viewLayout.getScale()) : 0;
    }

    public int getTripletFeelSpacing(ViewLayout viewLayout) {
        return this.shouldPaintTripletFeel() ? Math.round(55.0f * viewLayout.getScale()) : 0;
    }

    public int getTimeSignatureSpacing(ViewLayout viewLayout) {
        return this.shouldPaintTimeSignature() ? Math.round(30.0f * viewLayout.getScale()) : 0;
    }

    public int getLeftSpacing(ViewLayout viewLayout) {
        return Math.round(15.0f * viewLayout.getScale());
    }

    public int getRightSpacing(ViewLayout viewLayout) {
        return Math.round(15.0f * viewLayout.getScale());
    }

    public int getFirstNoteSpacing(ViewLayout viewLayout, TGMeasureImpl tGMeasureImpl) {
        int n = this.getTempoSpacing(viewLayout) + this.getTripletFeelSpacing(viewLayout);
        int n2 = this.getClefSpacing(viewLayout, tGMeasureImpl) + this.getKeySignatureSpacing(viewLayout, tGMeasureImpl) + this.getTimeSignatureSpacing(viewLayout);
        return Math.round((float)Math.max(n, n2) + 10.0f * viewLayout.getScale());
    }

    public void notifyClefSpacing(int n) {
        this.maxClefSpacing = n > this.maxClefSpacing ? n : this.maxClefSpacing;
    }

    public void notifyKeySignatureSpacing(int n) {
        this.maxKeySignatureSpacing = n > this.maxKeySignatureSpacing ? n : this.maxKeySignatureSpacing;
    }

    public void notifyWidth(int n) {
        this.maxWidth = n > this.maxWidth ? n : this.maxWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }
}

