/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGNoteImpl;
import org.herac.tuxguitar.gui.editors.tab.TGVoiceImpl;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;

public class TGBeatGroup {
    private static final int[] SCORE_MIDDLE_KEYS = new int[]{55, 40, 40, 50};
    private static final int[] SCORE_SHARP_POSITIONS = new int[]{7, 7, 6, 6, 5, 4, 4, 3, 3, 2, 2, 1};
    private static final int[] SCORE_FLAT_POSITIONS = new int[]{7, 6, 6, 5, 5, 4, 3, 3, 2, 2, 1, 1};
    public static final int DIRECTION_NOT_SETTED = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    private static final int UP_OFFSET = 28;
    private static final int DOWN_OFFSET = 35;
    private int voice;
    private int direction;
    private List voices;
    private TGNoteImpl firstMinNote;
    private TGNoteImpl firstMaxNote;
    private TGNoteImpl lastMinNote;
    private TGNoteImpl lastMaxNote;
    private TGNoteImpl maxNote;
    private TGNoteImpl minNote;

    public TGBeatGroup(int n) {
        this.voice = n;
        this.voices = new ArrayList();
        this.direction = 0;
        this.firstMinNote = null;
        this.firstMaxNote = null;
        this.lastMinNote = null;
        this.lastMaxNote = null;
        this.maxNote = null;
        this.minNote = null;
    }

    public void check(TGVoiceImpl tGVoiceImpl) {
        this.check(tGVoiceImpl.getMaxNote());
        this.check(tGVoiceImpl.getMinNote());
        this.voices.add(tGVoiceImpl);
        if (tGVoiceImpl.getDirection() != 0) {
            if (tGVoiceImpl.getDirection() == 1) {
                this.direction = 1;
            } else if (tGVoiceImpl.getDirection() == 2) {
                this.direction = 2;
            }
        }
    }

    private void check(TGNoteImpl tGNoteImpl) {
        int n = tGNoteImpl.getRealValue();
        if (this.firstMinNote == null || tGNoteImpl.getVoice().getBeat().getStart() < this.firstMinNote.getVoice().getBeat().getStart()) {
            this.firstMinNote = tGNoteImpl;
        } else if (tGNoteImpl.getVoice().getBeat().getStart() == this.firstMinNote.getVoice().getBeat().getStart() && tGNoteImpl.getRealValue() < this.firstMinNote.getRealValue()) {
            this.firstMinNote = tGNoteImpl;
        }
        if (this.firstMaxNote == null || tGNoteImpl.getVoice().getBeat().getStart() < this.firstMaxNote.getVoice().getBeat().getStart()) {
            this.firstMaxNote = tGNoteImpl;
        } else if (tGNoteImpl.getVoice().getBeat().getStart() == this.firstMaxNote.getVoice().getBeat().getStart() && tGNoteImpl.getRealValue() > this.firstMaxNote.getRealValue()) {
            this.firstMaxNote = tGNoteImpl;
        }
        if (this.lastMinNote == null || tGNoteImpl.getVoice().getBeat().getStart() > this.lastMinNote.getVoice().getBeat().getStart()) {
            this.lastMinNote = tGNoteImpl;
        } else if (tGNoteImpl.getVoice().getBeat().getStart() == this.lastMinNote.getVoice().getBeat().getStart() && tGNoteImpl.getRealValue() < this.lastMinNote.getRealValue()) {
            this.lastMinNote = tGNoteImpl;
        }
        if (this.lastMaxNote == null || tGNoteImpl.getVoice().getBeat().getStart() > this.lastMaxNote.getVoice().getBeat().getStart()) {
            this.lastMaxNote = tGNoteImpl;
        } else if (tGNoteImpl.getVoice().getBeat().getStart() == this.lastMaxNote.getVoice().getBeat().getStart() && tGNoteImpl.getRealValue() > this.lastMaxNote.getRealValue()) {
            this.lastMaxNote = tGNoteImpl;
        }
        if (this.maxNote == null || n > this.maxNote.getRealValue()) {
            this.maxNote = tGNoteImpl;
        }
        if (this.minNote == null || n < this.minNote.getRealValue()) {
            this.minNote = tGNoteImpl;
        }
    }

    public void finish(ViewLayout viewLayout, TGMeasureImpl tGMeasureImpl) {
        if (this.direction == 0) {
            int n;
            int n2;
            this.direction = tGMeasureImpl.getNotEmptyVoices() > 1 ? (this.voice == 0 ? 1 : 2) : ((viewLayout.getStyle() & 4) == 0 ? 2 : ((n2 = Math.abs(this.minNote.getRealValue() - (SCORE_MIDDLE_KEYS[tGMeasureImpl.getClef() - 1] + 100))) > (n = Math.abs(this.maxNote.getRealValue() - (SCORE_MIDDLE_KEYS[tGMeasureImpl.getClef() - 1] - 100))) ? 1 : 2));
        }
    }

    public List getVoices() {
        return this.voices;
    }

    public int getY1(ViewLayout viewLayout, TGNoteImpl tGNoteImpl, int n, int n2) {
        double d = (double)viewLayout.getScoreLineSpacing() / 2.0;
        int n3 = tGNoteImpl.getRealValue();
        int n4 = 0;
        n4 = n <= 7 ? (int)((double)SCORE_SHARP_POSITIONS[n3 % 12] * d - (double)(7 * (n3 / 12)) * d) : (int)((double)SCORE_FLAT_POSITIONS[n3 % 12] * d - (double)(7 * (n3 / 12)) * d);
        n4 = (int)((double)n4 + (double)TGMeasureImpl.SCORE_KEY_OFFSETS[n2 - 1] * d);
        return n4;
    }

    public int getY2(ViewLayout viewLayout, int n, int n2, int n3) {
        int n4;
        int n5 = 10;
        float f = TGBeatGroup.getUpOffset(viewLayout);
        float f2 = TGBeatGroup.getDownOffset(viewLayout);
        if (this.direction == 2) {
            int n6;
            if (this.minNote != this.firstMinNote && this.minNote != this.lastMinNote) {
                return (int)((float)this.getY1(viewLayout, this.minNote, n2, n3) + f2);
            }
            int n7 = 0;
            int n8 = this.firstMinNote.getPosX() + this.firstMinNote.getBeatImpl().getSpacing();
            int n9 = this.lastMinNote.getPosX() + this.lastMinNote.getBeatImpl().getSpacing();
            int n10 = (int)((float)this.getY1(viewLayout, this.firstMinNote, n2, n3) + f2);
            if (n10 > (n6 = (int)((float)this.getY1(viewLayout, this.lastMinNote, n2, n3) + f2)) && n10 - n6 > n5) {
                n6 = n10 - n5;
            }
            if (n6 > n10 && n6 - n10 > n5) {
                n10 = n6 - n5;
            }
            if (n10 - n6 != 0 && n8 - n9 != 0 && n8 - n != 0) {
                n7 = (int)(((double)n10 - (double)n6) / ((double)n8 - (double)n9) * ((double)n8 - (double)n));
            }
            return n10 - n7;
        }
        if (this.maxNote != this.firstMaxNote && this.maxNote != this.lastMaxNote) {
            return (int)((float)this.getY1(viewLayout, this.maxNote, n2, n3) - f);
        }
        int n11 = 0;
        int n12 = this.firstMaxNote.getPosX() + this.firstMaxNote.getBeatImpl().getSpacing();
        int n13 = this.lastMaxNote.getPosX() + this.lastMaxNote.getBeatImpl().getSpacing();
        int n14 = (int)((float)this.getY1(viewLayout, this.firstMaxNote, n2, n3) - f);
        if (n14 < (n4 = (int)((float)this.getY1(viewLayout, this.lastMaxNote, n2, n3) - f)) && n4 - n14 > n5) {
            n4 = n14 + n5;
        }
        if (n4 < n14 && n14 - n4 > n5) {
            n14 = n4 + n5;
        }
        if (n14 - n4 != 0 && n12 - n13 != 0 && n12 - n != 0) {
            n11 = (int)(((double)n14 - (double)n4) / ((double)n12 - (double)n13) * ((double)n12 - (double)n));
        }
        return n14 - n11;
    }

    public int getDirection() {
        return this.direction;
    }

    public TGNoteImpl getMinNote() {
        return this.minNote;
    }

    public TGNoteImpl getMaxNote() {
        return this.maxNote;
    }

    public static float getUpOffset(ViewLayout viewLayout) {
        float f = (float)viewLayout.getScoreLineSpacing() / 8.0f;
        return 28.0f * f;
    }

    public static float getDownOffset(ViewLayout viewLayout) {
        float f = (float)viewLayout.getScoreLineSpacing() / 8.0f;
        return 35.0f * f;
    }
}

