/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.piano;

import java.util.Properties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class PianoConfig {
    private static final int MINIMUM_CONTROL_WIDTH = 180;
    private static final int MINIMUM_BUTTON_WIDTH = 80;
    private static final int MINIMUM_BUTTON_HEIGHT = 25;
    private Color colorNatural;
    private Color colorNotNatural;
    private Color colorNote;
    private Color colorScale;

    public Color getColorNatural() {
        return this.colorNatural;
    }

    public Color getColorNotNatural() {
        return this.colorNotNatural;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public void load() {
        Display display = TuxGuitar.instance().getDisplay();
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        this.colorNatural = new Color((Device)display, tGConfigManager.getRGBConfigValue("piano.color.natural-key"));
        this.colorNotNatural = new Color((Device)display, tGConfigManager.getRGBConfigValue("piano.color.not-natural-key"));
        this.colorNote = new Color((Device)display, tGConfigManager.getRGBConfigValue("piano.color.note"));
        this.colorScale = new Color((Device)display, tGConfigManager.getRGBConfigValue("piano.color.scale"));
    }

    public void defaults() {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        Properties properties = tGConfigManager.getDefaults();
        tGConfigManager.setProperty("piano.color.natural-key", properties.getProperty("piano.color.natural-key"));
        tGConfigManager.setProperty("piano.color.not-natural-key", properties.getProperty("piano.color.not-natural-key"));
        tGConfigManager.setProperty("piano.color.note", properties.getProperty("piano.color.note"));
        tGConfigManager.setProperty("piano.color.scale", properties.getProperty("piano.color.scale"));
    }

    public void save(RGB rGB, RGB rGB2, RGB rGB3, RGB rGB4) {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        tGConfigManager.setProperty("piano.color.natural-key", rGB);
        tGConfigManager.setProperty("piano.color.not-natural-key", rGB2);
        tGConfigManager.setProperty("piano.color.note", rGB3);
        tGConfigManager.setProperty("piano.color.scale", rGB4);
    }

    public void dispose() {
        this.colorNatural.dispose();
        this.colorNotNatural.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
    }

    public void configure(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("piano.settings"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("piano.settings"));
        final RGB rGB = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.natural-key-color"), this.colorNatural.getRGB());
        final RGB rGB2 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.not-natural-key-color"), this.colorNotNatural.getRGB());
        final RGB rGB3 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.note-color"), this.colorNote.getRGB());
        final RGB rGB4 = this.getColorChooser((Composite)group, TuxGuitar.getProperty("piano.scale-note-color"), this.colorScale.getRGB());
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("defaults"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                PianoConfig.this.defaults();
                PianoConfig.this.applyChanges();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                PianoConfig.this.save(rGB, rGB2, rGB3, rGB4);
                PianoConfig.this.applyChanges();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button2);
        DialogUtils.openDialog(shell2, 11);
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(Composite composite, String string, RGB rGB) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        ButtonColor buttonColor = new ButtonColor(composite, 8, TuxGuitar.getProperty("choose"));
        buttonColor.setLayoutData(this.getAlignmentData(180, 4));
        buttonColor.loadColor(rGB);
        return buttonColor.getValue();
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private class ButtonColor {
        protected Button button;
        protected Color color;
        protected RGB value = new RGB(0, 0, 0);

        public ButtonColor(Composite composite, int n, String string) {
            this.button = new Button(composite, n);
            this.button.setText(string);
            this.addListeners();
        }

        protected void setLayoutData(Object object) {
            this.button.setLayoutData(object);
        }

        protected void loadColor(RGB rGB) {
            this.value.red = rGB.red;
            this.value.green = rGB.green;
            this.value.blue = rGB.blue;
            Color color = new Color((Device)this.button.getDisplay(), this.value);
            this.button.setForeground(color);
            this.disposeColor();
            this.color = color;
        }

        protected void disposeColor() {
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
                this.color = null;
            }
        }

        private void addListeners() {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ColorDialog colorDialog = new ColorDialog(ButtonColor.this.button.getShell());
                    colorDialog.setRGB(ButtonColor.this.value);
                    colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rGB = colorDialog.open();
                    if (rGB != null) {
                        ButtonColor.this.loadColor(rGB);
                    }
                }
            });
            this.button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    ButtonColor.this.disposeColor();
                }
            });
        }

        protected RGB getValue() {
            return this.value;
        }
    }
}

