/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.TGChord;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ChordXMLReader {
    public static List getChords(String string) {
        ArrayList arrayList = new ArrayList();
        try {
            File file = new File(string);
            if (file.exists()) {
                Document document = ChordXMLReader.getDocument(file);
                ChordXMLReader.loadChords(document.getFirstChild(), arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static Document getDocument(File file) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    private static void loadChords(Node node, List list) {
        try {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("chord")) continue;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string = namedNodeMap.getNamedItem("name").getNodeValue();
                String string2 = namedNodeMap.getNamedItem("strings").getNodeValue();
                String string3 = namedNodeMap.getNamedItem("first-fret").getNodeValue();
                TGChord tGChord = TuxGuitar.instance().getSongManager().getFactory().newChord(Integer.parseInt(string2));
                tGChord.setName(string);
                tGChord.setFirstFret(Integer.parseInt(string3));
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    if (!node3.getNodeName().equals("string")) continue;
                    NamedNodeMap namedNodeMap2 = node3.getAttributes();
                    String string4 = namedNodeMap2.getNamedItem("number").getNodeValue();
                    String string5 = namedNodeMap2.getNamedItem("fret").getNodeValue();
                    tGChord.addFretValue(Integer.parseInt(string4), Integer.parseInt(string5));
                }
                list.add(tGChord);
            }
        }
        catch (Exception exception) {
            list.clear();
            exception.printStackTrace();
        }
    }
}

