/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import java.io.File;
import java.util.List;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.xml.ChordXMLReader;
import org.herac.tuxguitar.gui.editors.chord.xml.ChordXMLWriter;
import org.herac.tuxguitar.gui.util.TGFileUtils;
import org.herac.tuxguitar.song.models.TGChord;

public class CustomChordManager {
    private long lastEdit;
    private List chords = ChordXMLReader.getChords(CustomChordManager.getUserFileName());

    public CustomChordManager() {
        this.setLastEdit();
    }

    public int countChords() {
        return this.chords.size();
    }

    public TGChord getChord(int n) {
        if (n >= 0 && n < this.countChords()) {
            return ((TGChord)this.chords.get(n)).clone(TuxGuitar.instance().getSongManager().getFactory());
        }
        return null;
    }

    public void addChord(TGChord tGChord) {
        this.chords.add(tGChord);
        this.setLastEdit();
    }

    public void removeChord(int n) {
        if (n >= 0 && n < this.countChords()) {
            this.chords.remove(n);
            this.setLastEdit();
        }
    }

    public void renameChord(int n, String string) {
        if (n >= 0 && n < this.countChords()) {
            ((TGChord)this.chords.get(n)).setName(string);
            this.setLastEdit();
        }
    }

    public boolean existOtherEqualCustomChord(String string, int n) {
        for (int i = 0; i < this.countChords(); ++i) {
            TGChord tGChord = this.getChord(i);
            if (!tGChord.getName().equals(string) || n == i) continue;
            return true;
        }
        return false;
    }

    public void write() {
        ChordXMLWriter.setChords(this.chords, CustomChordManager.getUserFileName());
    }

    private static String getUserFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "customchords.xml";
    }

    private void setLastEdit() {
        this.lastEdit = System.currentTimeMillis();
    }

    public long getLastEdit() {
        return this.lastEdit;
    }
}

