/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.clipboard;

import java.util.Iterator;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.clipboard.CannotInsertTransferException;
import org.herac.tuxguitar.gui.clipboard.Transferable;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableInsertMeasure;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableReplaceMeasures;
import org.herac.tuxguitar.song.helpers.TGSongSegment;
import org.herac.tuxguitar.song.helpers.TGSongSegmentHelper;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class MeasureTransferable
implements Transferable {
    public static final int TRANSFER_TYPE_REPLACE = 1;
    public static final int TRANSFER_TYPE_INSERT = 2;
    private TablatureEditor tablatureEditor;
    private TGSongSegment segment;
    private int transferType;
    private int pasteCount;

    public MeasureTransferable(TablatureEditor tablatureEditor, int n, int n2, boolean bl) {
        this.tablatureEditor = tablatureEditor;
        this.transferType = 1;
        this.getTransfer(n, n2, bl);
    }

    private void getTransfer(int n, int n2, boolean bl) {
        if (bl) {
            this.segment = new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).copyMeasures(n, n2);
        } else {
            TGTrackImpl tGTrackImpl = this.tablatureEditor.getTablature().getCaret().getTrack();
            this.segment = new TGSongSegmentHelper(TuxGuitar.instance().getSongManager()).copyMeasures(n, n2, tGTrackImpl);
        }
        this.skipMarkers(this.segment);
    }

    public void insertTransfer() throws CannotInsertTransferException {
        TGSongSegmentHelper tGSongSegmentHelper = new TGSongSegmentHelper(TuxGuitar.instance().getSongManager());
        TGSongSegment tGSongSegment = tGSongSegmentHelper.createSegmentCopies(this.segment, this.pasteCount);
        if (this.transferType == 1) {
            this.replaceMeasures(tGSongSegmentHelper, tGSongSegment);
        } else if (this.transferType == 2) {
            this.insertMeasures(tGSongSegmentHelper, tGSongSegment);
        }
    }

    public void insertMeasures(TGSongSegmentHelper tGSongSegmentHelper, TGSongSegment tGSongSegment) throws CannotInsertTransferException {
        TGMeasureImpl tGMeasureImpl = this.tablatureEditor.getTablature().getCaret().getMeasure();
        TGTrackImpl tGTrackImpl = this.tablatureEditor.getTablature().getCaret().getTrack();
        if (tGMeasureImpl == null || tGSongSegment.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        int n = tGSongSegment.getTracks().size() == 1 ? tGTrackImpl.getNumber() : 0;
        UndoableInsertMeasure undoableInsertMeasure = new UndoableInsertMeasure(n);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)tGSongSegment.getHeaders().get(0);
        int n2 = tGMeasureImpl.getNumber();
        long l = tGMeasureImpl.getStart() - tGMeasureHeader.getStart();
        tGSongSegmentHelper.insertMeasures(tGSongSegment.clone(TuxGuitar.instance().getSongManager().getFactory()), n2, l, n);
        TuxGuitar.instance().getUndoableManager().addEdit(undoableInsertMeasure.endUndo(tGSongSegment.clone(TuxGuitar.instance().getSongManager().getFactory()), tGSongSegment.getHeaders().size(), n2, l));
    }

    public void replaceMeasures(TGSongSegmentHelper tGSongSegmentHelper, TGSongSegment tGSongSegment) throws CannotInsertTransferException {
        TGMeasureImpl tGMeasureImpl = this.tablatureEditor.getTablature().getCaret().getMeasure();
        TGTrackImpl tGTrackImpl = this.tablatureEditor.getTablature().getCaret().getTrack();
        if (tGMeasureImpl == null || tGSongSegment.isEmpty()) {
            throw new CannotInsertTransferException();
        }
        TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)tGSongSegment.getHeaders().get(0);
        int n = tGSongSegment.getTracks().size() == 1 ? tGTrackImpl.getNumber() : 0;
        int n2 = tGSongSegment.getHeaders().size();
        int n3 = tGMeasureImpl.getNumber();
        int n4 = tGTrackImpl.countMeasures() - (n3 - 1);
        long l = tGMeasureImpl.getStart() - tGMeasureHeader.getStart();
        UndoableReplaceMeasures undoableReplaceMeasures = new UndoableReplaceMeasures(n3, n3 + n2, n);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        for (int i = n4; i < n2; ++i) {
            TuxGuitar.instance().getSongManager().addNewMeasureBeforeEnd();
        }
        tGSongSegmentHelper.replaceMeasures(tGSongSegment.clone(TuxGuitar.instance().getSongManager().getFactory()), l, n);
        TuxGuitar.instance().getUndoableManager().addEdit(undoableReplaceMeasures.endUndo(tGSongSegment.clone(TuxGuitar.instance().getSongManager().getFactory()), n2, n4, l));
    }

    public void setTransferType(int n) {
        this.transferType = n;
    }

    public void setPasteCount(int n) {
        this.pasteCount = n;
    }

    private void skipMarkers(TGSongSegment tGSongSegment) {
        Iterator iterator = tGSongSegment.getHeaders().iterator();
        while (iterator.hasNext()) {
            TGMeasureHeader tGMeasureHeader = (TGMeasureHeader)iterator.next();
            tGMeasureHeader.setMarker(null);
        }
    }
}

