/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.util.TGSynchronizer;

public class MoveBeatsCustomAction
extends Action {
    public static final String NAME = "action.beat.general.move-custom";
    private static final ComboItem[] MOVE_DIRECTIONS = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.direction.right"), new Integer(1)), new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.direction.left"), new Integer(-1))};
    private static final ComboItem[] MOVE_DURATIONS = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("duration.whole"), new Integer(1)), new ComboItem(TuxGuitar.getProperty("duration.half"), new Integer(2)), new ComboItem(TuxGuitar.getProperty("duration.quarter"), new Integer(4)), new ComboItem(TuxGuitar.getProperty("duration.eighth"), new Integer(8)), new ComboItem(TuxGuitar.getProperty("duration.sixteenth"), new Integer(16)), new ComboItem(TuxGuitar.getProperty("duration.thirtysecond"), new Integer(32)), new ComboItem(TuxGuitar.getProperty("duration.sixtyfourth"), new Integer(64))};
    private static final ComboItem[] MOVE_DURATION_TYPES = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.duration.type.normal"), new boolean[]{false, false}), new ComboItem(TuxGuitar.getProperty("duration.dotted"), new boolean[]{true, false}), new ComboItem(TuxGuitar.getProperty("duration.doubledotted"), new boolean[]{false, true})};
    private static final ComboItem[] MOVE_DURATION_DIVISIONS = new ComboItem[]{new ComboItem(TuxGuitar.getProperty("beat.move-custom.dialog.duration.division-type.normal"), new int[]{1, 1}), new ComboItem("3", new int[]{3, 2}), new ComboItem("5", new int[]{5, 4}), new ComboItem("6", new int[]{6, 4}), new ComboItem("7", new int[]{7, 4}), new ComboItem("9", new int[]{9, 8}), new ComboItem("10", new int[]{10, 8}), new ComboItem("11", new int[]{11, 8}), new ComboItem("12", new int[]{12, 8})};

    public MoveBeatsCustomAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    protected void showDialog(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("beat.move-custom.dialog.title"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("beat.move-custom.dialog.direction-tip"));
        Label label = new Label((Composite)group, 131072);
        label.setText(TuxGuitar.getProperty("beat.move-custom.dialog.direction") + ":");
        final Combo combo = new Combo((Composite)group, 12);
        for (int i = 0; i < MOVE_DIRECTIONS.length; ++i) {
            combo.add(MOVE_DIRECTIONS[i].getLabel());
        }
        combo.select(0);
        combo.setLayoutData((Object)new GridData(4, 4, true, true));
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        Group group2 = new Group((Composite)shell2, 16);
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setLayoutData((Object)new GridData(4, 4, true, true));
        group2.setText(TuxGuitar.getProperty("beat.move-custom.dialog.move-1.tip"));
        Label label2 = new Label((Composite)group2, 131072);
        label2.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label2.setText(TuxGuitar.getProperty("beat.move-custom.dialog.count") + ":");
        final Spinner spinner = new Spinner((Composite)group2, 2048);
        spinner.setLayoutData((Object)new GridData(4, 4, true, true));
        spinner.setMinimum(0);
        spinner.setMaximum(100);
        spinner.setIncrement(1);
        spinner.setSelection(0);
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MoveBeatsCustomAction.this.updateControls(spinner.getSelection(), arrayList);
            }
        });
        Label label3 = new Label((Composite)group2, 131072);
        label3.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label3.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration") + ":");
        arrayList.add(label3);
        final Combo combo2 = new Combo((Composite)group2, 12);
        combo2.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATIONS.length; ++i) {
            combo2.add(MOVE_DURATIONS[i].getLabel());
        }
        combo2.select(0);
        arrayList.add(combo2);
        this.updateControls(0, arrayList);
        final ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Group group3 = new Group((Composite)shell2, 16);
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setLayoutData((Object)new GridData(4, 4, true, true));
        group3.setText(TuxGuitar.getProperty("beat.move-custom.dialog.move-2.tip"));
        Label label4 = new Label((Composite)group3, 131072);
        label4.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label4.setText(TuxGuitar.getProperty("beat.move-custom.dialog.count") + ":");
        final Spinner spinner2 = new Spinner((Composite)group3, 2048);
        spinner2.setLayoutData((Object)new GridData(4, 4, true, true));
        spinner2.setSelection(0);
        spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MoveBeatsCustomAction.this.updateControls(spinner2.getSelection(), arrayList2);
            }
        });
        Label label5 = new Label((Composite)group3, 131072);
        label5.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label5.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration") + ":");
        arrayList2.add(label5);
        final Combo combo3 = new Combo((Composite)group3, 12);
        combo3.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATIONS.length; ++i) {
            combo3.add(MOVE_DURATIONS[i].getLabel());
        }
        combo3.select(2);
        arrayList2.add(combo3);
        Label label6 = new Label((Composite)group3, 131072);
        label6.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label6.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration.type") + ":");
        arrayList2.add(label6);
        final Combo combo4 = new Combo((Composite)group3, 12);
        combo4.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATION_TYPES.length; ++i) {
            combo4.add(MOVE_DURATION_TYPES[i].getLabel());
        }
        combo4.select(0);
        arrayList2.add(combo4);
        Label label7 = new Label((Composite)group3, 131072);
        label7.setLayoutData((Object)new GridData(131072, 0x1000000, true, true));
        label7.setText(TuxGuitar.getProperty("beat.move-custom.dialog.duration.division-type") + ":");
        arrayList2.add(label7);
        final Combo combo5 = new Combo((Composite)group3, 12);
        combo5.setLayoutData((Object)new GridData(4, 4, true, true));
        for (int i = 0; i < MOVE_DURATION_DIVISIONS.length; ++i) {
            combo5.add(MOVE_DURATION_DIVISIONS[i].getLabel());
        }
        combo5.select(0);
        arrayList2.add(combo5);
        this.updateControls(0, arrayList2);
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)this.getButtonData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = MoveBeatsCustomAction.this.getDirection(combo.getSelectionIndex());
                long l = MoveBeatsCustomAction.this.getDuration1(combo2.getSelectionIndex(), spinner.getSelection());
                long l2 = MoveBeatsCustomAction.this.getDuration2(combo3.getSelectionIndex(), combo4.getSelectionIndex(), combo5.getSelectionIndex(), spinner2.getSelection());
                final long l3 = (l + l2) * (long)n;
                shell2.dispose();
                try {
                    TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                        public void run() throws Throwable {
                            ActionLock.lock();
                            TuxGuitar.instance().loadCursor(1);
                            MoveBeatsCustomAction.this.moveBeats(l3);
                            TuxGuitar.instance().updateCache(true);
                            TuxGuitar.instance().loadCursor(0);
                            ActionLock.unlock();
                        }
                    });
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button);
        DialogUtils.openDialog(shell2, 11);
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected int getDirection(int n) {
        if (n >= 0 && n < MOVE_DIRECTIONS.length) {
            return (Integer)MOVE_DIRECTIONS[n].getValue();
        }
        return 0;
    }

    protected long getDuration1(int n, int n2) {
        if (n2 > 0 && n >= 0 && n < MOVE_DURATIONS.length) {
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            tGDuration.setValue((Integer)MOVE_DURATIONS[n].getValue());
            tGDuration.setDotted(false);
            tGDuration.setDoubleDotted(false);
            tGDuration.getDivision().setTimes(1);
            tGDuration.getDivision().setEnters(1);
            return tGDuration.getTime() * (long)n2;
        }
        return 0L;
    }

    protected long getDuration2(int n, int n2, int n3, int n4) {
        if (n4 > 0 && n >= 0 && n < MOVE_DURATIONS.length && n2 >= 0 && n2 < MOVE_DURATION_TYPES.length && n3 >= 0 && n3 < MOVE_DURATION_DIVISIONS.length) {
            TGDuration tGDuration = this.getSongManager().getFactory().newDuration();
            tGDuration.setValue((Integer)MOVE_DURATIONS[n].getValue());
            tGDuration.setDotted(((boolean[])MOVE_DURATION_TYPES[n2].getValue())[0]);
            tGDuration.setDoubleDotted(((boolean[])MOVE_DURATION_TYPES[n2].getValue())[1]);
            tGDuration.getDivision().setEnters(((int[])MOVE_DURATION_DIVISIONS[n3].getValue())[0]);
            tGDuration.getDivision().setTimes(((int[])MOVE_DURATION_DIVISIONS[n3].getValue())[1]);
            return tGDuration.getTime() * (long)n4;
        }
        return 0L;
    }

    protected void updateControls(int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Control control = (Control)iterator.next();
            control.setEnabled(n > 0);
        }
    }

    protected int moveBeats(long l) {
        Caret caret = this.getEditor().getTablature().getCaret();
        TGBeatImpl tGBeatImpl = caret.getSelectedBeat();
        TGMeasureImpl tGMeasureImpl = caret.getMeasure();
        TGTrackImpl tGTrackImpl = caret.getTrack();
        if (tGBeatImpl != null && tGMeasureImpl != null && tGTrackImpl != null) {
            UndoableTrackGeneric undoableTrackGeneric = UndoableTrackGeneric.startUndo(tGTrackImpl);
            this.getSongManager().getTrackManager().moveTrackBeats(tGTrackImpl, tGMeasureImpl.getStart(), tGBeatImpl.getStart(), l);
            this.addUndoableEdit(undoableTrackGeneric.endUndo(tGTrackImpl));
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.updateTablature();
        }
        return 0;
    }

    protected static class ComboItem {
        private String label;
        private Object value;

        public ComboItem(String string, Object object) {
            this.label = string;
            this.value = object;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

