/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGNote;

public class ChangeNoteAction
extends Action {
    public static final String NAME = "action.note.general.change";
    private static final int DELAY = 1000;
    private static int lastAddedValue;
    private static int lastAddedString;
    private static long lastAddedStart;
    private static long lastAddedTime;

    public ChangeNoteAction() {
        super(NAME, 19);
    }

    protected int execute(TypedEvent typedEvent) {
        int n;
        if (typedEvent instanceof KeyEvent && (n = this.getValueOf(((KeyEvent)typedEvent).keyCode)) >= 0) {
            int n2;
            Caret caret = this.getEditor().getTablature().getCaret();
            TGMeasureImpl tGMeasureImpl = caret.getMeasure();
            TGDuration tGDuration = caret.getDuration();
            int n3 = caret.getSelectedString().getNumber();
            int n4 = caret.getVelocity();
            long l = caret.getPosition();
            long l2 = System.currentTimeMillis();
            if (lastAddedStart == l && lastAddedString == n3 && lastAddedValue > 0 && lastAddedValue < 10 && l2 < lastAddedTime + 1000L && ((n2 = lastAddedValue * 10 + n) < 30 || caret.getTrack().isPercussionTrack())) {
                n = n2;
            }
            this.addNote(tGMeasureImpl, tGDuration, l, n, n3, n4);
            this.fireUpdate(tGMeasureImpl.getNumber());
            lastAddedValue = n;
            lastAddedStart = l;
            lastAddedString = n3;
            lastAddedTime = l2;
            return 4;
        }
        return 0;
    }

    private void addNote(TGMeasureImpl tGMeasureImpl, TGDuration tGDuration, long l, int n, int n2, int n3) {
        TGNote tGNote = this.getSongManager().getFactory().newNote();
        tGNote.setValue(n);
        tGNote.setVelocity(n3);
        tGNote.setString(n2);
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.getSongManager().getMeasureManager().addNote(tGMeasureImpl, l, tGNote, tGDuration.clone(this.getSongManager().getFactory()), this.getEditor().getTablature().getCaret().getVoice());
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        this.getEditor().getTablature().getCaret().getSelectedBeat().play();
    }

    private int getValueOf(int n) {
        switch (n) {
            case 48: 
            case 0x1000030: {
                return 0;
            }
            case 49: 
            case 0x1000031: {
                return 1;
            }
            case 50: 
            case 16777266: {
                return 2;
            }
            case 51: 
            case 0x1000033: {
                return 3;
            }
            case 52: 
            case 16777268: {
                return 4;
            }
            case 53: 
            case 16777269: {
                return 5;
            }
            case 54: 
            case 16777270: {
                return 6;
            }
            case 55: 
            case 16777271: {
                return 7;
            }
            case 56: 
            case 16777272: {
                return 8;
            }
            case 57: 
            case 16777273: {
                return 9;
            }
        }
        return -1;
    }
}

