/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.measure;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.undo.undoables.UndoableJoined;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class AddMeasureAction
extends Action {
    public static final String NAME = "action.measure.add";

    public AddMeasureAction() {
        super(NAME, 27);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog();
        return 0;
    }

    public void showDialog() {
        if (this.getEditor().getTablature().getCaret().getMeasure() != null) {
            final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
            shell.setLayout((Layout)new GridLayout());
            shell.setText(TuxGuitar.getProperty("measure.add"));
            Group group = new Group((Composite)shell, 16);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("measure.add"));
            Label label = new Label((Composite)group, 0);
            label.setText(TuxGuitar.getProperty("measure.add.count"));
            final Spinner spinner = new Spinner((Composite)group, 2048);
            spinner.setLayoutData((Object)this.getSpinnerData());
            spinner.setMinimum(1);
            spinner.setMaximum(100);
            spinner.setSelection(1);
            Group group2 = new Group((Composite)shell, 16);
            group2.setLayout((Layout)new GridLayout());
            group2.setLayoutData((Object)new GridData(4, 4, true, true));
            group2.setText(TuxGuitar.getProperty("options"));
            final Button button = new Button((Composite)group2, 16);
            button.setText(TuxGuitar.getProperty("measure.add-before-current-position"));
            final Button button2 = new Button((Composite)group2, 16);
            button2.setText(TuxGuitar.getProperty("measure.add-after-current-position"));
            final Button button3 = new Button((Composite)group2, 16);
            button3.setText(TuxGuitar.getProperty("measure.add-at-end"));
            button3.setSelection(true);
            Composite composite = new Composite((Composite)shell, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            Button button4 = new Button(composite, 8);
            button4.setText(TuxGuitar.getProperty("ok"));
            button4.setLayoutData((Object)this.getButtonData());
            button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = 0;
                    int n2 = spinner.getSelection();
                    if (button.getSelection()) {
                        n = AddMeasureAction.this.getEditor().getTablature().getCaret().getMeasure().getNumber();
                    } else if (button2.getSelection()) {
                        n = AddMeasureAction.this.getEditor().getTablature().getCaret().getMeasure().getNumber() + 1;
                    } else if (button3.getSelection()) {
                        n = AddMeasureAction.this.getSongManager().getSong().countMeasureHeaders() + 1;
                    }
                    AddMeasureAction.this.addMeasure(n, n2);
                    shell.dispose();
                }
            });
            Button button5 = new Button(composite, 8);
            button5.setText(TuxGuitar.getProperty("cancel"));
            button5.setLayoutData((Object)this.getButtonData());
            button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell.dispose();
                }
            });
            shell.setDefaultButton(button4);
            DialogUtils.openDialog(shell, 11);
        }
    }

    private GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void addMeasure(final int n, final int n2) {
        if (n2 > 0 && n > 0 && n <= this.getSongManager().getSong().countMeasureHeaders() + 1) {
            new Thread(new Runnable(){

                public void run() {
                    new SyncThread(new Runnable(){

                        public void run() {
                            int n;
                            UndoableJoined undoableJoined = new UndoableJoined();
                            for (n = 0; n < n2; ++n) {
                                UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo(n + n);
                                AddMeasureAction.this.getSongManager().addNewMeasure(n + n);
                                undoableJoined.addUndoableEdit(undoableAddMeasure.endUndo());
                            }
                            AddMeasureAction.this.updateTablature();
                            n = AddMeasureAction.this.getEditor().getTablature().getCaret().getTrack().getNumber();
                            int n2 = AddMeasureAction.this.getEditor().getTablature().getCaret().getStringNumber();
                            long l = AddMeasureAction.this.getSongManager().getMeasureHeader(n).getStart();
                            AddMeasureAction.this.getEditor().getTablature().getCaret().update(n, l, n2);
                            AddMeasureAction.this.addUndoableEdit(undoableJoined.endUndo());
                            TuxGuitar.instance().getFileHistory().setUnsavedFile();
                            TuxGuitar.instance().updateCache(true);
                        }
                    }).start();
                }
            }).start();
        }
    }
}

