/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDuration;

public class SetSixteenthDurationAction
extends Action {
    public static final String NAME = "action.note.duration.set-sixteenth";
    public static final int VALUE = 16;

    public SetSixteenthDurationAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        if (this.getSelectedDuration().getValue() != 16) {
            UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
            this.getSelectedDuration().setValue(16);
            this.getSelectedDuration().setDotted(false);
            this.getSelectedDuration().setDoubleDotted(false);
            this.setDurations();
            this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        }
        return 0;
    }

    private void setDurations() {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.changeDuration(this.getSelectedDuration().clone(this.getSongManager().getFactory()));
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }

    public TGDuration getSelectedDuration() {
        return this.getEditor().getTablature().getCaret().getDuration();
    }
}

