/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.duration;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;

public class ChangeDivisionTypeAction
extends Action {
    public static final String NAME = "action.note.duration.change-division-type";

    public ChangeDivisionTypeAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        boolean bl = false;
        if (typedEvent instanceof KeyEvent) {
            bl = true;
        }
        if (!bl) {
            TGDivisionType tGDivisionType = this.defaultDivisionType();
            if (typedEvent.widget.getData() != null && typedEvent.widget.getData() instanceof TGDivisionType) {
                tGDivisionType = (TGDivisionType)typedEvent.widget.getData();
            }
            if (this.getSelectedDuration().getDivision().isEqual(tGDivisionType)) {
                this.setDivisionType(this.noTuplet());
            } else {
                this.setDivisionType(tGDivisionType);
            }
        } else if (this.getSelectedDuration().getDivision().isEqual(TGDivisionType.NORMAL)) {
            this.setDivisionType(this.defaultDivisionType());
        } else {
            this.setDivisionType(this.noTuplet());
        }
        this.setDurations();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        return 0;
    }

    private TGDivisionType noTuplet() {
        TGDivisionType tGDivisionType = this.getSongManager().getFactory().newDivisionType();
        tGDivisionType.setEnters(1);
        tGDivisionType.setTimes(1);
        return tGDivisionType;
    }

    private TGDivisionType defaultDivisionType() {
        TGDivisionType tGDivisionType = this.getSongManager().getFactory().newDivisionType();
        tGDivisionType.setEnters(3);
        tGDivisionType.setTimes(2);
        return tGDivisionType;
    }

    private void setDivisionType(TGDivisionType tGDivisionType) {
        this.getSelectedDuration().getDivision().setEnters(tGDivisionType.getEnters());
        this.getSelectedDuration().getDivision().setTimes(tGDivisionType.getTimes());
    }

    private void setDurations() {
        Caret caret = this.getEditor().getTablature().getCaret();
        caret.changeDuration(this.getSelectedDuration().clone(this.getSongManager().getFactory()));
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }

    public TGDuration getSelectedDuration() {
        return this.getEditor().getTablature().getCaret().getDuration();
    }
}

