/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTripletFeel;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.util.TGSynchronizer;

public class ChangeTripletFeelAction
extends Action {
    public static final String NAME = "action.composition.change-triplet-feel";

    public ChangeTripletFeelAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout((Layout)new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.tripletfeel"));
            shell2.setMinimumSize(300, 0);
            Group group = new Group((Composite)shell2, 16);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.tripletfeel"));
            final Button button = new Button((Composite)group, 16);
            button.setText(TuxGuitar.getProperty("composition.tripletfeel.none"));
            button.setSelection(tGMeasureImpl.getTripletFeel() == 1);
            final Button button2 = new Button((Composite)group, 16);
            button2.setText(TuxGuitar.getProperty("composition.tripletfeel.eighth"));
            button2.setSelection(tGMeasureImpl.getTripletFeel() == 2);
            final Button button3 = new Button((Composite)group, 16);
            button3.setText(TuxGuitar.getProperty("composition.tripletfeel.sixteenth"));
            button3.setSelection(tGMeasureImpl.getTripletFeel() == 3);
            Group group2 = new Group((Composite)shell2, 16);
            group2.setLayout((Layout)new GridLayout());
            group2.setLayoutData((Object)new GridData(4, 4, true, true));
            group2.setText(TuxGuitar.getProperty("options"));
            final Button button4 = new Button((Composite)group2, 32);
            button4.setText(TuxGuitar.getProperty("composition.tripletfeel.to-the-end"));
            button4.setSelection(true);
            Composite composite = new Composite((Composite)shell2, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
            Button button5 = new Button(composite, 8);
            button5.setText(TuxGuitar.getProperty("ok"));
            button5.setLayoutData((Object)this.getButtonData());
            button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    final boolean bl = button4.getSelection();
                    final int n = ChangeTripletFeelAction.this.getSelectedTripletFeel(button, button2, button3);
                    shell2.dispose();
                    try {
                        TGSynchronizer.instance().runLater(new TGSynchronizer.TGRunnable(){

                            public void run() throws Throwable {
                                ActionLock.lock();
                                TuxGuitar.instance().loadCursor(1);
                                ChangeTripletFeelAction.this.setTripletFeel(n, bl);
                                TuxGuitar.instance().updateCache(true);
                                TuxGuitar.instance().loadCursor(0);
                                ActionLock.unlock();
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        MessageDialog.errorMessage(throwable);
                    }
                }
            });
            Button button6 = new Button(composite, 8);
            button6.setLayoutData((Object)this.getButtonData());
            button6.setText(TuxGuitar.getProperty("cancel"));
            button6.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button5);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected int getSelectedTripletFeel(Button button, Button button2, Button button3) {
        if (button.getSelection()) {
            return 1;
        }
        if (button2.getSelection()) {
            return 2;
        }
        if (button3.getSelection()) {
            return 3;
        }
        return 1;
    }

    protected void setTripletFeel(int n, boolean bl) {
        UndoableChangeTripletFeel undoableChangeTripletFeel = UndoableChangeTripletFeel.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        TGMeasureImpl tGMeasureImpl = caret.getMeasure();
        this.getSongManager().changeTripletFeel(tGMeasureImpl.getStart(), n, bl);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableChangeTripletFeel.endUndo(n, bl));
    }
}

