/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.utils;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;

public class TGCommunityWeb {
    public static String HOME_URL = TGCommunitySingleton.getInstance().getConfig().getStringConfigValue("community.url");

    public static void open(String string) {
        try {
            TGCommunityWeb.open(new URL(HOME_URL + "/" + string));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public static boolean open(URL uRL) {
        if (TGCommunityWeb.openDesktopBrowser(uRL)) {
            return true;
        }
        return TGCommunityWeb.openCommandLineBrowser(uRL);
    }

    private static boolean openDesktopBrowser(URL uRL) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            if (clazz != null) {
                Object object;
                Method method = clazz.getDeclaredMethod("getDesktop", new Class[0]);
                Method method2 = clazz.getDeclaredMethod("browse", URI.class);
                if (method != null && method2 != null && (object = method.invoke(null, new Object[0])) != null) {
                    method2.invoke(object, new URI(uRL.toExternalForm()));
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean openCommandLineBrowser(URL uRL) {
        TGConfigManager tGConfigManager = TGCommunitySingleton.getInstance().getConfig();
        String[] stringArray = tGConfigManager.getStringConfigValue("community.browser", "").split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string;
                int n;
                String string2 = stringArray[i];
                if (string2 == null || string2.length() <= 0 || (n = string2.indexOf(string = "%s")) < 0) continue;
                String string3 = new String();
                string3 = string3 + string2.substring(0, n);
                string3 = string3 + uRL.toExternalForm();
                if (string2.length() > n + string.length()) {
                    string3 = string3 + string2.substring(n + string.length(), string2.length());
                }
                Runtime.getRuntime().exec(string3);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

