/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TGShareSongResponse {
    private static final String TAG_STATUS = "status";
    private static final String TAG_MESSAGES = "messages";
    private static final String TAG_MESSAGE = "message";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ATTRIBUTE_VALUE = "value";
    private Document document;

    public TGShareSongResponse(InputStream inputStream) throws Throwable {
        this.initialize(inputStream);
    }

    private void initialize(InputStream inputStream) throws Throwable {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.parse(inputStream);
    }

    public String getStatus() throws Throwable {
        if (this.document != null) {
            return this.getStatus(this.document.getFirstChild());
        }
        return null;
    }

    private String getStatus(Node node) throws Throwable {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(TAG_STATUS)) continue;
            return this.getAttributeValue(node2.getAttributes(), ATTRIBUTE_CODE);
        }
        return null;
    }

    public String loadMessages(List list) throws Throwable {
        if (this.document != null) {
            return this.loadMessages(list, this.document.getFirstChild());
        }
        return null;
    }

    private String loadMessages(List list, Node node) throws Throwable {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals(TAG_MESSAGES)) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                if (!node3.getNodeName().equals(TAG_MESSAGE)) continue;
                list.add(this.getAttributeValue(node3.getAttributes(), ATTRIBUTE_VALUE));
            }
        }
        return null;
    }

    private String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        try {
            Node node;
            if (namedNodeMap != null && string != null && (node = namedNodeMap.getNamedItem(string)) != null) {
                return URLDecoder.decode(node.getNodeValue(), "UTF-8");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

