/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import java.io.DataOutputStream;
import java.net.URL;
import java.net.URLConnection;
import org.herac.tuxguitar.community.auth.TGCommunityAuth;
import org.herac.tuxguitar.community.io.TGShareFile;
import org.herac.tuxguitar.community.io.TGShareSongResponse;
import org.herac.tuxguitar.community.utils.TGCommunityWeb;

public class TGShareSongRequest {
    private static final String REMOTE_URL = TGCommunityWeb.HOME_URL + "/rd.php/sharing/tuxguitar/upload.do";
    private static final String EOL = "\r\n";
    private static final String BOUNDARY = "*****";
    private static final String BOUNDARY_SEPARATOR = "--";
    private TGShareFile file;
    private TGCommunityAuth auth;

    public TGShareSongRequest(TGCommunityAuth tGCommunityAuth, TGShareFile tGShareFile) {
        this.auth = tGCommunityAuth;
        this.file = tGShareFile;
    }

    public TGShareSongResponse getResponse() throws Throwable {
        URL uRL = new URL(REMOTE_URL);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        uRLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=*****");
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"auth\";\r\n");
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes(this.auth.getAuthCode());
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"title\";\r\n");
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes(this.file.getTitle());
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"description\";\r\n");
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes(this.file.getDescription());
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"tagkeys\";\r\n");
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes(this.file.getTagkeys());
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes("--*****\r\n");
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"fileName\"; filename=\"" + this.file.getFilename() + "\"" + EOL);
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.write(this.file.getFile());
        dataOutputStream.writeBytes(EOL);
        dataOutputStream.writeBytes("--*****--\r\n");
        dataOutputStream.flush();
        dataOutputStream.close();
        return new TGShareSongResponse(uRLConnection.getInputStream());
    }
}

