/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.io;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.community.TGCommunitySingleton;
import org.herac.tuxguitar.community.auth.TGCommunityAuthDialog;
import org.herac.tuxguitar.community.io.TGShareFile;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TGShareFileDialog {
    private boolean accepted;
    private TGShareFile file;
    private String errors;

    public TGShareFileDialog(TGShareFile tGShareFile, String string) {
        this.file = tGShareFile;
        this.errors = string;
        this.accepted = false;
    }

    public void open() {
        try {
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    if (!TuxGuitar.isDisposed()) {
                        TGShareFileDialog.this.open(TuxGuitar.instance().getShell());
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void open(Shell shell) {
        this.accepted = false;
        final Shell shell2 = DialogUtils.newDialog((Shell)shell, (int)67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setLayoutData((Object)new GridData(4, 4, true, true));
        shell2.setImage(TuxGuitar.instance().getIconManager().getAppIcon());
        shell2.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.title"));
        Group group = new Group((Composite)shell2, 16);
        group.setLayout((Layout)this.makeGroupLayout(5));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details"));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)this.makeLabelData());
        label.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.user") + ":");
        final Text text = new Text((Composite)group, 2056);
        text.setLayoutData((Object)this.makeUsernameTextData());
        text.setText(TGCommunitySingleton.getInstance().getAuth().getUsername());
        Button button = new Button((Composite)group, 8);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGCommunityAuthDialog tGCommunityAuthDialog = new TGCommunityAuthDialog();
                tGCommunityAuthDialog.open(shell2);
                if (tGCommunityAuthDialog.isAccepted()) {
                    TGCommunitySingleton.getInstance().getAuth().update();
                    text.setText(TGCommunitySingleton.getInstance().getAuth().getUsername());
                }
            }
        });
        Label label2 = new Label((Composite)group, 0);
        label2.setLayoutData((Object)this.makeLabelData());
        label2.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.title") + ":");
        final Text text2 = new Text((Composite)group, 2048);
        text2.setLayoutData((Object)this.makeTextData());
        text2.setText(this.file.getTitle());
        Label label3 = new Label((Composite)group, 0);
        label3.setLayoutData((Object)this.makeLabelData());
        label3.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.tagkeys") + ":");
        final Text text3 = new Text((Composite)group, 2048);
        text3.setLayoutData((Object)this.makeTextData());
        text3.setText(this.file.getTagkeys());
        Label label4 = new Label((Composite)group, 0);
        label4.setLayoutData((Object)this.makeLabelData());
        label4.setText(TuxGuitar.getProperty((String)"tuxguitar-community.share-dialog.details.description") + ":");
        final Text text4 = new Text((Composite)group, 2626);
        text4.setLayoutData((Object)this.makeTextAreaData());
        text4.setText(this.file.getDescription());
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(131072, 4, true, true));
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty((String)"ok"));
        button2.setLayoutData((Object)this.getButtonData());
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TGShareFileDialog.this.update(text2.getText(), text3.getText(), text4.getText());
                shell2.dispose();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty((String)"cancel"));
        button3.setLayoutData((Object)this.getButtonData());
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button2);
        if (this.errors != null) {
            MessageDialog.errorMessage((Shell)shell2, (String)this.errors);
        }
        DialogUtils.openDialog((Shell)shell2, (int)11);
    }

    private GridLayout makeGroupLayout(int n) {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginTop = n;
        gridLayout.marginBottom = n;
        gridLayout.marginLeft = n;
        gridLayout.marginRight = n;
        gridLayout.verticalSpacing = n;
        gridLayout.horizontalSpacing = n;
        return gridLayout;
    }

    private GridData makeLabelData() {
        return new GridData(131072, 0x1000000, false, true);
    }

    private GridData makeTextAreaData() {
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.minimumWidth = 250;
        gridData.minimumHeight = 100;
        return gridData;
    }

    private GridData makeTextData() {
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.minimumWidth = 250;
        return gridData;
    }

    private GridData makeUsernameTextData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 250;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void update(String string, String string2, String string3) {
        this.file.setTitle(string);
        this.file.setTagkeys(string2);
        this.file.setDescription(string3);
        this.accepted = true;
    }

    public boolean isAccepted() {
        return this.accepted;
    }
}

