/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.community.auth;

import java.security.MessageDigest;
import org.herac.tuxguitar.community.auth.utils.Base64Decoder;
import org.herac.tuxguitar.community.auth.utils.Base64Encoder;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;

public class TGCommunityAuth {
    private static final String STRING_SEPARATOR = ";";
    private String username = new String();
    private String password = new String();
    private String authCode = new String();

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public boolean isEmpty() {
        return this.username == null || this.password == null || this.username.length() == 0 || this.password.length() == 0;
    }

    public void update() {
        try {
            String string = new String();
            if (this.password != null && this.password.length() > 0) {
                MessageDigest messageDigest = MessageDigest.getInstance("md5");
                messageDigest.update(this.password.getBytes());
                byte[] byArray = messageDigest.digest();
                for (int i = 0; i < byArray.length; ++i) {
                    string = string + Integer.toHexString(byArray[i] >> 4 & 0xF);
                    string = string + Integer.toHexString(byArray[i] & 0xF);
                }
            }
            this.authCode = new String(Base64Encoder.encode(new String(this.username + STRING_SEPARATOR + string).getBytes()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void save(TGConfigManager tGConfigManager) {
        String string = new String(this.getUsername() + STRING_SEPARATOR + this.getPassword());
        String string2 = new String(Base64Encoder.encode(string.getBytes()));
        tGConfigManager.setProperty("community.account", string2);
    }

    public void load(TGConfigManager tGConfigManager) {
        String string;
        String[] stringArray;
        String string2 = tGConfigManager.getStringConfigValue("community.account");
        if (string2 != null && string2.length() > 0 && (stringArray = (string = new String(Base64Decoder.decode(string2.getBytes()))).split(STRING_SEPARATOR)).length == 2) {
            this.setUsername(stringArray[0]);
            this.setPassword(stringArray[1]);
        }
    }
}

