/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Projection/IsometricProjection/IsoProject/Tests/IsoProjectTest02.js
// Timestamp   : 2011-08-05 13:45:17
// Description : isometric projection of a circle using segment length 1

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function IsoProjectTest02() {
    TdbTest.call(this, 'scripts/Projection/IsometricProjection/IsoProject/Tests/IsoProjectTest02.js');
}

IsoProjectTest02.prototype = new TdbTest();

IsoProjectTest02.prototype.test00 = function() {
    qDebug('running IsoProjectTest02.test00()...');
    this.setUp();
    var w = objectFromPath('MainWindow::CadToolsDock::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonPress, new QPoint(44, 436), Qt.LeftButton, 1, 0);
    var w = objectFromPath('MainWindow::CadToolsDock::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonRelease, new QPoint(44, 436), Qt.LeftButton, 0, 0);
    this.importFile('scripts/Projection/IsometricProjection/IsoProject/Tests/data/cube_circle.dxf');
    this.setZoom(6.914994309623345, new RVector(1.69613, 14.7619, 0) );
    var p = new RVector(17.682047, 16.185318);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.triggerCommand('pj');
    this.setZoom(6.914994309623345, new RVector(1.69613, 14.7619, 0) );
    var p = new RVector(10.162156, -0.300595);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('IsoProject/ProjectionType', 'Top');
    this.setToolOption('IsoProject/SegmentLength',  [ 1, 0 ] );
    this.updateToolOptions();
    this.setZoom(6.914994309623345, new RVector(1.69613, 14.7619, 0) );
    var p = new RVector(42.555531, 20.66833);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('IsoProject/ProjectionType', 'Right');
    this.setToolOption('IsoProject/SegmentLength',  [ 1, 0 ] );
    this.updateToolOptions();
    this.setZoom(6.914994309623345, new RVector(1.69613, 14.7619, 0) );
    var p = new RVector(57.595312, 4.760869);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setToolOption('IsoProject/ProjectionType', 'Left');
    this.setToolOption('IsoProject/SegmentLength',  [ 1, 0 ] );
    this.updateToolOptions();
    this.setZoom(6.914994309623345, new RVector(1.69613, 14.7619, 0) );
    var p = new RVector(42.555531, 3.748576);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    var p = new RVector(35.03564, -3.915927);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.RightButton, 2, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.RightButton, 0, 0);
    var p = new RVector(33.589507, -4.205154);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.RightButton, 2, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.RightButton, 0, 0);
    this.verifyDrawing('IsoProjectTest02_000.dxf');
    this.tearDown();
    qDebug('finished IsoProjectTest02.test00()');
};

