/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */

include("../Examples.js");

/**
 * \class IOExamples
 * \brief Base class for all IO examples.
 */
function IOExamples(guiAction) {
    EAction.call(this, guiAction);
}

IOExamples.prototype = new EAction();
IOExamples.includeBasePath = includeBasePath;

IOExamples.getMenu = function() {
    var menu = EAction.getSubMenu(
        Examples.getMenu(),
        150,
        IOExamples.getTitle(),
        "ioExamples"
        //IOExamples.includeBasePath + "/IOExamples.svg"
    );
    return menu;
};

IOExamples.getToolBar = function() {
    var tb = EAction.getToolBar(IOExamples.getTitle(), "IOExamples");
    tb.orientation = Qt.Vertical;
    tb.visible = false;
    return tb;
};

IOExamples.getTitle = function() {
    return qsTr("&Import / Export");
};

IOExamples.prototype.getTitle = function() {
    return IOExamples.getTitle();
};
