"""
import this in __init__.py to enable the extension
see "_project_io.py" or "_pluginloader.py" for more example code
"""

import gtk
from _guicore import PGButler


class ExtensionExample:
    
    def __init__(self):

        # hook into the existing ui
        ui = """
        <ui>
            <menubar name="MenuBar">
                <menu action="Tools">
                    <placeholder name="Tools_1">
                        <menuitem action="ExtensionExampleAction"/>
                    </placeholder>
                </menu>    
           </menubar>
        </ui>
        """

        # register actions        
        actiongroup = gtk.ActionGroup("ExtensionExample")
        actiongroup.add_actions([
            ('ExtensionExampleAction', gtk.STOCK_ABOUT, "extension example", None, "extension example", self.callback),
        ])
        
        # load ui into PGButler
        PGButler.instance.uimanager.insert_action_group(actiongroup, 0)
        PGButler.instance.uimanager.add_ui_from_string(ui)
        
    def callback(self, widget):
        d = gtk.MessageDialog(
                parent=PGButler.instance.win, 
                flags=0,
                type=gtk.MESSAGE_INFO,
                buttons=gtk.BUTTONS_CLOSE,
                message_format="Hello World, I am an extension for mezoGIS!")
        d.run()
        d.destroy()

PGButler.instance.register_extension( ExtensionExample )
