# Copyright (C) 2005-2006 Frederic Back <fredericback@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
"""
Base classes to implement a plugin for mezoGIS. Note that an external
launcher can start the scripts: You do not need to run mezoGIS to start
a plugin script.
"""

import os
from _dbtools import *
from GeoTypes import *

class Argument:
    ttable      = 0
    tstring     = 1
    tnumber     = 2
    tfloat      = 3

    tfilesave   = 4 # open a file for writing
    tfileopen   = 5 # open a file for reading

    def __init__(self, datatype, description = "", value = None):
        """ datatype should be one of the class variables defined above """
        self.datatype = datatype
        self.description = description
        self.value = value

    def set(self, value):
        if self.datatype == Argument.tnumber:
            try: self.value = int(value)
            except: raise ValueError, "%s is not a valid integer number"%value
        elif self.datatype == Argument.tfloat: 
            try: self.value = float(value)
            except: raise ValueError, "%s is not a valid floating point number"%value
        elif self.datatype == Argument.tfilesave or \
             self.datatype == Argument.tfileopen:
            if os.access(value,os.R_OK): self.value = value
            else: raise ValueError, "'%s' is not a valid path"%value
        else: self.value = str(value)


class UserPlugin:
    """ Plugins should subclass this and overwrite the getInput and launch methods. """

    #----------------------------------------------------------------- PROTECTED
    def __init__(self, name, shortDescription, longDescription):
        self.name = name
        self.shortDescription = shortDescription
        self.longDescription = longDescription

    def getInput(self):
        """ Should return a dictionary of Arguments to be filled by the user.
        Example:
        return { "table": Argument(Argument.ttable), "radius": Argument(Argument.tint,) } """
        pass

    def launch(self, db):
        """ Overwrite this method to implement the plugin. """
        pass

    def progress(self, percent):
        """ Call this function from within launch whenever
        you want to display the current progress of
        your script. """
        try: self.__progressFunc(self, percent)
        except: pass

    #-------------------------------------------------------------------- PUBLIC
    # these methods are used to launch plugins and are prone to change

    def run(self,db):
        try: self.launch(db)
        except Exception, e:
            print e
            try: self.__errorFunc(self, e)
            except: raise Exception, e

    def setProgressFunc(self, func):
        self.__progressFunc = func

    def setErrorFunc(self, func):
        self.__errorFunc = func
