# Copyright (C) 2005-2006 Frederic Back <fredericback@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

import os
import sys
from optparse import OptionParser
import ConfigParser

#---------------------------------------------------------------- version number
version = "0.1.5"

#------------------------------------------------------ get command line options
parser = OptionParser("usage: %prog [options]",version="mezoGIS %s"%version)
parser.add_option("-v", "--verbose", action="store_true", dest="verbose")
(Options, args) = parser.parse_args()

#------------------------------------------------------------- set other options
Options.version = version

# paths to user configuration and data
Options.userpath = os.path.expanduser("~"+os.sep)
Options.configpath = Options.userpath+".mezogis"+os.sep

# try to access Options.configpath or to create it
if not os.access(Options.configpath, os.F_OK):
    try: os.mkdir(Options.configpath)
    except: pass

# path to mezogis data (/usr/local/share/mezogis for example)
Options.datapath = os.path.normpath(sys.prefix)+os.sep+"share"+os.sep+"mezogis"+os.sep
Options.iconpath = Options.datapath+"pixmaps"+os.sep
Options.palettePath = Options.datapath+"palettes"+os.sep
Options.pluginPath = Options.datapath+"plugins"+os.sep
Options.docPath = Options.datapath+"doc"+os.sep+"toc.html"

# point syntax to use
Options.pointSyntax = "MakePoint(%(x)s,%(y)s)"
Options.boxSyntax = "'BOX3D(%(x1)s %(y1)s,%(x2)s %(y2)s)'::box3d"

# size of the main window
Options.sizeX, Options.sizeY = 300, -1

# misc options
Options.editableLayerNames = False
Options.askBeforeReloading = True

# default connection
Options.default_host = "localhost"
Options.default_user = ""
Options.default_pw = ""
Options.default_dbname = ""
Options.default_port = "5432"
    
# ----------------------------------------- load mezogisrc and overwrite Options 
Options.config = ConfigParser.ConfigParser()
Options.config.read(Options.configpath+"mezogisrc")

if Options.config.has_section("connection"):
    Options.default_host = Options.config.get("connection", "host")
    Options.default_user = Options.config.get("connection", "user")
    Options.default_pw = Options.config.get("connection", "pw")
    Options.default_dbname = Options.config.get("connection", "dbname")
    Options.default_port = Options.config.get("connection", "port")
else:
    Options.config.add_section("connection")
    
def save_options_to_configfile():
    Options.config.set("connection", "host", Options.default_host)
    Options.config.set("connection", "user", Options.default_user)
    Options.config.set("connection", "pw", Options.default_pw)
    Options.config.set("connection", "dbname", Options.default_dbname)
    Options.config.set("connection", "port", Options.default_port)
        
    Options.config.write(open(Options.configpath+"mezogisrc", 'w'))
