# Copyright (C) 2005-2006 Frederic Back <fredericback@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

import gtk

def errorMessage(title, message = None, win = None ):
    d = gtk.MessageDialog(win,
        gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT,
        gtk.MESSAGE_ERROR, gtk.BUTTONS_OK,
        str(title) )
    if message is not None: d.format_secondary_text(str(message))
    d.run()
    d.destroy()

def createTreeview(*args):
    """ Shorthand function to create a gtk.Treeview.
        Arguments are the column headers, ie. ( "name", "tel", "email")
        Returns a treeview. """
    lsargs = [str] * len(args)
    view = gtk.TreeView(gtk.ListStore(*lsargs))
    text = gtk.CellRendererText()
    for i in range( len(args) ):
        view.append_column( gtk.TreeViewColumn(args[i], text, text=i) )
    return view

def createLabel(text, select=False):
    """ Shorthand function to create a gtk.Label. """
    l = gtk.Label(str(text))
    l.set_use_markup(True)
    l.set_alignment(0,0.5)
    if select: l.set_selectable(True)
    return l

def createButton(text, stockid):
    """ Shorthand function to create a gtk.Button with custom text and icon. """

    img = gtk.Image()
    img.set_from_stock(stockid, gtk.ICON_SIZE_BUTTON)
    box = gtk.HBox()
    box.pack_start(img)
    box.pack_start(gtk.Label(" "+text))
    b = gtk.Button()
    b.add(box)
    return b

def parseGimpPalette(path):
    palette = []
    try:
        f=open(path, "r")
        row = f.readline()
        if row[:12] != "GIMP Palette": raise Exception, "%s is not a valid GIMP Palette" %path
        row = f.readline()
        while row:
            if row.lstrip()[0] != "#": # ignore comments
                #print row.split()
                s = row.split()
                palette.append( [int(s[0])*257,int(s[1])*257,int(s[2])*257] )
            row = f.readline()

    except Exception, e: print e
    # add emergency colour
    palette.append( [40000,40000,60000] )
    return palette


def createColourPixbuf( gdkcolor, border=1, width=24, height=16 ):

    def convertColour( gdkcolour ):
        """ convert to "00FF7F" """
        colour = ""
        for i in (gdkcolour.red,gdkcolour.green,gdkcolour.blue):
            x = "%X" % int(float(i)/65535.0*255)
            if len(x) == 1: x = "0"+x
            colour += x
        return colour
    
    xpm = ["%i %i 2 1" %(width, height),
            ".\tc #"+convertColour(gdkcolor),
            "+\tc black"]
            
    for y in range( height ):
        row = ""
        for x in range( width ):
            if y < border or y >= height-border or x < border or x >= width-border: row += "+"
            else: row += "."
        xpm.append(row)
        
    return gtk.gdk.pixbuf_new_from_xpm_data(xpm)
