# Copyright (C) 2005-2006 Frederic Back <fredericback@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

import gtk

class CursorCollection:
    cursor = {
        "hand-open": None,
        "hand-closed": None
    }

    xpm = {
        "hand-open": [
        "20 20 3 1",
        " 	c None",
        ".	c #000000",
        "+	c #FFFFFF",
        "                    ",
        "                    ",
        "         ..         ",
        "     .. .++...      ",
        "    .++..++.++.     ",
        "    .++..++.++. .   ",
        "     .++.++.++..+.  ",
        "     .++.++.++.++.  ",
        "   .. .+++++++.++.  ",
        "  .++..++++++++++.  ",
        "  .+++.+++++++++.   ",
        "   .++++++++++++.   ",
        "    .+++++++++++.   ",
        "    .++++++++++.    ",
        "     .+++++++++.    ",
        "      .+++++++.     ",
        "       .++++++.     ",
        "       .++++++.     ",
        "                    ",
        "                    "],

        "hand-closed": [
        "20 20 3 1",
        " 	c None",
        ".	c #000000",
        "+	c #FFFFFF",
        "                    ",
        "                    ",
        "                    ",
        "                    ",
        "                    ",
        "         ..         ",
        "       ..++...      ",
        "      .+++++++..    ",
        "      .+++++++++.   ",
        "    ...+++++++++.   ",
        "   .++.+++++++++.   ",
        "   .++++++++++++.   ",
        "    .+++++++++++.   ",
        "    .++++++++++.    ",
        "     .+++++++++.    ",
        "      .+++++++.     ",
        "       .++++++.     ",
        "       .++++++.     ",
        "                    ",
        "                    "]
    }

def getCursor( name ):
    """ see CursorCollection for a list of names """

    if CursorCollection.cursor[name] == None:
        c = gtk.gdk.Cursor(gtk.gdk.ARROW) # dummy
        display = c.get_display()
        pixbuf = gtk.gdk.pixbuf_new_from_xpm_data(CursorCollection.xpm[name])
        CursorCollection.cursor[name] = gtk.gdk.Cursor(display,pixbuf,10,10)
    return CursorCollection.cursor[name]
