# Copyright (C) 2005-2006 Frederic Back <fredericback@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

import gtk
import gobject
import time

class GeoClipboard( gtk.Window ):
    """ A place to put short strings that represent point data.
    Singleton class. """

    instance = None

    def __onAccel(self, accel_group, acceleratable, keyval, modifier):
        if keyval == ord('w') or keyval == ord('q'): self.close()
        elif keyval == ord('c'): self.copyElement()
        elif keyval == ord('x'): self.copyElement(); self.delElement()
    
    def __init__(self):

        if GeoClipboard.instance is not None:
            raise Exception("GeoClipboard may not be instanciated: Use GeoClipboard.instance to access the singleton")
        GeoClipboard.instance = self

        gtk.Window.__init__(self)
        self.set_title(_("Geometry Clipboard"))
        self.connect("delete-event",self.close)

        # create an accelgroup
        ag = gtk.AccelGroup()
        ag.connect_group(ord('w'), gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE, self.__onAccel)
        ag.connect_group(ord('q'), gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE, self.__onAccel)
        ag.connect_group(ord('c'), gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE, self.__onAccel)
        ag.connect_group(ord('x'), gtk.gdk.CONTROL_MASK, gtk.ACCEL_VISIBLE, self.__onAccel)
        self.add_accel_group(ag)

        self.counter = 0
        self.__clipboard = None

        self.hbox = gtk.HBox()
        self.hbox.set_border_width(6)
        self.model = gtk.ListStore(int,str) # counter, string
        self.tree = gtk.TreeView(self.model)
        #self.tree.set_headers_visible(False)
        #self.tree.connect("row-activated",self.cb_rowActivated)
        tr = gtk.CellRendererText()
        self.tree.append_column(gtk.TreeViewColumn(_("#"), tr, text=0) )
        self.tree.append_column(gtk.TreeViewColumn(_("Element"), tr, text=1) )
        sw = gtk.ScrolledWindow()
        sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        sw.set_shadow_type(gtk.SHADOW_IN)
        sw.add(self.tree)
        self.hbox.pack_start(sw)

        vbox = gtk.VBox()
        self.hbox.pack_start(vbox,False)
        self.delButton = gtk.Button(None,gtk.STOCK_DELETE)
        self.copyButton = gtk.Button(None,gtk.STOCK_COPY)
        self.delButton.connect("clicked",self.delElement)
        self.copyButton.connect("clicked",self.copyElement)
        vbox.pack_start(self.delButton,False)
        vbox.pack_start(self.copyButton,False)

        self.set_default_size(480,-1)
        self.add(self.hbox)
        self.hbox.show_all()

    def addElement(self, callingWidget, element):
        self.counter += 1
        it = self.model.append( (self.counter,element) )
        self.tree.set_cursor( self.model.get_path(it) )
        self.present()

    def delElement(self, callingWidget=None):
        model, it = self.tree.get_selection().get_selected()
        if it is None: return
        model.remove(it)

    def copyElement(self, callingWidget=None):
        model, it = self.tree.get_selection().get_selected()
        if it is None: return
        value = model.get_value(it,1)
        if self.__clipboard is None:
            display = gtk.gdk.display_manager_get().get_default_display()
            self.__clipboard = gtk.Clipboard(display, "CLIPBOARD")
        self.__clipboard.set_text(value)

    def close(self, widget=None, event=None):
        self.hide()
        return True

singleton = GeoClipboard()
