# - Find the lxqt-globalkeys-ui include and library dirs and define a some macros
#
# The module defines the following variables
#  LXQT_GLOBALKEYS_UI_FOUND         - Set to TRUE if all of the above has been found
#
#  LXQT_GLOBALKEYS_UI_INCLUDE_DIR   - The lxqt-globalkeys-ui include directory
#
#  LXQT_GLOBALKEYS_UI_INCLUDE_DIRS  - The lxqt-globalkeys-ui include directory
#
#  LXQT_GLOBALKEYS_LIBRARY_DIRS  - The lxqt-globalkeys include directory
#
#  LXQT_GLOBALKEYS_UI_LIBRARIES     - The libraries needed to use lxqt-globalkeys-ui
#
#  LXQT_GLOBALKEYS_UI_USE_FILE      - The variable LXQT_GLOBALKEYS_UI_USE_FILE is set which is the path
#                        to a CMake file that can be included to compile lxqt-globalkeys-ui
#                        applications and libraries. It sets up the compilation
#                        environment for include directories and populates a
#                        LXQT_GLOBALKEYS_UI_LIBRARIES variable.
#
# LXQT_GLOBALKEYS_UI_QT_LIBRARIES   - The Qt libraries needed by lxqt-globalkeys-ui
#
# Typical usage:
#    find_package(lxqt-globalkeys-ui)
#    include(${LXQT_GLOBALKEYS_UI_USE_FILE})
#    add_executable(use-lxqt-globalkeys-ui main.cpp)
#    target_link_libraries(use-qtxdg ${LXQT_GLOBALKEYS_UI_QT_LIBRARIES} ${LXQT_GLOBALKEYS_UI_LIBRARIES})

set(LXQT_GLOBALKEYS_UI_INCLUDE_DIR   /usr/include/lxqt-globalkeys-ui)
set(LXQT_GLOBALKEYS_UI_LIBRARY       lxqt-globalkeys-ui)

set(LXQT_GLOBALKEYS_UI_LIBRARIES     "${LXQT_GLOBALKEYS_UI_LIBRARY}")
set(LXQT_GLOBALKEYS_UI_INCLUDE_DIRS  "${LXQT_GLOBALKEYS_UI_INCLUDE_DIR}")
set(LXQT_GLOBALKEYS_UI_LIBRARY_DIRS  /usr/lib)

set(LXQT_GLOBALKEYS_UI_USE_FILE      "${CMAKE_CURRENT_LIST_DIR}/lxqt_globalkeys_ui_use.cmake")
set(LXQT_GLOBALKEYS_UI_FOUND 1)

set(LXQT_GLOBALKEYS_UI_MAJOR_VERSION 0)
set(LXQT_GLOBALKEYS_UI_MINOR_VERSION 9)
set(LXQT_GLOBALKEYS_UI_PATCH_VERSION 0)
set(LXQT_GLOBALKEYS_UI_VERSION 0.9.0)

mark_as_advanced(LXQT_GLOBALKEYS_UI_LIBRARY LXQT_GLOBALKEYS_UI_INCLUDE_DIR)
