# - Find the sysstat include and library dirs and define a some macros
#
# The module defines the following variables
#
#  SYSSTAT_FOUND         - Set to TRUE if all of the above has been found
#
#  SYSSTAT_INCLUDE_DIR   - The lxqt include directory
#
#  SYSSTAT_INCLUDE_DIRS  - The lxqt and the Qt include directory, for use with INCLUDE_DIRECTORIES()
#
#  SYSSTAT_LIBRARY_DIRS  - The lxqt and the Qt library directory
#
#  SYSSTAT_LIBRARIES     - The libraries needed to use lxqt
#
#  SYSSTAT_USE_FILE       - The variable SYSSTAT_USE_FILE is set which is the path to a CMake file that
#                        can be included to compile lxqt applications and libraries. It sets up
#                        the compilation environment for include directories and populates a
#                        SYSSTAT_LIBRARIES variable.

set(SYSSTAT_MAJOR_VERSION 0)
set(SYSSTAT_MINOR_VERSION 2)
set(SYSSTAT_PATCH_VERSION 0)
set(SYSSTAT_VERSION       0.2.0)

set(SYSSTAT_INCLUDE_DIR   /usr/include/sysstat-qt5)
set(SYSSTAT_LIBRARY       sysstat-qt5)

set(SYSSTAT_LIBRARIES     ${SYSSTAT_LIBRARY})
set(SYSSTAT_INCLUDE_DIRS  "${SYSSTAT_INCLUDE_DIR}")
set(SYSSTAT_LIBRARY_DIRS  /usr/lib)
set(SYSSTAT_USE_FILE      "${CMAKE_CURRENT_LIST_DIR}/sysstat_use.cmake")
set(SYSSTAT_FOUND         1)

mark_as_advanced(SYSSTAT_LIBRARY SYSSTAT_INCLUDE_DIR)
