/* --------------------------------------------------------------------------

   libmusicbrainz4 - Client library to access MusicBrainz

   Copyright (C) 2011 Andrew Hawkins

   This file is part of libmusicbrainz4.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz4 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   THIS FILE IS AUTOMATICALLY GENERATED - DO NOT EDIT IT!

----------------------------------------------------------------------------*/


/*
	Things you should delete using the appropriate mb4_xxx_delete() function:

	* The query object you create to do the actual work
	* Any object or list returned from one of the mb4_query_xxx() functions
	* The return from mb4_release_media_matching_discid() function
	* The return from any mb4_xxx_clone() function

	Everything else remains managed by the library, and should not be deleted

	If in doubt, valgrind is a useful way to spot leaks or things being deleted
	when they shouldn't be.

*/

#ifndef _MUSICBRAINZ4_MB_C_H
#define _MUSICBRAINZ4_MB_C_H

#include "musicbrainz4/defines.h"

#ifdef __cplusplus
extern "C"
{
#endif

  typedef void *Mb4Entity;
  typedef void *Mb4Alias;
  typedef void *Mb4Annotation;
  typedef void *Mb4Artist;
  typedef void *Mb4ArtistCredit;
  typedef void *Mb4Attribute;
  typedef void *Mb4CDStub;
  typedef void *Mb4Collection;
  typedef void *Mb4Disc;
  typedef void *Mb4FreeDBDisc;
  typedef void *Mb4IPI;
  typedef void *Mb4ISRC;
  typedef void *Mb4ISWC;
  typedef void *Mb4Label;
  typedef void *Mb4LabelInfo;
  typedef void *Mb4Lifespan;
  typedef void *Mb4Medium;
  typedef void *Mb4Message;
  typedef void *Mb4Metadata;
  typedef void *Mb4NameCredit;
  typedef void *Mb4NonMBTrack;
  typedef void *Mb4PUID;
  typedef void *Mb4Query;
  typedef void *Mb4Rating;
  typedef void *Mb4Recording;
  typedef void *Mb4Relation;
  typedef void *Mb4Release;
  typedef void *Mb4ReleaseGroup;
  typedef void *Mb4SecondaryType;
  typedef void *Mb4Tag;
  typedef void *Mb4TextRepresentation;
  typedef void *Mb4Track;
  typedef void *Mb4UserRating;
  typedef void *Mb4UserTag;
  typedef void *Mb4Work;
  typedef void *Mb4AliasList;
  typedef void *Mb4AnnotationList;
  typedef void *Mb4ArtistList;
  typedef void *Mb4AttributeList;
  typedef void *Mb4CDStubList;
  typedef void *Mb4CollectionList;
  typedef void *Mb4DiscList;
  typedef void *Mb4FreeDBDiscList;
  typedef void *Mb4IPIList;
  typedef void *Mb4ISRCList;
  typedef void *Mb4ISWCList;
  typedef void *Mb4LabelList;
  typedef void *Mb4LabelInfoList;
  typedef void *Mb4MediumList;
  typedef void *Mb4NameCreditList;
  typedef void *Mb4NonMBTrackList;
  typedef void *Mb4PUIDList;
  typedef void *Mb4RecordingList;
  typedef void *Mb4RelationList;
  typedef void *Mb4RelationListList;
  typedef void *Mb4ReleaseList;
  typedef void *Mb4ReleaseGroupList;
  typedef void *Mb4SecondaryTypeList;
  typedef void *Mb4TagList;
  typedef void *Mb4TrackList;
  typedef void *Mb4UserTagList;
  typedef void *Mb4WorkList;

/**
 * Returns the number of extension attributes for the entity
 *
 * @param Entity #Mb4Entity object
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_entity_ext_attributes_size(Mb4Entity Entity);

/**
 * Returns the name of the requested extension attribute
 *
 * @param Entity #Mb4Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_entity_ext_attribute_name(Mb4Entity Entity, int Item, char *str, int len);

/**
 * Returns the value of the requested extension attribute
 *
 * @param Entity #Mb4Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_entity_ext_attribute_value(Mb4Entity Entity, int Item, char *str, int len);

/**
 * Returns the number of extension elements for the entity
 *
 * @param Entity #Mb4Entity object
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_entity_ext_elements_size(Mb4Entity Entity);

/**
 * Returns the name of the requested extension element
 *
 * @param Entity #Mb4Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_entity_ext_element_name(Mb4Entity Entity, int Item, char *str, int len);

/**
 * Returns the value of the requested extension element
 *
 * @param Entity #Mb4Entity object
 * @param Item Item to return
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_entity_ext_element_value(Mb4Entity Entity, int Item, char *str, int len);

/**
* Delete an #Mb4Alias object
*
* @param Alias Object to delete
*/
  void mb4_alias_delete(Mb4Alias Alias);

/**
* Clone an #Mb4Alias object
*
* @param Alias Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Alias mb4_alias_clone(Mb4Alias Alias);

/**
 * @see MusicBrainz4::CAlias::Locale
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_locale(Mb4Alias Alias, char *str, int len);

/**
 * @see MusicBrainz4::CAlias::Text
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_text(Mb4Alias Alias, char *str, int len);

/**
 * @see MusicBrainz4::CAlias::SortName
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_sortname(Mb4Alias Alias, char *str, int len);

/**
 * @see MusicBrainz4::CAlias::Type
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_type(Mb4Alias Alias, char *str, int len);

/**
 * @see MusicBrainz4::CAlias::Primary
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_primary(Mb4Alias Alias, char *str, int len);

/**
 * @see MusicBrainz4::CAlias::BeginDate
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_begindate(Mb4Alias Alias, char *str, int len);

/**
 * @see MusicBrainz4::CAlias::EndDate
 *
 * @param Alias #Mb4Alias object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_alias_get_enddate(Mb4Alias Alias, char *str, int len);

/**
* Delete an #Mb4Annotation object
*
* @param Annotation Object to delete
*/
  void mb4_annotation_delete(Mb4Annotation Annotation);

/**
* Clone an #Mb4Annotation object
*
* @param Annotation Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Annotation mb4_annotation_clone(Mb4Annotation Annotation);

/**
 * @see MusicBrainz4::CAnnotation::Type
 *
 * @param Annotation #Mb4Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_annotation_get_type(Mb4Annotation Annotation, char *str, int len);

/**
 * @see MusicBrainz4::CAnnotation::Entity
 *
 * @param Annotation #Mb4Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_annotation_get_entity(Mb4Annotation Annotation, char *str, int len);

/**
 * @see MusicBrainz4::CAnnotation::Name
 *
 * @param Annotation #Mb4Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_annotation_get_name(Mb4Annotation Annotation, char *str, int len);

/**
 * @see MusicBrainz4::CAnnotation::Text
 *
 * @param Annotation #Mb4Annotation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_annotation_get_text(Mb4Annotation Annotation, char *str, int len);

/**
* Delete an #Mb4Artist object
*
* @param Artist Object to delete
*/
  void mb4_artist_delete(Mb4Artist Artist);

/**
* Clone an #Mb4Artist object
*
* @param Artist Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Artist mb4_artist_clone(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::ID
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_id(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::Type
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_type(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::Name
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_name(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::SortName
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_sortname(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::Gender
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_gender(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::Country
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_country(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::Disambiguation
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_artist_get_disambiguation(Mb4Artist Artist, char *str, int len);

/**
 * @deprecated @see MusicBrainz4::CArtist::IPI
 *
 * <b>This method is deprecated, please use #mb4_artist_get_ipilist</b>
 *
 * @param Artist #Mb4Artist object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  LIBMB4_DEPRECATED(mb4_artist_get_ipilist) int mb4_artist_get_ipi(Mb4Artist Artist, char *str, int len);

/**
 * @see MusicBrainz4::CArtist::IPIList
 *
 * @param Artist #Mb4ArtistList object
 *
 * @return #Mb4IPIList object
 */
  Mb4IPIList mb4_artist_get_ipilist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::Lifespan
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4Lifespan object
 */
  Mb4Lifespan mb4_artist_get_lifespan(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::AliasList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4AliasList object
 */
  Mb4AliasList mb4_artist_get_aliaslist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::RecordingList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4RecordingList object
 */
  Mb4RecordingList mb4_artist_get_recordinglist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::ReleaseList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_artist_get_releaselist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::ReleaseGroupList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4ReleaseGroupList object
 */
  Mb4ReleaseGroupList mb4_artist_get_releasegrouplist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::LabelList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4LabelList object
 */
  Mb4LabelList mb4_artist_get_labellist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::WorkList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4WorkList object
 */
  Mb4WorkList mb4_artist_get_worklist(Mb4Artist Artist);

/**
 * @deprecated @see MusicBrainz4::CArtist::RelationList
 *
 * <b>This method is deprecated, please use #mb4_artist_get_relationlistlist</b>
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4RelationList object
 */
 LIBMB4_DEPRECATED(mb4_artist_get_relationlistlist) Mb4RelationList mb4_artist_get_relationlist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::RelationListList
 *
 * @param Artist #Mb4ArtistList object
 *
 * @return #Mb4RelationListList object
 */
  Mb4RelationListList mb4_artist_get_relationlistlist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::TagList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4TagList object
 */
  Mb4TagList mb4_artist_get_taglist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::UserTagList
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4UserTagList object
 */
  Mb4UserTagList mb4_artist_get_usertaglist(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::Rating
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4Rating object
 */
  Mb4Rating mb4_artist_get_rating(Mb4Artist Artist);

/**
 * @see MusicBrainz4::CArtist::UserRating
 *
 * @param Artist #Mb4Artist object
 *
 * @return #Mb4UserRating object
 */
  Mb4UserRating mb4_artist_get_userrating(Mb4Artist Artist);

/**
* Delete an #Mb4ArtistCredit object
*
* @param ArtistCredit Object to delete
*/
  void mb4_artistcredit_delete(Mb4ArtistCredit ArtistCredit);

/**
* Clone an #Mb4ArtistCredit object
*
* @param ArtistCredit Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4ArtistCredit mb4_artistcredit_clone(Mb4ArtistCredit ArtistCredit);

/**
 * @see MusicBrainz4::CArtistCredit::NameCreditList
 *
 * @param ArtistCredit #Mb4ArtistCredit object
 *
 * @return #Mb4NameCreditList object
 */
  Mb4NameCreditList mb4_artistcredit_get_namecreditlist(Mb4ArtistCredit ArtistCredit);

/**
* Delete an #Mb4Attribute object
*
* @param Attribute Object to delete
*/
  void mb4_attribute_delete(Mb4Attribute Attribute);

/**
* Clone an #Mb4Attribute object
*
* @param Attribute Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Attribute mb4_attribute_clone(Mb4Attribute Attribute);

/**
 * @see MusicBrainz4::CAttribute::Text
 *
 * @param Attribute #Mb4Attribute object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_attribute_get_text(Mb4Attribute Attribute, char *str, int len);

/**
* Delete an #Mb4CDStub object
*
* @param CDStub Object to delete
*/
  void mb4_cdstub_delete(Mb4CDStub CDStub);

/**
* Clone an #Mb4CDStub object
*
* @param CDStub Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4CDStub mb4_cdstub_clone(Mb4CDStub CDStub);

/**
 * @see MusicBrainz4::CCDStub::ID
 *
 * @param CDStub #Mb4CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_cdstub_get_id(Mb4CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz4::CCDStub::Title
 *
 * @param CDStub #Mb4CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_cdstub_get_title(Mb4CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz4::CCDStub::Artist
 *
 * @param CDStub #Mb4CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_cdstub_get_artist(Mb4CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz4::CCDStub::Barcode
 *
 * @param CDStub #Mb4CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_cdstub_get_barcode(Mb4CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz4::CCDStub::Comment
 *
 * @param CDStub #Mb4CDStub object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_cdstub_get_comment(Mb4CDStub CDStub, char *str, int len);

/**
 * @see MusicBrainz4::CCDStub::NonMBTrackList
 *
 * @param CDStub #Mb4CDStub object
 *
 * @return #Mb4NonMBTrackList object
 */
  Mb4NonMBTrackList mb4_cdstub_get_nonmbtracklist(Mb4CDStub CDStub);

/**
* Delete an #Mb4Collection object
*
* @param Collection Object to delete
*/
  void mb4_collection_delete(Mb4Collection Collection);

/**
* Clone an #Mb4Collection object
*
* @param Collection Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Collection mb4_collection_clone(Mb4Collection Collection);

/**
 * @see MusicBrainz4::CCollection::ID
 *
 * @param Collection #Mb4Collection object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_collection_get_id(Mb4Collection Collection, char *str, int len);

/**
 * @see MusicBrainz4::CCollection::Name
 *
 * @param Collection #Mb4Collection object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_collection_get_name(Mb4Collection Collection, char *str, int len);

/**
 * @see MusicBrainz4::CCollection::Editor
 *
 * @param Collection #Mb4Collection object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_collection_get_editor(Mb4Collection Collection, char *str, int len);

/**
 * @see MusicBrainz4::CCollection::ReleaseList
 *
 * @param Collection #Mb4Collection object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_collection_get_releaselist(Mb4Collection Collection);

/**
* Delete an #Mb4Disc object
*
* @param Disc Object to delete
*/
  void mb4_disc_delete(Mb4Disc Disc);

/**
* Clone an #Mb4Disc object
*
* @param Disc Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Disc mb4_disc_clone(Mb4Disc Disc);

/**
 * @see MusicBrainz4::CDisc::ID
 *
 * @param Disc #Mb4Disc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_disc_get_id(Mb4Disc Disc, char *str, int len);

/**
 * @see MusicBrainz4::CDisc::Sectors
 *
 * @param Disc #Mb4Disc object
 *
 * @return Returned value
 */
  int mb4_disc_get_sectors(Mb4Disc Disc);

/**
 * @see MusicBrainz4::CDisc::ReleaseList
 *
 * @param Disc #Mb4Disc object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_disc_get_releaselist(Mb4Disc Disc);

/**
* Delete an #Mb4FreeDBDisc object
*
* @param FreeDBDisc Object to delete
*/
  void mb4_freedbdisc_delete(Mb4FreeDBDisc FreeDBDisc);

/**
* Clone an #Mb4FreeDBDisc object
*
* @param FreeDBDisc Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4FreeDBDisc mb4_freedbdisc_clone(Mb4FreeDBDisc FreeDBDisc);

/**
 * @see MusicBrainz4::CFreeDBDisc::ID
 *
 * @param FreeDBDisc #Mb4FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_freedbdisc_get_id(Mb4FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz4::CFreeDBDisc::Title
 *
 * @param FreeDBDisc #Mb4FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_freedbdisc_get_title(Mb4FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz4::CFreeDBDisc::Artist
 *
 * @param FreeDBDisc #Mb4FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_freedbdisc_get_artist(Mb4FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz4::CFreeDBDisc::Category
 *
 * @param FreeDBDisc #Mb4FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_freedbdisc_get_category(Mb4FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz4::CFreeDBDisc::Year
 *
 * @param FreeDBDisc #Mb4FreeDBDisc object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_freedbdisc_get_year(Mb4FreeDBDisc FreeDBDisc, char *str, int len);

/**
 * @see MusicBrainz4::CFreeDBDisc::NonMBTrackList
 *
 * @param FreeDBDisc #Mb4FreeDBDisc object
 *
 * @return #Mb4NonMBTrackList object
 */
  Mb4NonMBTrackList mb4_freedbdisc_get_nonmbtracklist(Mb4FreeDBDisc FreeDBDisc);

/**
* Delete an #Mb4IPI object
*
* @param IPI Object to delete
*/
  void mb4_ipi_delete(Mb4IPI IPI);

/**
* Clone an #Mb4IPI object
*
* @param IPI Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4IPI mb4_ipi_clone(Mb4IPI IPI);

/**
 * @see MusicBrainz4::CIPI::IPI
 *
 * @param IPI #Mb4IPI object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_ipi_get_ipi(Mb4IPI IPI, char *str, int len);

/**
* Delete an #Mb4ISRC object
*
* @param ISRC Object to delete
*/
  void mb4_isrc_delete(Mb4ISRC ISRC);

/**
* Clone an #Mb4ISRC object
*
* @param ISRC Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4ISRC mb4_isrc_clone(Mb4ISRC ISRC);

/**
 * @see MusicBrainz4::CISRC::ID
 *
 * @param ISRC #Mb4ISRC object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_isrc_get_id(Mb4ISRC ISRC, char *str, int len);

/**
 * @see MusicBrainz4::CISRC::RecordingList
 *
 * @param ISRC #Mb4ISRC object
 *
 * @return #Mb4RecordingList object
 */
  Mb4RecordingList mb4_isrc_get_recordinglist(Mb4ISRC ISRC);

/**
* Delete an #Mb4ISWC object
*
* @param ISWC Object to delete
*/
  void mb4_iswc_delete(Mb4ISWC ISWC);

/**
* Clone an #Mb4ISWC object
*
* @param ISWC Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4ISWC mb4_iswc_clone(Mb4ISWC ISWC);

/**
 * @see MusicBrainz4::CISWC::ISWC
 *
 * @param ISWC #Mb4ISWC object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_iswc_get_iswc(Mb4ISWC ISWC, char *str, int len);

/**
* Delete an #Mb4Label object
*
* @param Label Object to delete
*/
  void mb4_label_delete(Mb4Label Label);

/**
* Clone an #Mb4Label object
*
* @param Label Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Label mb4_label_clone(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::ID
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_label_get_id(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::Type
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_label_get_type(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::Name
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_label_get_name(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::SortName
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_label_get_sortname(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::LabelCode
 *
 * @param Label #Mb4Label object
 *
 * @return Returned value
 */
  int mb4_label_get_labelcode(Mb4Label Label);

/**
 * @deprecated @see MusicBrainz4::CLabel::IPI
 *
 * <b>This method is deprecated, please use #mb4_label_get_ipilist</b>
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  LIBMB4_DEPRECATED(mb4_label_get_ipilist) int mb4_label_get_ipi(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::IPIList
 *
 * @param Label #Mb4LabelList object
 *
 * @return #Mb4IPIList object
 */
  Mb4IPIList mb4_label_get_ipilist(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::Disambiguation
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_label_get_disambiguation(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::Country
 *
 * @param Label #Mb4Label object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_label_get_country(Mb4Label Label, char *str, int len);

/**
 * @see MusicBrainz4::CLabel::Lifespan
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4Lifespan object
 */
  Mb4Lifespan mb4_label_get_lifespan(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::AliasList
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4AliasList object
 */
  Mb4AliasList mb4_label_get_aliaslist(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::ReleaseList
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_label_get_releaselist(Mb4Label Label);

/**
 * @deprecated @see MusicBrainz4::CLabel::RelationList
 *
 * <b>This method is deprecated, please use #mb4_label_get_relationlistlist</b>
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4RelationList object
 */
 LIBMB4_DEPRECATED(mb4_label_get_relationlistlist) Mb4RelationList mb4_label_get_relationlist(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::RelationListList
 *
 * @param Label #Mb4LabelList object
 *
 * @return #Mb4RelationListList object
 */
  Mb4RelationListList mb4_label_get_relationlistlist(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::TagList
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4TagList object
 */
  Mb4TagList mb4_label_get_taglist(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::UserTagList
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4UserTagList object
 */
  Mb4UserTagList mb4_label_get_usertaglist(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::Rating
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4Rating object
 */
  Mb4Rating mb4_label_get_rating(Mb4Label Label);

/**
 * @see MusicBrainz4::CLabel::UserRating
 *
 * @param Label #Mb4Label object
 *
 * @return #Mb4UserRating object
 */
  Mb4UserRating mb4_label_get_userrating(Mb4Label Label);

/**
* Delete an #Mb4LabelInfo object
*
* @param LabelInfo Object to delete
*/
  void mb4_labelinfo_delete(Mb4LabelInfo LabelInfo);

/**
* Clone an #Mb4LabelInfo object
*
* @param LabelInfo Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4LabelInfo mb4_labelinfo_clone(Mb4LabelInfo LabelInfo);

/**
 * @see MusicBrainz4::CLabelInfo::CatalogNumber
 *
 * @param LabelInfo #Mb4LabelInfo object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_labelinfo_get_catalognumber(Mb4LabelInfo LabelInfo, char *str, int len);

/**
 * @see MusicBrainz4::CLabelInfo::Label
 *
 * @param LabelInfo #Mb4LabelInfo object
 *
 * @return #Mb4Label object
 */
  Mb4Label mb4_labelinfo_get_label(Mb4LabelInfo LabelInfo);

/**
* Delete an #Mb4Lifespan object
*
* @param Lifespan Object to delete
*/
  void mb4_lifespan_delete(Mb4Lifespan Lifespan);

/**
* Clone an #Mb4Lifespan object
*
* @param Lifespan Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Lifespan mb4_lifespan_clone(Mb4Lifespan Lifespan);

/**
 * @see MusicBrainz4::CLifespan::Begin
 *
 * @param Lifespan #Mb4Lifespan object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_lifespan_get_begin(Mb4Lifespan Lifespan, char *str, int len);

/**
 * @see MusicBrainz4::CLifespan::End
 *
 * @param Lifespan #Mb4Lifespan object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_lifespan_get_end(Mb4Lifespan Lifespan, char *str, int len);

/**
 * @see MusicBrainz4::CLifespan::Ended
 *
 * @param Lifespan #Mb4Lifespan object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_lifespan_get_ended(Mb4Lifespan Lifespan, char *str, int len);

/**
* Delete an #Mb4Medium object
*
* @param Medium Object to delete
*/
  void mb4_medium_delete(Mb4Medium Medium);

/**
* Clone an #Mb4Medium object
*
* @param Medium Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Medium mb4_medium_clone(Mb4Medium Medium);

/**
 * @see MusicBrainz4::CMedium::Title
 *
 * @param Medium #Mb4Medium object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_medium_get_title(Mb4Medium Medium, char *str, int len);

/**
 * @see MusicBrainz4::CMedium::Position
 *
 * @param Medium #Mb4Medium object
 *
 * @return Returned value
 */
  int mb4_medium_get_position(Mb4Medium Medium);

/**
 * @see MusicBrainz4::CMedium::Format
 *
 * @param Medium #Mb4Medium object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_medium_get_format(Mb4Medium Medium, char *str, int len);

/**
 * @see MusicBrainz4::CMedium::DiscList
 *
 * @param Medium #Mb4Medium object
 *
 * @return #Mb4DiscList object
 */
  Mb4DiscList mb4_medium_get_disclist(Mb4Medium Medium);

/**
 * @see MusicBrainz4::CMedium::TrackList
 *
 * @param Medium #Mb4Medium object
 *
 * @return #Mb4TrackList object
 */
  Mb4TrackList mb4_medium_get_tracklist(Mb4Medium Medium);

/* --------------------------------------------------------------------------

   libmusicbrainz4 - Client library to access MusicBrainz

   Copyright (C) 2011 Andrew Hawkins

   This file is part of libmusicbrainz4.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz4 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
 * @see MusicBrainz4::CMedium::ContainsDiscID
 *
 * @param Medium #Mb4Medium object
 * @param DiscID DiscID to check
 *
 * @return 1 if DiscID found, 0 otherwise
 */
	unsigned char mb4_medium_contains_discid(Mb4Medium Medium, const char *DiscID);


/**
* Delete an #Mb4Message object
*
* @param Message Object to delete
*/
  void mb4_message_delete(Mb4Message Message);

/**
* Clone an #Mb4Message object
*
* @param Message Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Message mb4_message_clone(Mb4Message Message);

/**
 * @see MusicBrainz4::CMessage::Text
 *
 * @param Message #Mb4Message object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_message_get_text(Mb4Message Message, char *str, int len);

/**
* Delete an #Mb4Metadata object
*
* @param Metadata Object to delete
*/
  void mb4_metadata_delete(Mb4Metadata Metadata);

/**
* Clone an #Mb4Metadata object
*
* @param Metadata Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Metadata mb4_metadata_clone(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::XMLNS
 *
 * @param Metadata #Mb4Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_metadata_get_xmlns(Mb4Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz4::CMetadata::XMLNSExt
 *
 * @param Metadata #Mb4Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_metadata_get_xmlnsext(Mb4Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz4::CMetadata::Generator
 *
 * @param Metadata #Mb4Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_metadata_get_generator(Mb4Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz4::CMetadata::Created
 *
 * @param Metadata #Mb4Metadata object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_metadata_get_created(Mb4Metadata Metadata, char *str, int len);

/**
 * @see MusicBrainz4::CMetadata::Artist
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Artist object
 */
  Mb4Artist mb4_metadata_get_artist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Release
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Release object
 */
  Mb4Release mb4_metadata_get_release(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::ReleaseGroup
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4ReleaseGroup object
 */
  Mb4ReleaseGroup mb4_metadata_get_releasegroup(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Recording
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Recording object
 */
  Mb4Recording mb4_metadata_get_recording(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Label
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Label object
 */
  Mb4Label mb4_metadata_get_label(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Work
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Work object
 */
  Mb4Work mb4_metadata_get_work(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::PUID
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4PUID object
 */
  Mb4PUID mb4_metadata_get_puid(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::ISRC
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4ISRC object
 */
  Mb4ISRC mb4_metadata_get_isrc(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Disc
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Disc object
 */
  Mb4Disc mb4_metadata_get_disc(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::LabelInfoList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4LabelInfoList object
 */
  Mb4LabelInfoList mb4_metadata_get_labelinfolist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Rating
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Rating object
 */
  Mb4Rating mb4_metadata_get_rating(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::UserRating
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4UserRating object
 */
  Mb4UserRating mb4_metadata_get_userrating(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Collection
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Collection object
 */
  Mb4Collection mb4_metadata_get_collection(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::ArtistList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4ArtistList object
 */
  Mb4ArtistList mb4_metadata_get_artistlist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::ReleaseList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_metadata_get_releaselist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::ReleaseGroupList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4ReleaseGroupList object
 */
  Mb4ReleaseGroupList mb4_metadata_get_releasegrouplist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::RecordingList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4RecordingList object
 */
  Mb4RecordingList mb4_metadata_get_recordinglist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::LabelList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4LabelList object
 */
  Mb4LabelList mb4_metadata_get_labellist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::WorkList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4WorkList object
 */
  Mb4WorkList mb4_metadata_get_worklist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::ISRCList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4ISRCList object
 */
  Mb4ISRCList mb4_metadata_get_isrclist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::AnnotationList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4AnnotationList object
 */
  Mb4AnnotationList mb4_metadata_get_annotationlist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::CDStubList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4CDStubList object
 */
  Mb4CDStubList mb4_metadata_get_cdstublist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::FreeDBDiscList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4FreeDBDiscList object
 */
  Mb4FreeDBDiscList mb4_metadata_get_freedbdisclist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::TagList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4TagList object
 */
  Mb4TagList mb4_metadata_get_taglist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::UserTagList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4UserTagList object
 */
  Mb4UserTagList mb4_metadata_get_usertaglist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::CollectionList
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4CollectionList object
 */
  Mb4CollectionList mb4_metadata_get_collectionlist(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::CDStub
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4CDStub object
 */
  Mb4CDStub mb4_metadata_get_cdstub(Mb4Metadata Metadata);

/**
 * @see MusicBrainz4::CMetadata::Message
 *
 * @param Metadata #Mb4Metadata object
 *
 * @return #Mb4Message object
 */
  Mb4Message mb4_metadata_get_message(Mb4Metadata Metadata);

/**
* Delete an #Mb4NameCredit object
*
* @param NameCredit Object to delete
*/
  void mb4_namecredit_delete(Mb4NameCredit NameCredit);

/**
* Clone an #Mb4NameCredit object
*
* @param NameCredit Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4NameCredit mb4_namecredit_clone(Mb4NameCredit NameCredit);

/**
 * @see MusicBrainz4::CNameCredit::JoinPhrase
 *
 * @param NameCredit #Mb4NameCredit object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_namecredit_get_joinphrase(Mb4NameCredit NameCredit, char *str, int len);

/**
 * @see MusicBrainz4::CNameCredit::Name
 *
 * @param NameCredit #Mb4NameCredit object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_namecredit_get_name(Mb4NameCredit NameCredit, char *str, int len);

/**
 * @see MusicBrainz4::CNameCredit::Artist
 *
 * @param NameCredit #Mb4NameCredit object
 *
 * @return #Mb4Artist object
 */
  Mb4Artist mb4_namecredit_get_artist(Mb4NameCredit NameCredit);

/**
* Delete an #Mb4NonMBTrack object
*
* @param NonMBTrack Object to delete
*/
  void mb4_nonmbtrack_delete(Mb4NonMBTrack NonMBTrack);

/**
* Clone an #Mb4NonMBTrack object
*
* @param NonMBTrack Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4NonMBTrack mb4_nonmbtrack_clone(Mb4NonMBTrack NonMBTrack);

/**
 * @see MusicBrainz4::CNonMBTrack::Title
 *
 * @param NonMBTrack #Mb4NonMBTrack object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_nonmbtrack_get_title(Mb4NonMBTrack NonMBTrack, char *str, int len);

/**
 * @see MusicBrainz4::CNonMBTrack::Artist
 *
 * @param NonMBTrack #Mb4NonMBTrack object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_nonmbtrack_get_artist(Mb4NonMBTrack NonMBTrack, char *str, int len);

/**
 * @see MusicBrainz4::CNonMBTrack::Length
 *
 * @param NonMBTrack #Mb4NonMBTrack object
 *
 * @return Returned value
 */
  int mb4_nonmbtrack_get_length(Mb4NonMBTrack NonMBTrack);

/**
* Delete an #Mb4PUID object
*
* @param PUID Object to delete
*/
  void mb4_puid_delete(Mb4PUID PUID);

/**
* Clone an #Mb4PUID object
*
* @param PUID Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4PUID mb4_puid_clone(Mb4PUID PUID);

/**
 * @see MusicBrainz4::CPUID::ID
 *
 * @param PUID #Mb4PUID object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_puid_get_id(Mb4PUID PUID, char *str, int len);

/**
 * @see MusicBrainz4::CPUID::RecordingList
 *
 * @param PUID #Mb4PUID object
 *
 * @return #Mb4RecordingList object
 */
  Mb4RecordingList mb4_puid_get_recordinglist(Mb4PUID PUID);

/**
* Delete an #Mb4Query object
*
* @param Query Object to delete
*/
  void mb4_query_delete(Mb4Query Query);

/**
* Clone an #Mb4Query object
*
* @param Query Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Query mb4_query_clone(Mb4Query Query);

/**
 * @see MusicBrainz4::CQuery::LastHTTPCode
 *
 * @param Query #Mb4Query object
 *
 * @return Returned value
 */
  int mb4_query_get_lasthttpcode(Mb4Query Query);

/**
 * @see MusicBrainz4::CQuery::LastErrorMessage
 *
 * @param Query #Mb4Query object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_query_get_lasterrormessage(Mb4Query Query, char *str, int len);

/**
 * @see MusicBrainz4::CQuery::Version
 *
 * @param Query #Mb4Query object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_query_get_version(Mb4Query Query, char *str, int len);

/* --------------------------------------------------------------------------

   libmusicbrainz4 - Client library to access MusicBrainz

   Copyright (C) 2011 Andrew Hawkins

   This file is part of libmusicbrainz4.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz4 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
 * Create a new instance of #Mb4Query.
 *
 * @see MusicBrainz4::CQuery::CQuery
 *
 * @param UserAgent User agent to be passed to submissions
 * @param Server Server to use, pass null to use the default server
 * @param Port Port to use, pass 0 to use the default port
 *
 * @return The newly created #Mb4Query object. This object <b>must</b> be deleted once
 *				finished with.
 */

	Mb4Query mb4_query_new(const char *UserAgent, const char *Server, int Port);

/**
 * Set the username for authenticating to MusicBrainz
 *
 * @see MusicBrainz4::CQuery::SetUserName
 *
 * @param Query #Mb4Query object
 * @param UserName Username to use
 */
	void mb4_query_set_username(Mb4Query Query, const char *UserName);

/**
 * Set the password for authenticating to MusicBrainz
 *
 * @see MusicBrainz4::CQuery::SetPassword
 *
 * @param Query #Mb4Query object
 * @param Password Password to use
 */
	void mb4_query_set_password(Mb4Query Query, const char *Password);

/**
 * Set the proxy server
 *
 * @see MusicBrainz4::CQuery::SetProxyHost
 *
 * @param Query #Mb4Query object
 * @param ProxyHost Proxy server to use
 */
	void mb4_query_set_proxyhost(Mb4Query Query, const char *ProxyHost);

/**
 *	Set the port to use on the proxy server
 *
 * @see MusicBrainz4::CQuery::SetProxyPort
 *
 * @param Query #Mb4Query object
 * @param ProxyPort Port to use on proxy server
 */
	void mb4_query_set_proxyport(Mb4Query Query, int ProxyPort);

/**
 *	Set the username to use to authenticate to the proxy server
 *
 * @see MusicBrainz4::CQuery::SetProxyUserName
 *
 * @param Query #Mb4Query object
 * @param	ProxyUserName User name to use
 */
	void mb4_query_set_proxyusername(Mb4Query Query, const char *ProxyUserName);

/**
 * Set the password to use to authenticate to the proxy server
 *
 * @see MusicBrainz4::CQuery::SetProxyPassword
 *
 * @param Query #Mb4Query object
 * @param ProxyPassword Password to use
 */
	void mb4_query_set_proxypassword(Mb4Query Query, const char *ProxyPassword);

/**
 *	Return a list of releases that match the specified Disc ID
 *
 * @see MusicBrainz4::CQuery::LookupDiscID
 *
 * @param Query #Mb4Query object
 * @param	DiscID DiscID to lookup
 *
 * @return A #Mb4ReleaseList object. This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb4ReleaseList mb4_query_lookup_discid(Mb4Query Query, const char *DiscID);

/**
 * Return full information about a specific release
 *
 * @see MusicBrainz4::CQuery::LookupRelease
 *
 * @param Query #Mb4Query object
 * @param	Release Release to return information for
 *
 * @return A #Mb4Release object. This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb4Release mb4_query_lookup_release(Mb4Query Query, const char *Release);

/**
 *	Perform a generic query
 *
 * @see MusicBrainz4::CQuery::Query
 *
 * @param Query #Mb4Query object
 * @param	Entity The entity to query
 * @param ID The ID to query
 * @param Resource The resource to query
 * @param	NumParams The number of parameters in the following arrays
 * @param ParamNames Array of strings containing parameter names
 * @param	ParamValues Array of space seperated parameter values
 *
 * @return A #Mb4Metadata object. This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb4Metadata mb4_query_query(Mb4Query Query, const char *Entity, const char *ID, const char *Resource, int NumParams, char **ParamNames, char **ParamValues);

/**
 *	Add a list of releases to a collection
 *
 * @see MusicBrainz4::CQuery::AddCollectionEntries
 *
 * @param Query #Mb4Query object
 * @param	Collection ID of collection to add releases to
 * @param	NumEntries The number of entries to add
 * @param Entries Array of strings of release IDs to add
 *
 * @return 0 on failure, 1 on success
 */
	unsigned char mb4_query_add_collection_entries(Mb4Query Query, const char *Collection, int NumEntries, const char **Entries);

/**
 *	Delete a list of releases from a collection
 *
 * @see MusicBrainz4::CQuery::AddCollectionEntries
 *
 * @param Query #Mb4Query object
 * @param	Collection ID of collection to delete releases from
 * @param	NumEntries The number of entries to delete
 * @param Entries Array of strings of release IDs to delete
 *
 * @return 0 on failure, 1 on success
 */
	unsigned char mb4_query_delete_collection_entries(Mb4Query Query, const char *Collection, int NumEntries, const char **Entries);

/**
 * @see MusicBrainz4::CQuery::tQueryResult
 */

	typedef enum
	{
			eQuery_Success=0,
			eQuery_ConnectionError,
			eQuery_Timeout,
			eQuery_AuthenticationError,
			eQuery_FetchError,
			eQuery_RequestError,
			eQuery_ResourceNotFound
	} tQueryResult;

/**
 * @see MusicBrainz4::CQuery::LastResult
 *
 * @param Query #Mb4Query object
 *
 * @return Last query result code
 */
	tQueryResult mb4_query_get_lastresult(Mb4Query Query);



/**
* Delete an #Mb4Rating object
*
* @param Rating Object to delete
*/
  void mb4_rating_delete(Mb4Rating Rating);

/**
* Clone an #Mb4Rating object
*
* @param Rating Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Rating mb4_rating_clone(Mb4Rating Rating);

/**
 * @see MusicBrainz4::CRating::VotesCount
 *
 * @param Rating #Mb4Rating object
 *
 * @return Returned value
 */
  int mb4_rating_get_votescount(Mb4Rating Rating);

/**
 * @see MusicBrainz4::CRating::Rating
 *
 * @param Rating #Mb4Rating object
 *
 * @return Returned value
 */
  double mb4_rating_get_rating(Mb4Rating Rating);

/**
* Delete an #Mb4Recording object
*
* @param Recording Object to delete
*/
  void mb4_recording_delete(Mb4Recording Recording);

/**
* Clone an #Mb4Recording object
*
* @param Recording Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Recording mb4_recording_clone(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::ID
 *
 * @param Recording #Mb4Recording object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_recording_get_id(Mb4Recording Recording, char *str, int len);

/**
 * @see MusicBrainz4::CRecording::Title
 *
 * @param Recording #Mb4Recording object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_recording_get_title(Mb4Recording Recording, char *str, int len);

/**
 * @see MusicBrainz4::CRecording::Length
 *
 * @param Recording #Mb4Recording object
 *
 * @return Returned value
 */
  int mb4_recording_get_length(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::Disambiguation
 *
 * @param Recording #Mb4Recording object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_recording_get_disambiguation(Mb4Recording Recording, char *str, int len);

/**
 * @see MusicBrainz4::CRecording::ArtistCredit
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4ArtistCredit object
 */
  Mb4ArtistCredit mb4_recording_get_artistcredit(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::ReleaseList
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_recording_get_releaselist(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::PUIDList
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4PUIDList object
 */
  Mb4PUIDList mb4_recording_get_puidlist(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::ISRCList
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4ISRCList object
 */
  Mb4ISRCList mb4_recording_get_isrclist(Mb4Recording Recording);

/**
 * @deprecated @see MusicBrainz4::CRecording::RelationList
 *
 * <b>This method is deprecated, please use #mb4_recording_get_relationlistlist</b>
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4RelationList object
 */
 LIBMB4_DEPRECATED(mb4_recording_get_relationlistlist) Mb4RelationList mb4_recording_get_relationlist(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::RelationListList
 *
 * @param Recording #Mb4RecordingList object
 *
 * @return #Mb4RelationListList object
 */
  Mb4RelationListList mb4_recording_get_relationlistlist(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::TagList
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4TagList object
 */
  Mb4TagList mb4_recording_get_taglist(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::UserTagList
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4UserTagList object
 */
  Mb4UserTagList mb4_recording_get_usertaglist(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::Rating
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4Rating object
 */
  Mb4Rating mb4_recording_get_rating(Mb4Recording Recording);

/**
 * @see MusicBrainz4::CRecording::UserRating
 *
 * @param Recording #Mb4Recording object
 *
 * @return #Mb4UserRating object
 */
  Mb4UserRating mb4_recording_get_userrating(Mb4Recording Recording);

/**
* Delete an #Mb4Relation object
*
* @param Relation Object to delete
*/
  void mb4_relation_delete(Mb4Relation Relation);

/**
* Clone an #Mb4Relation object
*
* @param Relation Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Relation mb4_relation_clone(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::Type
 *
 * @param Relation #Mb4Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_relation_get_type(Mb4Relation Relation, char *str, int len);

/**
 * @see MusicBrainz4::CRelation::Target
 *
 * @param Relation #Mb4Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_relation_get_target(Mb4Relation Relation, char *str, int len);

/**
 * @see MusicBrainz4::CRelation::Direction
 *
 * @param Relation #Mb4Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_relation_get_direction(Mb4Relation Relation, char *str, int len);

/**
 * @see MusicBrainz4::CRelation::AttributeList
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4AttributeList object
 */
  Mb4AttributeList mb4_relation_get_attributelist(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::Begin
 *
 * @param Relation #Mb4Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_relation_get_begin(Mb4Relation Relation, char *str, int len);

/**
 * @see MusicBrainz4::CRelation::End
 *
 * @param Relation #Mb4Relation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_relation_get_end(Mb4Relation Relation, char *str, int len);

/**
 * @see MusicBrainz4::CRelation::Artist
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4Artist object
 */
  Mb4Artist mb4_relation_get_artist(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::Release
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4Release object
 */
  Mb4Release mb4_relation_get_release(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::ReleaseGroup
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4ReleaseGroup object
 */
  Mb4ReleaseGroup mb4_relation_get_releasegroup(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::Recording
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4Recording object
 */
  Mb4Recording mb4_relation_get_recording(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::Label
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4Label object
 */
  Mb4Label mb4_relation_get_label(Mb4Relation Relation);

/**
 * @see MusicBrainz4::CRelation::Work
 *
 * @param Relation #Mb4Relation object
 *
 * @return #Mb4Work object
 */
  Mb4Work mb4_relation_get_work(Mb4Relation Relation);

/**
* Delete an #Mb4Release object
*
* @param Release Object to delete
*/
  void mb4_release_delete(Mb4Release Release);

/**
* Clone an #Mb4Release object
*
* @param Release Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Release mb4_release_clone(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::ID
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_id(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Title
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_title(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Status
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_status(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Quality
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_quality(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Disambiguation
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_disambiguation(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Packaging
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_packaging(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::TextRepresentation
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4TextRepresentation object
 */
  Mb4TextRepresentation mb4_release_get_textrepresentation(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::ArtistCredit
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4ArtistCredit object
 */
  Mb4ArtistCredit mb4_release_get_artistcredit(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::ReleaseGroup
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4ReleaseGroup object
 */
  Mb4ReleaseGroup mb4_release_get_releasegroup(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::Date
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_date(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Country
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_country(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::Barcode
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_barcode(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::ASIN
 *
 * @param Release #Mb4Release object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_release_get_asin(Mb4Release Release, char *str, int len);

/**
 * @see MusicBrainz4::CRelease::LabelInfoList
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4LabelInfoList object
 */
  Mb4LabelInfoList mb4_release_get_labelinfolist(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::MediumList
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4MediumList object
 */
  Mb4MediumList mb4_release_get_mediumlist(Mb4Release Release);

/**
 * @deprecated @see MusicBrainz4::CRelease::RelationList
 *
 * <b>This method is deprecated, please use #mb4_release_get_relationlistlist</b>
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4RelationList object
 */
 LIBMB4_DEPRECATED(mb4_release_get_relationlistlist) Mb4RelationList mb4_release_get_relationlist(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::RelationListList
 *
 * @param Release #Mb4ReleaseList object
 *
 * @return #Mb4RelationListList object
 */
  Mb4RelationListList mb4_release_get_relationlistlist(Mb4Release Release);

/**
 * @see MusicBrainz4::CRelease::CollectionList
 *
 * @param Release #Mb4Release object
 *
 * @return #Mb4CollectionList object
 */
  Mb4CollectionList mb4_release_get_collectionlist(Mb4Release Release);

/* --------------------------------------------------------------------------

   libmusicbrainz4 - Client library to access MusicBrainz

   Copyright (C) 2011 Andrew Hawkins

   This file is part of libmusicbrainz4.

   This library is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.

   libmusicbrainz4 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

     $Id$

----------------------------------------------------------------------------*/

/**
 * @see MusicBrainz4::CRelease::MediaMatchingDiscID
 *
 * @param Release #Mb4Release object
 * @param DiscID DiscID to match
 *
 * @return #Mb4MediumList.  This object <b>must</b> be deleted once
 *				finished with.
 */
	Mb4MediumList mb4_release_media_matching_discid(Mb4Release Release, const char *DiscID);



/**
* Delete an #Mb4ReleaseGroup object
*
* @param ReleaseGroup Object to delete
*/
  void mb4_releasegroup_delete(Mb4ReleaseGroup ReleaseGroup);

/**
* Clone an #Mb4ReleaseGroup object
*
* @param ReleaseGroup Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4ReleaseGroup mb4_releasegroup_clone(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::ID
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_releasegroup_get_id(Mb4ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @deprecated @see MusicBrainz4::CReleaseGroup::Type
 *
 * <b>This method is deprecated, please use #mb4_releasegroup_get_primarytype</b>
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  LIBMB4_DEPRECATED(mb4_releasegroup_get_primarytype) int mb4_releasegroup_get_type(Mb4ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz4::CReleaseGroup::PrimaryType
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_releasegroup_get_primarytype(Mb4ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz4::CReleaseGroup::Title
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_releasegroup_get_title(Mb4ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz4::CReleaseGroup::Disambiguation
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_releasegroup_get_disambiguation(Mb4ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz4::CReleaseGroup::FirstReleaseDate
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_releasegroup_get_firstreleasedate(Mb4ReleaseGroup ReleaseGroup, char *str, int len);

/**
 * @see MusicBrainz4::CReleaseGroup::ArtistCredit
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4ArtistCredit object
 */
  Mb4ArtistCredit mb4_releasegroup_get_artistcredit(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::ReleaseList
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4ReleaseList object
 */
  Mb4ReleaseList mb4_releasegroup_get_releaselist(Mb4ReleaseGroup ReleaseGroup);

/**
 * @deprecated @see MusicBrainz4::CReleaseGroup::RelationList
 *
 * <b>This method is deprecated, please use #mb4_releasegroup_get_relationlistlist</b>
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4RelationList object
 */
 LIBMB4_DEPRECATED(mb4_releasegroup_get_relationlistlist) Mb4RelationList mb4_releasegroup_get_relationlist(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::RelationListList
 *
 * @param ReleaseGroup #Mb4ReleaseGroupList object
 *
 * @return #Mb4RelationListList object
 */
  Mb4RelationListList mb4_releasegroup_get_relationlistlist(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::TagList
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4TagList object
 */
  Mb4TagList mb4_releasegroup_get_taglist(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::UserTagList
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4UserTagList object
 */
  Mb4UserTagList mb4_releasegroup_get_usertaglist(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::Rating
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4Rating object
 */
  Mb4Rating mb4_releasegroup_get_rating(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::UserRating
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4UserRating object
 */
  Mb4UserRating mb4_releasegroup_get_userrating(Mb4ReleaseGroup ReleaseGroup);

/**
 * @see MusicBrainz4::CReleaseGroup::SecondaryTypeList
 *
 * @param ReleaseGroup #Mb4ReleaseGroup object
 *
 * @return #Mb4SecondaryTypeList object
 */
  Mb4SecondaryTypeList mb4_releasegroup_get_secondarytypelist(Mb4ReleaseGroup ReleaseGroup);

/**
* Delete an #Mb4SecondaryType object
*
* @param SecondaryType Object to delete
*/
  void mb4_secondarytype_delete(Mb4SecondaryType SecondaryType);

/**
* Clone an #Mb4SecondaryType object
*
* @param SecondaryType Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4SecondaryType mb4_secondarytype_clone(Mb4SecondaryType SecondaryType);

/**
 * @see MusicBrainz4::CSecondaryType::SecondaryType
 *
 * @param SecondaryType #Mb4SecondaryType object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_secondarytype_get_secondarytype(Mb4SecondaryType SecondaryType, char *str, int len);

/**
* Delete an #Mb4Tag object
*
* @param Tag Object to delete
*/
  void mb4_tag_delete(Mb4Tag Tag);

/**
* Clone an #Mb4Tag object
*
* @param Tag Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Tag mb4_tag_clone(Mb4Tag Tag);

/**
 * @see MusicBrainz4::CTag::Count
 *
 * @param Tag #Mb4Tag object
 *
 * @return Returned value
 */
  int mb4_tag_get_count(Mb4Tag Tag);

/**
 * @see MusicBrainz4::CTag::Name
 *
 * @param Tag #Mb4Tag object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_tag_get_name(Mb4Tag Tag, char *str, int len);

/**
* Delete an #Mb4TextRepresentation object
*
* @param TextRepresentation Object to delete
*/
  void mb4_textrepresentation_delete(Mb4TextRepresentation TextRepresentation);

/**
* Clone an #Mb4TextRepresentation object
*
* @param TextRepresentation Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4TextRepresentation mb4_textrepresentation_clone(Mb4TextRepresentation TextRepresentation);

/**
 * @see MusicBrainz4::CTextRepresentation::Language
 *
 * @param TextRepresentation #Mb4TextRepresentation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_textrepresentation_get_language(Mb4TextRepresentation TextRepresentation, char *str, int len);

/**
 * @see MusicBrainz4::CTextRepresentation::Script
 *
 * @param TextRepresentation #Mb4TextRepresentation object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_textrepresentation_get_script(Mb4TextRepresentation TextRepresentation, char *str, int len);

/**
* Delete an #Mb4Track object
*
* @param Track Object to delete
*/
  void mb4_track_delete(Mb4Track Track);

/**
* Clone an #Mb4Track object
*
* @param Track Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Track mb4_track_clone(Mb4Track Track);

/**
 * @see MusicBrainz4::CTrack::Position
 *
 * @param Track #Mb4Track object
 *
 * @return Returned value
 */
  int mb4_track_get_position(Mb4Track Track);

/**
 * @see MusicBrainz4::CTrack::Title
 *
 * @param Track #Mb4Track object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_track_get_title(Mb4Track Track, char *str, int len);

/**
 * @see MusicBrainz4::CTrack::Recording
 *
 * @param Track #Mb4Track object
 *
 * @return #Mb4Recording object
 */
  Mb4Recording mb4_track_get_recording(Mb4Track Track);

/**
 * @see MusicBrainz4::CTrack::Length
 *
 * @param Track #Mb4Track object
 *
 * @return Returned value
 */
  int mb4_track_get_length(Mb4Track Track);

/**
 * @see MusicBrainz4::CTrack::ArtistCredit
 *
 * @param Track #Mb4Track object
 *
 * @return #Mb4ArtistCredit object
 */
  Mb4ArtistCredit mb4_track_get_artistcredit(Mb4Track Track);

/**
 * @see MusicBrainz4::CTrack::Number
 *
 * @param Track #Mb4Track object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_track_get_number(Mb4Track Track, char *str, int len);

/**
* Delete an #Mb4UserRating object
*
* @param UserRating Object to delete
*/
  void mb4_userrating_delete(Mb4UserRating UserRating);

/**
* Clone an #Mb4UserRating object
*
* @param UserRating Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4UserRating mb4_userrating_clone(Mb4UserRating UserRating);

/**
 * @see MusicBrainz4::CUserRating::UserRating
 *
 * @param UserRating #Mb4UserRating object
 *
 * @return Returned value
 */
  int mb4_userrating_get_userrating(Mb4UserRating UserRating);

/**
* Delete an #Mb4UserTag object
*
* @param UserTag Object to delete
*/
  void mb4_usertag_delete(Mb4UserTag UserTag);

/**
* Clone an #Mb4UserTag object
*
* @param UserTag Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4UserTag mb4_usertag_clone(Mb4UserTag UserTag);

/**
 * @see MusicBrainz4::CUserTag::Name
 *
 * @param UserTag #Mb4UserTag object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_usertag_get_name(Mb4UserTag UserTag, char *str, int len);

/**
* Delete an #Mb4Work object
*
* @param Work Object to delete
*/
  void mb4_work_delete(Mb4Work Work);

/**
* Clone an #Mb4Work object
*
* @param Work Object to clone
*
* @return Cloned object. This object <b>must</b> be deleted once
*				finished with.
*/
  Mb4Work mb4_work_clone(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::ID
 *
 * @param Work #Mb4Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_work_get_id(Mb4Work Work, char *str, int len);

/**
 * @see MusicBrainz4::CWork::Type
 *
 * @param Work #Mb4Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_work_get_type(Mb4Work Work, char *str, int len);

/**
 * @see MusicBrainz4::CWork::Title
 *
 * @param Work #Mb4Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_work_get_title(Mb4Work Work, char *str, int len);

/**
 * @see MusicBrainz4::CWork::ArtistCredit
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4ArtistCredit object
 */
  Mb4ArtistCredit mb4_work_get_artistcredit(Mb4Work Work);

/**
 * @deprecated @see MusicBrainz4::CWork::ISWC
 *
 * <b>This method is deprecated, please use #mb4_work_get_iswclist</b>
 *
 * @param Work #Mb4Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  LIBMB4_DEPRECATED(mb4_work_get_iswclist) int mb4_work_get_iswc(Mb4Work Work, char *str, int len);

/**
 * @see MusicBrainz4::CWork::ISWCList
 *
 * @param Work #Mb4WorkList object
 *
 * @return #Mb4ISWCList object
 */
  Mb4ISWCList mb4_work_get_iswclist(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::Disambiguation
 *
 * @param Work #Mb4Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_work_get_disambiguation(Mb4Work Work, char *str, int len);

/**
 * @see MusicBrainz4::CWork::AliasList
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4AliasList object
 */
  Mb4AliasList mb4_work_get_aliaslist(Mb4Work Work);

/**
 * @deprecated @see MusicBrainz4::CWork::RelationList
 *
 * <b>This method is deprecated, please use #mb4_work_get_relationlistlist</b>
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4RelationList object
 */
 LIBMB4_DEPRECATED(mb4_work_get_relationlistlist) Mb4RelationList mb4_work_get_relationlist(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::RelationListList
 *
 * @param Work #Mb4WorkList object
 *
 * @return #Mb4RelationListList object
 */
  Mb4RelationListList mb4_work_get_relationlistlist(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::TagList
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4TagList object
 */
  Mb4TagList mb4_work_get_taglist(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::UserTagList
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4UserTagList object
 */
  Mb4UserTagList mb4_work_get_usertaglist(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::Rating
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4Rating object
 */
  Mb4Rating mb4_work_get_rating(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::UserRating
 *
 * @param Work #Mb4Work object
 *
 * @return #Mb4UserRating object
 */
  Mb4UserRating mb4_work_get_userrating(Mb4Work Work);

/**
 * @see MusicBrainz4::CWork::Language
 *
 * @param Work #Mb4Work object
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_work_get_language(Mb4Work Work, char *str, int len);

/**
 * Delete a #Mb4AliasList
 *
 * @param List List to delete
 */
  void mb4_alias_list_delete(Mb4AliasList List);

/**
 * Return the number of entries in a #Mb4AliasList
 *
 * @param	List List to use
 */
  int mb4_alias_list_size(Mb4AliasList List);

/**
 * Returns an entry from a #Mb4AliasList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Alias object.
 */
  Mb4Alias mb4_alias_list_item(Mb4AliasList List, int Item);

/**
 *	Return the count of entries in an #Mb4AliasList
 *
 * @param	List List to use
 */
	int mb4_alias_list_get_count(Mb4AliasList List);

/**
 *	Return the offset of entries in an #Mb4AliasList
 *
 * @param	List List to use
 */
	int mb4_alias_list_get_offset(Mb4AliasList List);

/**
* Clone an #Mb4AliasList object
*
* @param AliasList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4AliasList mb4_alias_list_clone(Mb4AliasList AliasList);

/**
 * Delete a #Mb4AnnotationList
 *
 * @param List List to delete
 */
  void mb4_annotation_list_delete(Mb4AnnotationList List);

/**
 * Return the number of entries in a #Mb4AnnotationList
 *
 * @param	List List to use
 */
  int mb4_annotation_list_size(Mb4AnnotationList List);

/**
 * Returns an entry from a #Mb4AnnotationList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Annotation object.
 */
  Mb4Annotation mb4_annotation_list_item(Mb4AnnotationList List, int Item);

/**
 *	Return the count of entries in an #Mb4AnnotationList
 *
 * @param	List List to use
 */
	int mb4_annotation_list_get_count(Mb4AnnotationList List);

/**
 *	Return the offset of entries in an #Mb4AnnotationList
 *
 * @param	List List to use
 */
	int mb4_annotation_list_get_offset(Mb4AnnotationList List);

/**
* Clone an #Mb4AnnotationList object
*
* @param AnnotationList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4AnnotationList mb4_annotation_list_clone(Mb4AnnotationList AnnotationList);

/**
 * Delete a #Mb4ArtistList
 *
 * @param List List to delete
 */
  void mb4_artist_list_delete(Mb4ArtistList List);

/**
 * Return the number of entries in a #Mb4ArtistList
 *
 * @param	List List to use
 */
  int mb4_artist_list_size(Mb4ArtistList List);

/**
 * Returns an entry from a #Mb4ArtistList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Artist object.
 */
  Mb4Artist mb4_artist_list_item(Mb4ArtistList List, int Item);

/**
 *	Return the count of entries in an #Mb4ArtistList
 *
 * @param	List List to use
 */
	int mb4_artist_list_get_count(Mb4ArtistList List);

/**
 *	Return the offset of entries in an #Mb4ArtistList
 *
 * @param	List List to use
 */
	int mb4_artist_list_get_offset(Mb4ArtistList List);

/**
* Clone an #Mb4ArtistList object
*
* @param ArtistList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4ArtistList mb4_artist_list_clone(Mb4ArtistList ArtistList);

/**
 * Delete a #Mb4AttributeList
 *
 * @param List List to delete
 */
  void mb4_attribute_list_delete(Mb4AttributeList List);

/**
 * Return the number of entries in a #Mb4AttributeList
 *
 * @param	List List to use
 */
  int mb4_attribute_list_size(Mb4AttributeList List);

/**
 * Returns an entry from a #Mb4AttributeList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Attribute object.
 */
  Mb4Attribute mb4_attribute_list_item(Mb4AttributeList List, int Item);

/**
 *	Return the count of entries in an #Mb4AttributeList
 *
 * @param	List List to use
 */
	int mb4_attribute_list_get_count(Mb4AttributeList List);

/**
 *	Return the offset of entries in an #Mb4AttributeList
 *
 * @param	List List to use
 */
	int mb4_attribute_list_get_offset(Mb4AttributeList List);

/**
* Clone an #Mb4AttributeList object
*
* @param AttributeList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4AttributeList mb4_attribute_list_clone(Mb4AttributeList AttributeList);

/**
 * Delete a #Mb4CDStubList
 *
 * @param List List to delete
 */
  void mb4_cdstub_list_delete(Mb4CDStubList List);

/**
 * Return the number of entries in a #Mb4CDStubList
 *
 * @param	List List to use
 */
  int mb4_cdstub_list_size(Mb4CDStubList List);

/**
 * Returns an entry from a #Mb4CDStubList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4CDStub object.
 */
  Mb4CDStub mb4_cdstub_list_item(Mb4CDStubList List, int Item);

/**
 *	Return the count of entries in an #Mb4CDStubList
 *
 * @param	List List to use
 */
	int mb4_cdstub_list_get_count(Mb4CDStubList List);

/**
 *	Return the offset of entries in an #Mb4CDStubList
 *
 * @param	List List to use
 */
	int mb4_cdstub_list_get_offset(Mb4CDStubList List);

/**
* Clone an #Mb4CDStubList object
*
* @param CDStubList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4CDStubList mb4_cdstub_list_clone(Mb4CDStubList CDStubList);

/**
 * Delete a #Mb4CollectionList
 *
 * @param List List to delete
 */
  void mb4_collection_list_delete(Mb4CollectionList List);

/**
 * Return the number of entries in a #Mb4CollectionList
 *
 * @param	List List to use
 */
  int mb4_collection_list_size(Mb4CollectionList List);

/**
 * Returns an entry from a #Mb4CollectionList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Collection object.
 */
  Mb4Collection mb4_collection_list_item(Mb4CollectionList List, int Item);

/**
 *	Return the count of entries in an #Mb4CollectionList
 *
 * @param	List List to use
 */
	int mb4_collection_list_get_count(Mb4CollectionList List);

/**
 *	Return the offset of entries in an #Mb4CollectionList
 *
 * @param	List List to use
 */
	int mb4_collection_list_get_offset(Mb4CollectionList List);

/**
* Clone an #Mb4CollectionList object
*
* @param CollectionList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4CollectionList mb4_collection_list_clone(Mb4CollectionList CollectionList);

/**
 * Delete a #Mb4DiscList
 *
 * @param List List to delete
 */
  void mb4_disc_list_delete(Mb4DiscList List);

/**
 * Return the number of entries in a #Mb4DiscList
 *
 * @param	List List to use
 */
  int mb4_disc_list_size(Mb4DiscList List);

/**
 * Returns an entry from a #Mb4DiscList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Disc object.
 */
  Mb4Disc mb4_disc_list_item(Mb4DiscList List, int Item);

/**
 *	Return the count of entries in an #Mb4DiscList
 *
 * @param	List List to use
 */
	int mb4_disc_list_get_count(Mb4DiscList List);

/**
 *	Return the offset of entries in an #Mb4DiscList
 *
 * @param	List List to use
 */
	int mb4_disc_list_get_offset(Mb4DiscList List);

/**
* Clone an #Mb4DiscList object
*
* @param DiscList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4DiscList mb4_disc_list_clone(Mb4DiscList DiscList);

/**
 * Delete a #Mb4FreeDBDiscList
 *
 * @param List List to delete
 */
  void mb4_freedbdisc_list_delete(Mb4FreeDBDiscList List);

/**
 * Return the number of entries in a #Mb4FreeDBDiscList
 *
 * @param	List List to use
 */
  int mb4_freedbdisc_list_size(Mb4FreeDBDiscList List);

/**
 * Returns an entry from a #Mb4FreeDBDiscList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4FreeDBDisc object.
 */
  Mb4FreeDBDisc mb4_freedbdisc_list_item(Mb4FreeDBDiscList List, int Item);

/**
 *	Return the count of entries in an #Mb4FreeDBDiscList
 *
 * @param	List List to use
 */
	int mb4_freedbdisc_list_get_count(Mb4FreeDBDiscList List);

/**
 *	Return the offset of entries in an #Mb4FreeDBDiscList
 *
 * @param	List List to use
 */
	int mb4_freedbdisc_list_get_offset(Mb4FreeDBDiscList List);

/**
* Clone an #Mb4FreeDBDiscList object
*
* @param FreeDBDiscList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4FreeDBDiscList mb4_freedbdisc_list_clone(Mb4FreeDBDiscList FreeDBDiscList);

/**
 * Delete a #Mb4IPIList
 *
 * @param List List to delete
 */
  void mb4_ipi_list_delete(Mb4IPIList List);

/**
 * Return the number of entries in a #Mb4IPIList
 *
 * @param	List List to use
 */
  int mb4_ipi_list_size(Mb4IPIList List);

/**
 * Returns an entry from a #Mb4IPIList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4IPI object.
 */
  Mb4IPI mb4_ipi_list_item(Mb4IPIList List, int Item);

/**
 *	Return the count of entries in an #Mb4IPIList
 *
 * @param	List List to use
 */
	int mb4_ipi_list_get_count(Mb4IPIList List);

/**
 *	Return the offset of entries in an #Mb4IPIList
 *
 * @param	List List to use
 */
	int mb4_ipi_list_get_offset(Mb4IPIList List);

/**
* Clone an #Mb4IPIList object
*
* @param IPIList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4IPIList mb4_ipi_list_clone(Mb4IPIList IPIList);

/**
 * Delete a #Mb4ISRCList
 *
 * @param List List to delete
 */
  void mb4_isrc_list_delete(Mb4ISRCList List);

/**
 * Return the number of entries in a #Mb4ISRCList
 *
 * @param	List List to use
 */
  int mb4_isrc_list_size(Mb4ISRCList List);

/**
 * Returns an entry from a #Mb4ISRCList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4ISRC object.
 */
  Mb4ISRC mb4_isrc_list_item(Mb4ISRCList List, int Item);

/**
 *	Return the count of entries in an #Mb4ISRCList
 *
 * @param	List List to use
 */
	int mb4_isrc_list_get_count(Mb4ISRCList List);

/**
 *	Return the offset of entries in an #Mb4ISRCList
 *
 * @param	List List to use
 */
	int mb4_isrc_list_get_offset(Mb4ISRCList List);

/**
* Clone an #Mb4ISRCList object
*
* @param ISRCList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4ISRCList mb4_isrc_list_clone(Mb4ISRCList ISRCList);

/**
 * Delete a #Mb4ISWCList
 *
 * @param List List to delete
 */
  void mb4_iswc_list_delete(Mb4ISWCList List);

/**
 * Return the number of entries in a #Mb4ISWCList
 *
 * @param	List List to use
 */
  int mb4_iswc_list_size(Mb4ISWCList List);

/**
 * Returns an entry from a #Mb4ISWCList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4ISWC object.
 */
  Mb4ISWC mb4_iswc_list_item(Mb4ISWCList List, int Item);

/**
 *	Return the count of entries in an #Mb4ISWCList
 *
 * @param	List List to use
 */
	int mb4_iswc_list_get_count(Mb4ISWCList List);

/**
 *	Return the offset of entries in an #Mb4ISWCList
 *
 * @param	List List to use
 */
	int mb4_iswc_list_get_offset(Mb4ISWCList List);

/**
* Clone an #Mb4ISWCList object
*
* @param ISWCList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4ISWCList mb4_iswc_list_clone(Mb4ISWCList ISWCList);

/**
 * Delete a #Mb4LabelList
 *
 * @param List List to delete
 */
  void mb4_label_list_delete(Mb4LabelList List);

/**
 * Return the number of entries in a #Mb4LabelList
 *
 * @param	List List to use
 */
  int mb4_label_list_size(Mb4LabelList List);

/**
 * Returns an entry from a #Mb4LabelList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Label object.
 */
  Mb4Label mb4_label_list_item(Mb4LabelList List, int Item);

/**
 *	Return the count of entries in an #Mb4LabelList
 *
 * @param	List List to use
 */
	int mb4_label_list_get_count(Mb4LabelList List);

/**
 *	Return the offset of entries in an #Mb4LabelList
 *
 * @param	List List to use
 */
	int mb4_label_list_get_offset(Mb4LabelList List);

/**
* Clone an #Mb4LabelList object
*
* @param LabelList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4LabelList mb4_label_list_clone(Mb4LabelList LabelList);

/**
 * Delete a #Mb4LabelInfoList
 *
 * @param List List to delete
 */
  void mb4_labelinfo_list_delete(Mb4LabelInfoList List);

/**
 * Return the number of entries in a #Mb4LabelInfoList
 *
 * @param	List List to use
 */
  int mb4_labelinfo_list_size(Mb4LabelInfoList List);

/**
 * Returns an entry from a #Mb4LabelInfoList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4LabelInfo object.
 */
  Mb4LabelInfo mb4_labelinfo_list_item(Mb4LabelInfoList List, int Item);

/**
 *	Return the count of entries in an #Mb4LabelInfoList
 *
 * @param	List List to use
 */
	int mb4_labelinfo_list_get_count(Mb4LabelInfoList List);

/**
 *	Return the offset of entries in an #Mb4LabelInfoList
 *
 * @param	List List to use
 */
	int mb4_labelinfo_list_get_offset(Mb4LabelInfoList List);

/**
* Clone an #Mb4LabelInfoList object
*
* @param LabelInfoList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4LabelInfoList mb4_labelinfo_list_clone(Mb4LabelInfoList LabelInfoList);

/**
 * Delete a #Mb4MediumList
 *
 * @param List List to delete
 */
  void mb4_medium_list_delete(Mb4MediumList List);

/**
 * Return the number of entries in a #Mb4MediumList
 *
 * @param	List List to use
 */
  int mb4_medium_list_size(Mb4MediumList List);

/**
 * Returns an entry from a #Mb4MediumList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Medium object.
 */
  Mb4Medium mb4_medium_list_item(Mb4MediumList List, int Item);

/**
 *	Return the count of entries in an #Mb4MediumList
 *
 * @param	List List to use
 */
	int mb4_medium_list_get_count(Mb4MediumList List);

/**
 *	Return the offset of entries in an #Mb4MediumList
 *
 * @param	List List to use
 */
	int mb4_medium_list_get_offset(Mb4MediumList List);

/**
* Clone an #Mb4MediumList object
*
* @param MediumList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4MediumList mb4_medium_list_clone(Mb4MediumList MediumList);

/**
 * @see MusicBrainz4::CMedium::TrackCount
 *
 * @param List List to use
 *
 * @return Returned value
 */
  int mb4_medium_list_get_trackcount(Mb4MediumList List);

/**
 * Delete a #Mb4NameCreditList
 *
 * @param List List to delete
 */
  void mb4_namecredit_list_delete(Mb4NameCreditList List);

/**
 * Return the number of entries in a #Mb4NameCreditList
 *
 * @param	List List to use
 */
  int mb4_namecredit_list_size(Mb4NameCreditList List);

/**
 * Returns an entry from a #Mb4NameCreditList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4NameCredit object.
 */
  Mb4NameCredit mb4_namecredit_list_item(Mb4NameCreditList List, int Item);

/**
 *	Return the count of entries in an #Mb4NameCreditList
 *
 * @param	List List to use
 */
	int mb4_namecredit_list_get_count(Mb4NameCreditList List);

/**
 *	Return the offset of entries in an #Mb4NameCreditList
 *
 * @param	List List to use
 */
	int mb4_namecredit_list_get_offset(Mb4NameCreditList List);

/**
* Clone an #Mb4NameCreditList object
*
* @param NameCreditList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4NameCreditList mb4_namecredit_list_clone(Mb4NameCreditList NameCreditList);

/**
 * Delete a #Mb4NonMBTrackList
 *
 * @param List List to delete
 */
  void mb4_nonmbtrack_list_delete(Mb4NonMBTrackList List);

/**
 * Return the number of entries in a #Mb4NonMBTrackList
 *
 * @param	List List to use
 */
  int mb4_nonmbtrack_list_size(Mb4NonMBTrackList List);

/**
 * Returns an entry from a #Mb4NonMBTrackList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4NonMBTrack object.
 */
  Mb4NonMBTrack mb4_nonmbtrack_list_item(Mb4NonMBTrackList List, int Item);

/**
 *	Return the count of entries in an #Mb4NonMBTrackList
 *
 * @param	List List to use
 */
	int mb4_nonmbtrack_list_get_count(Mb4NonMBTrackList List);

/**
 *	Return the offset of entries in an #Mb4NonMBTrackList
 *
 * @param	List List to use
 */
	int mb4_nonmbtrack_list_get_offset(Mb4NonMBTrackList List);

/**
* Clone an #Mb4NonMBTrackList object
*
* @param NonMBTrackList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4NonMBTrackList mb4_nonmbtrack_list_clone(Mb4NonMBTrackList NonMBTrackList);

/**
 * Delete a #Mb4PUIDList
 *
 * @param List List to delete
 */
  void mb4_puid_list_delete(Mb4PUIDList List);

/**
 * Return the number of entries in a #Mb4PUIDList
 *
 * @param	List List to use
 */
  int mb4_puid_list_size(Mb4PUIDList List);

/**
 * Returns an entry from a #Mb4PUIDList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4PUID object.
 */
  Mb4PUID mb4_puid_list_item(Mb4PUIDList List, int Item);

/**
 *	Return the count of entries in an #Mb4PUIDList
 *
 * @param	List List to use
 */
	int mb4_puid_list_get_count(Mb4PUIDList List);

/**
 *	Return the offset of entries in an #Mb4PUIDList
 *
 * @param	List List to use
 */
	int mb4_puid_list_get_offset(Mb4PUIDList List);

/**
* Clone an #Mb4PUIDList object
*
* @param PUIDList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4PUIDList mb4_puid_list_clone(Mb4PUIDList PUIDList);

/**
 * Delete a #Mb4RecordingList
 *
 * @param List List to delete
 */
  void mb4_recording_list_delete(Mb4RecordingList List);

/**
 * Return the number of entries in a #Mb4RecordingList
 *
 * @param	List List to use
 */
  int mb4_recording_list_size(Mb4RecordingList List);

/**
 * Returns an entry from a #Mb4RecordingList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Recording object.
 */
  Mb4Recording mb4_recording_list_item(Mb4RecordingList List, int Item);

/**
 *	Return the count of entries in an #Mb4RecordingList
 *
 * @param	List List to use
 */
	int mb4_recording_list_get_count(Mb4RecordingList List);

/**
 *	Return the offset of entries in an #Mb4RecordingList
 *
 * @param	List List to use
 */
	int mb4_recording_list_get_offset(Mb4RecordingList List);

/**
* Clone an #Mb4RecordingList object
*
* @param RecordingList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4RecordingList mb4_recording_list_clone(Mb4RecordingList RecordingList);

/**
 * Delete a #Mb4RelationList
 *
 * @param List List to delete
 */
  void mb4_relation_list_delete(Mb4RelationList List);

/**
 * Return the number of entries in a #Mb4RelationList
 *
 * @param	List List to use
 */
  int mb4_relation_list_size(Mb4RelationList List);

/**
 * Returns an entry from a #Mb4RelationList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Relation object.
 */
  Mb4Relation mb4_relation_list_item(Mb4RelationList List, int Item);

/**
 *	Return the count of entries in an #Mb4RelationList
 *
 * @param	List List to use
 */
	int mb4_relation_list_get_count(Mb4RelationList List);

/**
 *	Return the offset of entries in an #Mb4RelationList
 *
 * @param	List List to use
 */
	int mb4_relation_list_get_offset(Mb4RelationList List);

/**
* Clone an #Mb4RelationList object
*
* @param RelationList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4RelationList mb4_relation_list_clone(Mb4RelationList RelationList);

/**
 * @see MusicBrainz4::CRelation::TargetType
 *
 * @param List List to use
 * @param str Returned string
 * @param len Number of characters available in return string
 *
 * @return The number of characters in the string to copy (not including terminating NULL)
 */
  int mb4_relation_list_get_targettype(Mb4RelationList List, char *str, int len);

/**
 * Delete a #Mb4RelationListList
 *
 * @param List List to delete
 */
  void mb4_relationlist_list_delete(Mb4RelationListList List);

/**
 * Return the number of entries in a #Mb4RelationListList
 *
 * @param	List List to use
 */
  int mb4_relationlist_list_size(Mb4RelationListList List);

/**
 * Returns an entry from a #Mb4RelationListList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4RelationList object.
 */
  Mb4RelationList mb4_relationlist_list_item(Mb4RelationListList List, int Item);

/**
 *	Return the count of entries in an #Mb4RelationListList
 *
 * @param	List List to use
 */
	int mb4_relationlist_list_get_count(Mb4RelationListList List);

/**
 *	Return the offset of entries in an #Mb4RelationListList
 *
 * @param	List List to use
 */
	int mb4_relationlist_list_get_offset(Mb4RelationListList List);

/**
* Clone an #Mb4RelationListList object
*
* @param RelationListList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4RelationListList mb4_relationlist_list_clone(Mb4RelationListList RelationListList);

/**
 * Delete a #Mb4ReleaseList
 *
 * @param List List to delete
 */
  void mb4_release_list_delete(Mb4ReleaseList List);

/**
 * Return the number of entries in a #Mb4ReleaseList
 *
 * @param	List List to use
 */
  int mb4_release_list_size(Mb4ReleaseList List);

/**
 * Returns an entry from a #Mb4ReleaseList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Release object.
 */
  Mb4Release mb4_release_list_item(Mb4ReleaseList List, int Item);

/**
 *	Return the count of entries in an #Mb4ReleaseList
 *
 * @param	List List to use
 */
	int mb4_release_list_get_count(Mb4ReleaseList List);

/**
 *	Return the offset of entries in an #Mb4ReleaseList
 *
 * @param	List List to use
 */
	int mb4_release_list_get_offset(Mb4ReleaseList List);

/**
* Clone an #Mb4ReleaseList object
*
* @param ReleaseList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4ReleaseList mb4_release_list_clone(Mb4ReleaseList ReleaseList);

/**
 * Delete a #Mb4ReleaseGroupList
 *
 * @param List List to delete
 */
  void mb4_releasegroup_list_delete(Mb4ReleaseGroupList List);

/**
 * Return the number of entries in a #Mb4ReleaseGroupList
 *
 * @param	List List to use
 */
  int mb4_releasegroup_list_size(Mb4ReleaseGroupList List);

/**
 * Returns an entry from a #Mb4ReleaseGroupList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4ReleaseGroup object.
 */
  Mb4ReleaseGroup mb4_releasegroup_list_item(Mb4ReleaseGroupList List, int Item);

/**
 *	Return the count of entries in an #Mb4ReleaseGroupList
 *
 * @param	List List to use
 */
	int mb4_releasegroup_list_get_count(Mb4ReleaseGroupList List);

/**
 *	Return the offset of entries in an #Mb4ReleaseGroupList
 *
 * @param	List List to use
 */
	int mb4_releasegroup_list_get_offset(Mb4ReleaseGroupList List);

/**
* Clone an #Mb4ReleaseGroupList object
*
* @param ReleaseGroupList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4ReleaseGroupList mb4_releasegroup_list_clone(Mb4ReleaseGroupList ReleaseGroupList);

/**
 * Delete a #Mb4SecondaryTypeList
 *
 * @param List List to delete
 */
  void mb4_secondarytype_list_delete(Mb4SecondaryTypeList List);

/**
 * Return the number of entries in a #Mb4SecondaryTypeList
 *
 * @param	List List to use
 */
  int mb4_secondarytype_list_size(Mb4SecondaryTypeList List);

/**
 * Returns an entry from a #Mb4SecondaryTypeList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4SecondaryType object.
 */
  Mb4SecondaryType mb4_secondarytype_list_item(Mb4SecondaryTypeList List, int Item);

/**
 *	Return the count of entries in an #Mb4SecondaryTypeList
 *
 * @param	List List to use
 */
	int mb4_secondarytype_list_get_count(Mb4SecondaryTypeList List);

/**
 *	Return the offset of entries in an #Mb4SecondaryTypeList
 *
 * @param	List List to use
 */
	int mb4_secondarytype_list_get_offset(Mb4SecondaryTypeList List);

/**
* Clone an #Mb4SecondaryTypeList object
*
* @param SecondaryTypeList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4SecondaryTypeList mb4_secondarytype_list_clone(Mb4SecondaryTypeList SecondaryTypeList);

/**
 * Delete a #Mb4TagList
 *
 * @param List List to delete
 */
  void mb4_tag_list_delete(Mb4TagList List);

/**
 * Return the number of entries in a #Mb4TagList
 *
 * @param	List List to use
 */
  int mb4_tag_list_size(Mb4TagList List);

/**
 * Returns an entry from a #Mb4TagList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Tag object.
 */
  Mb4Tag mb4_tag_list_item(Mb4TagList List, int Item);

/**
 *	Return the count of entries in an #Mb4TagList
 *
 * @param	List List to use
 */
	int mb4_tag_list_get_count(Mb4TagList List);

/**
 *	Return the offset of entries in an #Mb4TagList
 *
 * @param	List List to use
 */
	int mb4_tag_list_get_offset(Mb4TagList List);

/**
* Clone an #Mb4TagList object
*
* @param TagList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4TagList mb4_tag_list_clone(Mb4TagList TagList);

/**
 * Delete a #Mb4TrackList
 *
 * @param List List to delete
 */
  void mb4_track_list_delete(Mb4TrackList List);

/**
 * Return the number of entries in a #Mb4TrackList
 *
 * @param	List List to use
 */
  int mb4_track_list_size(Mb4TrackList List);

/**
 * Returns an entry from a #Mb4TrackList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Track object.
 */
  Mb4Track mb4_track_list_item(Mb4TrackList List, int Item);

/**
 *	Return the count of entries in an #Mb4TrackList
 *
 * @param	List List to use
 */
	int mb4_track_list_get_count(Mb4TrackList List);

/**
 *	Return the offset of entries in an #Mb4TrackList
 *
 * @param	List List to use
 */
	int mb4_track_list_get_offset(Mb4TrackList List);

/**
* Clone an #Mb4TrackList object
*
* @param TrackList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4TrackList mb4_track_list_clone(Mb4TrackList TrackList);

/**
 * Delete a #Mb4UserTagList
 *
 * @param List List to delete
 */
  void mb4_usertag_list_delete(Mb4UserTagList List);

/**
 * Return the number of entries in a #Mb4UserTagList
 *
 * @param	List List to use
 */
  int mb4_usertag_list_size(Mb4UserTagList List);

/**
 * Returns an entry from a #Mb4UserTagList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4UserTag object.
 */
  Mb4UserTag mb4_usertag_list_item(Mb4UserTagList List, int Item);

/**
 *	Return the count of entries in an #Mb4UserTagList
 *
 * @param	List List to use
 */
	int mb4_usertag_list_get_count(Mb4UserTagList List);

/**
 *	Return the offset of entries in an #Mb4UserTagList
 *
 * @param	List List to use
 */
	int mb4_usertag_list_get_offset(Mb4UserTagList List);

/**
* Clone an #Mb4UserTagList object
*
* @param UserTagList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4UserTagList mb4_usertag_list_clone(Mb4UserTagList UserTagList);

/**
 * Delete a #Mb4WorkList
 *
 * @param List List to delete
 */
  void mb4_work_list_delete(Mb4WorkList List);

/**
 * Return the number of entries in a #Mb4WorkList
 *
 * @param	List List to use
 */
  int mb4_work_list_size(Mb4WorkList List);

/**
 * Returns an entry from a #Mb4WorkList
 *
 * @param List List to use
 * @param Item Item number to return
 *
 * @return A #Mb4Work object.
 */
  Mb4Work mb4_work_list_item(Mb4WorkList List, int Item);

/**
 *	Return the count of entries in an #Mb4WorkList
 *
 * @param	List List to use
 */
	int mb4_work_list_get_count(Mb4WorkList List);

/**
 *	Return the offset of entries in an #Mb4WorkList
 *
 * @param	List List to use
 */
	int mb4_work_list_get_offset(Mb4WorkList List);

/**
* Clone an #Mb4WorkList object
*
* @param WorkList Object to clone
*
* @return Cloned list. This list <b>must</b> be deleted once
*				finished with.
*/
  Mb4WorkList mb4_work_list_clone(Mb4WorkList WorkList);

#ifdef __cplusplus
}
#endif

#endif

