/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.ext.ripper.LexerSource;
import org.jruby.ext.ripper.RipperLexer;
import org.jruby.ext.ripper.StrTerm;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.lexer.yacc.StackState;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RipperParser {
    protected IRubyObject ripper;
    protected ThreadContext context;
    protected RipperLexer lexer;
    protected StaticScope currentScope;
    protected boolean inDefinition;
    protected boolean yydebug;
    protected int inSingleton;

    public RipperParser(ThreadContext context, IRubyObject ripper, LexerSource source) {
        this.context = context;
        this.ripper = ripper;
        this.lexer = new RipperLexer(this, source);
    }

    static int associateEncoding(ByteList buffer, Encoding ASCII8BIT_ENCODING, int codeRange) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void reset() {
    }

    public Object yyparse(RipperLexer yyLex) throws IOException {
        return null;
    }

    public Object yyparse(RipperLexer yyLex, Object debugger) throws IOException {
        return null;
    }

    public IRubyObject parse(boolean isDebug) throws IOException {
        this.reset();
        this.lexer.parser_prepare();
        return (IRubyObject)this.yyparse(this.lexer, null);
    }

    public IRubyObject arg_add_optblock(IRubyObject arg1, IRubyObject arg2) {
        if (arg2 == null) {
            return this.dispatch("on_args_add_block", arg1, (IRubyObject)this.getRuntime().getFalse());
        }
        if (arg2.isNil()) {
            return arg1;
        }
        return this.dispatch("on_args_add_block", arg1, arg2);
    }

    public IRubyObject arg_var(IRubyObject identifier) {
        String name = this.lexer.getIdent();
        StaticScope current = this.getCurrentScope();
        if (name == "_") {
            int count = 0;
            while (current.exists(name) >= 0) {
                name = "_$" + count++;
            }
        }
        current.addVariableThisScope(name);
        return identifier;
    }

    public IRubyObject assignable(IRubyObject name) {
        if (!(name instanceof RubyString)) {
            return name;
        }
        String javaName = name.asJavaString();
        if (javaName.equals("self")) {
            this.yyerror("Can't change the value of self");
        } else if (javaName.equals("nil")) {
            this.yyerror("Can't assign to nil");
        } else if (javaName.equals("true")) {
            this.yyerror("Can't assign to true");
        } else if (javaName.equals("false")) {
            this.yyerror("Can't assign to false");
        } else if (javaName.equals("__FILE__")) {
            this.yyerror("Can't assign to __FILE__");
        } else if (javaName.equals("__LINE__")) {
            this.yyerror("Can't assign to __LINE__");
        } else {
            if (Character.isUpperCase(javaName.charAt(0))) {
                if (this.isInDef() || this.isInSingle()) {
                    this.dispatch("on_assign_error", name);
                }
                return name;
            }
            if (javaName.charAt(0) == '@') {
                if (javaName.charAt(1) == '@') {
                    return name;
                }
                return name;
            }
            if (javaName.charAt(0) == '$') {
                return name;
            }
        }
        return name;
    }

    public IRubyObject dispatch(String method_name) {
        return Helpers.invoke((ThreadContext)this.context, (IRubyObject)this.ripper, (String)method_name);
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1) {
        return Helpers.invoke((ThreadContext)this.context, (IRubyObject)this.ripper, (String)method_name, (IRubyObject)this.escape(arg1));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2) {
        return Helpers.invoke((ThreadContext)this.context, (IRubyObject)this.ripper, (String)method_name, (IRubyObject)this.escape(arg1), (IRubyObject)this.escape(arg2));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        return Helpers.invoke((ThreadContext)this.context, (IRubyObject)this.ripper, (String)method_name, (IRubyObject)this.escape(arg1), (IRubyObject)this.escape(arg2), (IRubyObject)this.escape(arg3));
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4) {
        return Helpers.invoke((ThreadContext)this.context, (IRubyObject)this.ripper, (String)method_name, (IRubyObject[])new IRubyObject[]{this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4)});
    }

    public IRubyObject dispatch(String method_name, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, IRubyObject arg4, IRubyObject arg5) {
        return Helpers.invoke((ThreadContext)this.context, (IRubyObject)this.ripper, (String)method_name, (IRubyObject[])new IRubyObject[]{this.escape(arg1), this.escape(arg2), this.escape(arg3), this.escape(arg4), this.escape(arg5)});
    }

    public IRubyObject escape(IRubyObject arg) {
        return arg == null ? this.context.runtime.getNil() : arg;
    }

    public IRubyObject formal_argument(IRubyObject identifier) {
        return this.shadowing_lvar(identifier);
    }

    protected void getterIdentifierError(String identifier) {
        throw new SyntaxException("identifier " + identifier + " is not valid", identifier);
    }

    public boolean is_id_var(IRubyObject identifier) {
        String ident = this.lexer.getIdent();
        ident.intern();
        char c = ident.charAt(0);
        if (c == '$' || c == '@' || Character.toUpperCase(c) == c) {
            return true;
        }
        return this.getCurrentScope().getLocalScope().isDefined(ident) >= 0;
    }

    public boolean is_local_id(String identifier) {
        return this.lexer.isIdentifierChar(identifier.charAt(0));
    }

    public IRubyObject intern(String value) {
        return this.context.runtime.newSymbol(value);
    }

    public IRubyObject method_optarg(IRubyObject method, IRubyObject arg) {
        if (arg == null) {
            return method;
        }
        return this.dispatch("on_method_add_arg", method, arg);
    }

    public IRubyObject new_array(IRubyObject arg) {
        return this.context.runtime.newArray(arg);
    }

    public IRubyObject new_assoc(IRubyObject key, IRubyObject value) {
        return RubyArray.newArray((Ruby)this.context.runtime, (IRubyObject)key, (IRubyObject)value);
    }

    public IRubyObject new_bv(IRubyObject identifier) {
        String ident = this.lexer.getIdent();
        if (!this.is_local_id(ident)) {
            this.getterIdentifierError(ident);
        }
        return this.arg_var(this.shadowing_lvar(identifier));
    }

    public void popCurrentScope() {
        this.currentScope = this.currentScope.getEnclosingScope();
    }

    public void pushBlockScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newBlockScope(this.currentScope);
    }

    public void pushLocalScope() {
        this.currentScope = this.getRuntime().getStaticScopeFactory().newLocalScope(this.currentScope);
    }

    public void setCommandStart(boolean value) {
        this.lexer.commandStart = value;
    }

    public IRubyObject shadowing_lvar(IRubyObject identifier) {
        String name = this.lexer.getIdent();
        if (name == "_") {
            return identifier;
        }
        StaticScope current = this.getCurrentScope();
        if (current.isBlockScope()) {
            if (current.exists(name) >= 0) {
                this.yyerror("duplicated argument name");
            }
            if (this.lexer.isVerbose() && current.isDefined(name) >= 0) {
                this.lexer.warning("shadowing outer local variable - " + name);
            }
        } else if (current.exists(name) >= 0) {
            this.yyerror("duplicated argument name");
        }
        return identifier;
    }

    public StackState getConditionState() {
        return this.lexer.getConditionState();
    }

    public boolean isInDef() {
        return this.inDefinition;
    }

    public boolean isInSingle() {
        return this.inSingleton != 0;
    }

    public StrTerm getStrTerm() {
        return this.lexer.getStrTerm();
    }

    public void setStrTerm(StrTerm object) {
        this.lexer.setStrTerm(object);
    }

    public StackState getCmdArgumentState() {
        return this.lexer.getCmdArgumentState();
    }

    public void compile_error(String message) {
        this.dispatch("on_parse_error", (IRubyObject)this.getRuntime().newString(message));
    }

    public void yyerror(String message) {
        this.compile_error(message);
        throw new SyntaxException(message, message);
    }

    public void yyerror(String message, String[] expected, String found) {
        this.compile_error(message + ", unexpected " + found + "\n");
    }

    public Integer getLeftParenBegin() {
        return this.lexer.getLeftParenBegin();
    }

    public void setLeftParenBegin(Integer integer) {
        this.lexer.setLeftParenBegin(integer);
    }

    public void setInDef(boolean inDefinition) {
        this.inDefinition = inDefinition;
    }

    public void setInSingle(int inSingleton) {
        this.inSingleton = inSingleton;
    }

    public int getInSingle() {
        return this.inSingleton;
    }

    public void setState(RipperLexer.LexState lexState) {
        this.lexer.setState(lexState);
    }

    public void warning(String message) {
        if (this.lexer.isVerbose()) {
            this.lexer.warning(message);
        }
    }

    public void warn(String message) {
        this.lexer.warn(message);
    }

    public Integer incrementParenNest() {
        return this.lexer.incrementParenNest();
    }

    public StaticScope getCurrentScope() {
        return this.currentScope;
    }

    public Ruby getRuntime() {
        return this.context.runtime;
    }

    public long getColumn() {
        return this.lexer.column();
    }

    public long getLineno() {
        return this.lexer.lineno();
    }

    public boolean hasStarted() {
        return this.lexer.hasStarted();
    }

    public Encoding encoding() {
        return this.lexer.getEncoding();
    }

    public boolean getYYDebug() {
        return this.yydebug;
    }

    public void setYYDebug(boolean yydebug) {
        this.yydebug = yydebug;
    }

    public boolean isEndSeen() {
        return this.lexer.isEndSeen();
    }

    public ThreadContext getContext() {
        return this.context;
    }
}

