/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.exceptions.RaiseException;

public class Errors {
    private Errors() {
    }

    public static RaiseException newKryptError(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::Error", message);
    }

    public static RaiseException newParseError(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::ASN1::ParseError", message);
    }

    public static RaiseException newSerializeError(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::ASN1::SerializeError", message);
    }

    public static RaiseException newASN1Error(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::ASN1::ASN1Error", message);
    }

    public static RaiseException newPEMError(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::PEM::PEMError", message);
    }

    public static RaiseException newHexError(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::Hex::HexError", message);
    }

    public static RaiseException newBase64Error(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::Base64::Base64Error", message);
    }

    public static RaiseException newDigestError(Ruby rt, String message) {
        return Errors.newError(rt, "Krypt::Digest::DigestError", message);
    }

    public static RaiseException newError(Ruby rt, String path, String message) {
        return new RaiseException(rt, Errors.getClassFromPath(rt, path), message, true);
    }

    public static RubyClass getClassFromPath(Ruby rt, String path) {
        return (RubyClass)rt.getClassFromPath(path);
    }
}

