/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.Purpose;
import org.jruby.ext.openssl.x509store.X509Aux;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;

public class Trust {
    public int trust;
    public int flags;
    public Checker checkTrust;
    public String name;
    public String arg1;
    public Object arg2;
    private static final List<Trust> trtable = new ArrayList<Trust>();
    public static final Checker trustCompatibe = new Checker(){

        @Override
        public int call(Object _trust, Object _x, Object _flags) throws Exception {
            X509AuxCertificate x = (X509AuxCertificate)_x;
            Purpose.checkPurpose(x, -1, 0);
            if (x.getIssuerX500Principal().equals(x.getSubjectX500Principal())) {
                return 1;
            }
            return 3;
        }
    };
    public static final Checker trust1OIDAny = new Checker(){

        @Override
        public int call(Object _trust, Object _x, Object _flags) throws Exception {
            Trust trust = (Trust)_trust;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int flags = (Integer)_flags;
            X509Aux ax = x.getAux();
            if (ax != null && (ax.trust.size() > 0 || ax.reject.size() > 0)) {
                return objTrust.call(trust.arg1, x, new Integer(flags));
            }
            return trustCompatibe.call(trust, x, new Integer(flags));
        }
    };
    public static final Checker trust1OID = new Checker(){

        @Override
        public int call(Object _trust, Object _x, Object _flags) throws Exception {
            Trust trust = (Trust)_trust;
            X509AuxCertificate x = (X509AuxCertificate)_x;
            int flags = (Integer)_flags;
            if (x.getAux() != null) {
                return objTrust.call(trust.arg1, x, new Integer(flags));
            }
            return 3;
        }
    };
    public static final Checker objTrust;
    public static Checker defaultTrust;
    public static final Trust[] trstandard;

    public Trust() {
    }

    public Trust(int t, int f, Checker ct, String n, String a1, Object a2) {
        this.trust = t;
        this.flags = f;
        this.checkTrust = ct;
        this.name = n;
        this.arg1 = a1;
        this.arg2 = a2;
    }

    public static Checker setDefault(Checker trust) {
        Checker old_trust = defaultTrust;
        defaultTrust = trust;
        return old_trust;
    }

    public static int checkTrust(X509AuxCertificate x, int id, int flags) throws Exception {
        if (id == -1) {
            return 1;
        }
        int idx = Trust.getByID(id);
        if (idx == -1) {
            return defaultTrust.call(new Integer(id), x, new Integer(flags));
        }
        Trust pt = Trust.getFirst(idx);
        return pt.checkTrust.call(pt, x, new Integer(flags));
    }

    public static int getCount() {
        return trtable.size() + trstandard.length;
    }

    public static Trust getFirst(int idx) {
        if (idx < 0) {
            return null;
        }
        if (idx < trstandard.length) {
            return trstandard[idx];
        }
        return trtable.get(idx - trstandard.length);
    }

    public static int getByID(int id) {
        if (id >= 1 && id <= 7) {
            return id - 1;
        }
        int i = 0;
        for (Trust t : trtable) {
            if (t.trust != id) continue;
            return i + trstandard.length;
        }
        return -1;
    }

    public static int set(int[] t, int trust) {
        if (Trust.getByID(trust) == -1) {
            X509Error.addError(123);
            return 0;
        }
        t[0] = trust;
        return 1;
    }

    public static int add(int id, int flags, Checker ck, String name, String arg1, Object arg2) {
        Trust trtmp;
        flags &= 0xFFFFFFFE;
        flags |= 2;
        int idx = Trust.getByID(id);
        if (idx == -1) {
            trtmp = new Trust();
            trtmp.flags = 1;
        } else {
            trtmp = Trust.getFirst(idx);
        }
        trtmp.name = name;
        trtmp.flags &= 1;
        trtmp.flags |= flags;
        trtmp.trust = id;
        trtmp.checkTrust = ck;
        trtmp.arg1 = arg1;
        trtmp.arg2 = arg2;
        if (idx == -1) {
            trtable.add(trtmp);
        }
        return 1;
    }

    public static void cleanup() {
        trtable.clear();
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public int getTrust() {
        return this.trust;
    }

    static {
        defaultTrust = objTrust = new Checker(){

            @Override
            public int call(Object _id, Object _x, Object _flags) {
                String id = (String)_id;
                X509AuxCertificate x = (X509AuxCertificate)_x;
                X509Aux ax = x.getAux();
                if (null == ax) {
                    return 3;
                }
                for (String rej : ax.reject) {
                    if (!rej.equals(id)) continue;
                    return 2;
                }
                for (String t : ax.trust) {
                    if (!t.equals(id)) continue;
                    return 1;
                }
                return 3;
            }
        };
        trstandard = new Trust[]{new Trust(1, 0, trustCompatibe, "compatible", null, null), new Trust(2, 0, trust1OIDAny, "SSL Client", "1.3.6.1.5.5.7.3.2", null), new Trust(3, 0, trust1OIDAny, "SSL Server", "1.3.6.1.5.5.7.3.1", null), new Trust(4, 0, trust1OIDAny, "S/MIME email", "1.3.6.1.5.5.7.3.4", null), new Trust(5, 0, trust1OIDAny, "Object Signer", "1.3.6.1.5.5.7.3.3", null), new Trust(6, 0, trust1OID, "OCSP responder", "1.3.6.1.5.5.7.3.9", null), new Trust(7, 0, trust1OID, "OCSP request", "1.3.6.1.5.5.7.48.1", null)};
    }

    public static interface Checker
    extends Function3 {
    }
}

