/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.FileNotFoundException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jruby.ext.openssl.x509store.CRL;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.CertificateFile;
import org.jruby.ext.openssl.x509store.CertificateHashDir;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function2;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.Lookup;
import org.jruby.ext.openssl.x509store.LookupMethod;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.VerifyParameter;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;
import org.jruby.ext.openssl.x509store.X509Utils;

public class Store
implements X509TrustManager {
    public int cache = 1;
    public List<X509Object> objs = new ArrayList<X509Object>();
    public List<Lookup> certificateMethods = new ArrayList<Lookup>();
    public VerifyParameter param;
    public VerifyFunction verify = VerifyFunction.EMPTY;
    public VerifyCallbackFunction verifyCallback = VerifyCallbackFunction.EMPTY;
    public GetIssuerFunction getIssuer;
    public CheckIssuedFunction checkIssued;
    public CheckRevocationFunction checkRevocation;
    public GetCRLFunction getCRL;
    public CheckCRLFunction checkCRL;
    public CertificateCRLFunction certificateCRL;
    public CleanupFunction cleanup;
    public List<Object> extraData;
    public int references = 1;

    public Store() {
        this.param = new VerifyParameter();
        this.getIssuer = GetIssuerFunction.EMPTY;
        this.checkIssued = CheckIssuedFunction.EMPTY;
        this.checkRevocation = CheckRevocationFunction.EMPTY;
        this.getCRL = GetCRLFunction.EMPTY;
        this.checkCRL = CheckCRLFunction.EMPTY;
        this.certificateCRL = CertificateCRLFunction.EMPTY;
        this.cleanup = CleanupFunction.EMPTY;
        this.extraData = new ArrayList<Object>();
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
    }

    public void setVerifyFunction(VerifyFunction func) {
        this.verify = func;
    }

    public void setVerifyCallbackFunction(VerifyCallbackFunction func) {
        this.verifyCallback = func;
    }

    public void free() throws Exception {
        for (Lookup lu : this.certificateMethods) {
            lu.shutdown();
            lu.free();
        }
        if (this.param != null) {
            this.param.free();
        }
    }

    public int setExtraData(int idx, Object data) {
        this.extraData.set(idx, data);
        return 1;
    }

    public Object getExtraData(int idx) {
        return this.extraData.get(idx);
    }

    public int setDepth(int depth) {
        this.param.setDepth(depth);
        return 1;
    }

    public int setFlags(long flags) {
        return this.param.setFlags(flags);
    }

    public int setPurpose(int purpose) {
        return this.param.setPurpose(purpose);
    }

    public int setTrust(int trust) {
        return this.param.setTrust(trust);
    }

    public int setParam(VerifyParameter pm) {
        return this.param.set(this.param);
    }

    public Lookup addLookup(LookupMethod m) throws Exception {
        for (Lookup l : this.certificateMethods) {
            if (!l.equals(m)) continue;
            return l;
        }
        Lookup lu = new Lookup(m);
        lu.store = this;
        this.certificateMethods.add(lu);
        return lu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCertificate(X509Certificate x) {
        int ret = 1;
        if (x == null) {
            return 0;
        }
        Certificate obj = new Certificate();
        obj.x509 = StoreContext.ensureAux(x);
        Object object = X509Utils.CRYPTO_LOCK_X509_STORE;
        synchronized (object) {
            if (X509Object.retrieveMatch(this.objs, obj) != null) {
                X509Error.addError(101);
                ret = 0;
            } else {
                this.objs.add(obj);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCRL(java.security.cert.CRL x) {
        int ret = 1;
        if (null == x) {
            return 0;
        }
        CRL obj = new CRL();
        obj.crl = x;
        Object object = X509Utils.CRYPTO_LOCK_X509_STORE;
        synchronized (object) {
            if (X509Object.retrieveMatch(this.objs, obj) != null) {
                X509Error.addError(101);
                ret = 0;
            } else {
                this.objs.add(obj);
            }
        }
        return ret;
    }

    public int loadLocations(String file, String path) throws Exception {
        Lookup lookup;
        if (file != null) {
            lookup = this.addLookup(Lookup.fileLookup());
            if (lookup == null) {
                return 0;
            }
            if (lookup.loadFile(new CertificateFile.Path(file, 1)) != 1) {
                return 0;
            }
        }
        if (path != null) {
            lookup = this.addLookup(Lookup.hashDirLookup());
            if (lookup == null) {
                return 0;
            }
            if (lookup.addDir(new CertificateHashDir.Dir(path, 1)) != 1) {
                return 0;
            }
        }
        if (path == null && file == null) {
            return 0;
        }
        return 1;
    }

    public int setDefaultPaths() throws Exception {
        Lookup lookup = this.addLookup(Lookup.fileLookup());
        if (lookup == null) {
            return 0;
        }
        try {
            lookup.loadFile(new CertificateFile.Path(null, 3));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        lookup = this.addLookup(Lookup.hashDirLookup());
        if (lookup == null) {
            return 0;
        }
        try {
            lookup.addDir(new CertificateHashDir.Dir(null, 3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        X509Error.clearErrors();
        return 1;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509AuxCertificate> l = new ArrayList<X509AuxCertificate>();
        for (X509Object o : this.objs) {
            if (!(o instanceof Certificate)) continue;
            l.add(((Certificate)o).x509);
        }
        return l.toArray(new X509Certificate[l.size()]);
    }

    public static interface CleanupFunction
    extends Function1 {
        public static final CleanupFunction EMPTY = new CleanupFunction(){

            @Override
            public int call(Object arg0) {
                return -1;
            }
        };
    }

    public static interface CertificateCRLFunction
    extends Function3 {
        public static final CertificateCRLFunction EMPTY = new CertificateCRLFunction(){

            @Override
            public int call(Object arg0, Object arg1, Object arg2) {
                return -1;
            }
        };
    }

    public static interface CheckCRLFunction
    extends Function2 {
        public static final CheckCRLFunction EMPTY = new CheckCRLFunction(){

            @Override
            public int call(Object arg0, Object arg1) {
                return -1;
            }
        };
    }

    public static interface GetCRLFunction
    extends Function3 {
        public static final GetCRLFunction EMPTY = new GetCRLFunction(){

            @Override
            public int call(Object arg0, Object arg1, Object arg2) {
                return -1;
            }
        };
    }

    public static interface CheckRevocationFunction
    extends Function1 {
        public static final CheckRevocationFunction EMPTY = new CheckRevocationFunction(){

            @Override
            public int call(Object arg0) {
                return -1;
            }
        };
    }

    public static interface CheckIssuedFunction
    extends Function3 {
        public static final CheckIssuedFunction EMPTY = new CheckIssuedFunction(){

            @Override
            public int call(Object arg0, Object arg1, Object arg2) {
                return -1;
            }
        };
    }

    public static interface GetIssuerFunction
    extends Function3 {
        public static final GetIssuerFunction EMPTY = new GetIssuerFunction(){

            @Override
            public int call(Object arg0, Object arg1, Object arg2) {
                return -1;
            }
        };
    }

    public static interface VerifyCallbackFunction
    extends Function2 {
        public static final VerifyCallbackFunction EMPTY = new VerifyCallbackFunction(){

            @Override
            public int call(Object arg0, Object arg1) {
                return -1;
            }
        };
    }

    public static interface VerifyFunction
    extends Function1 {
        public static final VerifyFunction EMPTY = new VerifyFunction(){

            @Override
            public int call(Object arg0) {
                return -1;
            }
        };
    }
}

