/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509CRL;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509StoreCtx;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Store
extends RubyObject {
    private static final long serialVersionUID = 7987156710610206194L;
    private static ObjectAllocator X509STORE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Store(runtime, klass);
        }
    };
    private RubyClass cStoreError;
    private RubyClass cStoreContext;
    private Store store = new Store();
    public static final Store.VerifyCallbackFunction ossl_verify_cb = new Store.VerifyCallbackFunction(){

        @Override
        public int call(Object a1, Object a2) throws Exception {
            StoreContext ctx = (StoreContext)a2;
            int ok = (Integer)a1;
            IRubyObject proc = (IRubyObject)ctx.getExtraData(1);
            if (null == proc) {
                proc = (IRubyObject)ctx.ctx.getExtraData(0);
            }
            if (null == proc) {
                return ok;
            }
            if (!proc.isNil()) {
                Ruby rt = proc.getRuntime();
                RubyClass cStoreContext = Utils.getClassFromPath(rt, "OpenSSL::X509::StoreContext");
                X509StoreCtx rctx = new X509StoreCtx(rt, cStoreContext, ctx);
                RubyBoolean rok = rt.newBoolean(ok != 0);
                IRubyObject ret = proc.callMethod(rt.getCurrentContext(), "call", new IRubyObject[]{rok, rctx});
                if (ret.isTrue()) {
                    ctx.setError(0);
                    ok = 1;
                } else {
                    if (ctx.getError() == 0) {
                        ctx.setError(28);
                    }
                    ok = 0;
                }
            }
            return ok;
        }
    };

    public static void createX509Store(Ruby runtime, RubyModule mX509) {
        RubyClass cX509Store = mX509.defineClassUnder("Store", runtime.getObject(), X509STORE_ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("StoreError", openSSLError, openSSLError.getAllocator());
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "verify_callback");
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "error");
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "error_string");
        cX509Store.addReadWriteAttribute(runtime.getCurrentContext(), "chain");
        cX509Store.defineAnnotatedMethods(X509Store.class);
        X509StoreCtx.createX509StoreCtx(runtime, mX509);
    }

    public X509Store(Ruby runtime, RubyClass type) {
        super(runtime, type);
        this.cStoreError = Utils.getClassFromPath(runtime, "OpenSSL::X509::StoreError");
        this.cStoreContext = Utils.getClassFromPath(runtime, "OpenSSL::X509::StoreContext");
    }

    Store getStore() {
        return this.store;
    }

    private void raise(String msg) {
        throw new RaiseException(this.getRuntime(), this.cStoreError, msg, true);
    }

    @JRubyMethod(name={"initialize"}, rest=true)
    public IRubyObject _initialize(IRubyObject[] args, Block block) {
        this.store.setVerifyCallbackFunction(ossl_verify_cb);
        this.set_verify_callback(this.getRuntime().getNil());
        this.setInstanceVariable("@flags", (IRubyObject)RubyFixnum.zero((Ruby)this.getRuntime()));
        this.setInstanceVariable("@purpose", (IRubyObject)RubyFixnum.zero((Ruby)this.getRuntime()));
        this.setInstanceVariable("@trust", (IRubyObject)RubyFixnum.zero((Ruby)this.getRuntime()));
        this.setInstanceVariable("@error", this.getRuntime().getNil());
        this.setInstanceVariable("@error_string", this.getRuntime().getNil());
        this.setInstanceVariable("@chain", this.getRuntime().getNil());
        this.setInstanceVariable("@time", this.getRuntime().getNil());
        return this;
    }

    @JRubyMethod(name={"verify_callback="})
    public IRubyObject set_verify_callback(IRubyObject cb) {
        this.store.setExtraData(1, cb);
        this.setInstanceVariable("@verify_callback", cb);
        return cb;
    }

    @JRubyMethod(name={"flags="})
    public IRubyObject set_flags(IRubyObject arg) {
        this.store.setFlags(RubyNumeric.fix2long((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"purpose="})
    public IRubyObject set_purpose(IRubyObject arg) {
        this.store.setPurpose(RubyNumeric.fix2int((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"trust="})
    public IRubyObject set_trust(IRubyObject arg) {
        this.store.setTrust(RubyNumeric.fix2int((IRubyObject)arg));
        return arg;
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject arg) {
        this.setInstanceVariable("@time", arg);
        return arg;
    }

    @JRubyMethod
    public IRubyObject add_path(IRubyObject arg) {
        this.getRuntime().getWarnings().warn("unimplemented method called: Store#add_path");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject add_file(IRubyObject arg) {
        String file = arg.toString();
        try {
            this.store.loadLocations(file, null);
        }
        catch (Exception e) {
            this.raise("loading file failed: " + e.getMessage());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject set_default_paths() {
        try {
            this.store.setDefaultPaths();
        }
        catch (Exception e) {
            this.raise("setting default path failed: " + e.getMessage());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject add_cert(IRubyObject _cert) {
        X509AuxCertificate cert;
        X509AuxCertificate x509AuxCertificate = cert = _cert instanceof X509Cert ? ((X509Cert)_cert).getAuxCert() : (X509AuxCertificate)null;
        if (this.store.addCertificate(cert) != 1) {
            this.raise(null);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject add_crl(IRubyObject arg) {
        java.security.cert.X509CRL crl;
        java.security.cert.X509CRL x509CRL = crl = arg instanceof X509CRL ? ((X509CRL)arg).getCRL() : null;
        if (this.store.addCRL(crl) != 1) {
            this.raise(null);
        }
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject verify(IRubyObject[] args, Block block) {
        IRubyObject chain = Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2 ? args[1] : this.getRuntime().getNil();
        IRubyObject cert = args[0];
        X509StoreCtx ctx = (X509StoreCtx)this.cStoreContext.callMethod(this.getRuntime().getCurrentContext(), "new", new IRubyObject[]{this, cert, chain});
        Object proc = block.isGiven() ? this.getRuntime().newProc(Block.Type.PROC, block) : this.getInstanceVariable("@verify_callback");
        ctx.setInstanceVariable("@verify_callback", (IRubyObject)proc);
        IRubyObject result = ctx.callMethod(this.getRuntime().getCurrentContext(), "verify");
        this.setInstanceVariable("@error", ctx.error());
        this.setInstanceVariable("@error_string", ctx.error_string());
        this.setInstanceVariable("@chain", ctx.chain());
        return result;
    }
}

