/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.x509.X509Name;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ASN1 {
    private static Map<Ruby, Map<String, ASN1ObjectIdentifier>> SYM_TO_OID = new IdentityHashMap<Ruby, Map<String, ASN1ObjectIdentifier>>();
    private static Map<Ruby, Map<ASN1ObjectIdentifier, String>> OID_TO_SYM = new IdentityHashMap<Ruby, Map<ASN1ObjectIdentifier, String>>();
    private static Map<Ruby, Map<ASN1ObjectIdentifier, Integer>> OID_TO_NID = new IdentityHashMap<Ruby, Map<ASN1ObjectIdentifier, Integer>>();
    private static Map<Ruby, Map<Integer, ASN1ObjectIdentifier>> NID_TO_OID = new IdentityHashMap<Ruby, Map<Integer, ASN1ObjectIdentifier>>();
    private static Map<Ruby, Map<Integer, String>> NID_TO_SN = new IdentityHashMap<Ruby, Map<Integer, String>>();
    private static Map<Ruby, Map<Integer, String>> NID_TO_LN = new IdentityHashMap<Ruby, Map<Integer, String>>();
    private static final Object[][] ASN1_INFO = new Object[][]{{"EOC", null, null}, {"BOOLEAN", DERBoolean.class, "Boolean"}, {"INTEGER", ASN1Integer.class, "Integer"}, {"BIT_STRING", DERBitString.class, "BitString"}, {"OCTET_STRING", DEROctetString.class, "OctetString"}, {"NULL", DERNull.class, "Null"}, {"OBJECT", ASN1ObjectIdentifier.class, "ObjectId"}, {"OBJECT_DESCRIPTOR", null, null}, {"EXTERNAL", null, null}, {"REAL", null, null}, {"ENUMERATED", DEREnumerated.class, "Enumerated"}, {"EMBEDDED_PDV", null, null}, {"UTF8STRING", DERUTF8String.class, "UTF8String"}, {"RELATIVE_OID", null, null}, {"[UNIVERSAL 14]", null, null}, {"[UNIVERSAL 15]", null, null}, {"SEQUENCE", DLSequence.class, "Sequence"}, {"SET", DLSet.class, "Set"}, {"NUMERICSTRING", DERNumericString.class, "NumericString"}, {"PRINTABLESTRING", DERPrintableString.class, "PrintableString"}, {"T61STRING", DERT61String.class, "T61String"}, {"VIDEOTEXSTRING", null, null}, {"IA5STRING", DERIA5String.class, "IA5String"}, {"UTCTIME", DERUTCTime.class, "UTCTime"}, {"GENERALIZEDTIME", DERGeneralizedTime.class, "GeneralizedTime"}, {"GRAPHICSTRING", null, null}, {"ISO64STRING", null, null}, {"GENERALSTRING", DERGeneralString.class, "GeneralString"}, {"UNIVERSALSTRING", DERUniversalString.class, "UniversalString"}, {"CHARACTER_STRING", null, null}, {"BMPSTRING", DERBMPString.class, "BMPString"}};
    private static final Map<Class, Integer> CLASS_TO_ID = new HashMap<Class, Integer>();
    private static final Map<String, Integer> RUBYNAME_TO_ID = new HashMap<String, Integer>();
    private static final DateFormat dateF;

    static void addObject(Ruby runtime, int nid, String sn, String ln, String oid) {
        Map<String, ASN1ObjectIdentifier> s2o = SYM_TO_OID.get(runtime);
        Map<ASN1ObjectIdentifier, String> o2s = OID_TO_SYM.get(runtime);
        Map<ASN1ObjectIdentifier, Integer> o2n = OID_TO_NID.get(runtime);
        Map<Integer, ASN1ObjectIdentifier> n2o = NID_TO_OID.get(runtime);
        Map<Integer, String> n2s = NID_TO_SN.get(runtime);
        Map<Integer, String> n2l = NID_TO_LN.get(runtime);
        if (null != oid && (null != sn || null != ln)) {
            ASN1ObjectIdentifier ident = new ASN1ObjectIdentifier(oid);
            if (sn != null) {
                s2o.put(sn.toLowerCase(), ident);
            }
            if (ln != null) {
                s2o.put(ln.toLowerCase(), ident);
            }
            o2s.put(ident, sn == null ? ln : sn);
            o2n.put(ident, nid);
            n2o.put(nid, ident);
            n2s.put(nid, sn);
            n2l.put(nid, ln);
        }
    }

    private static synchronized void initMaps(Ruby runtime) {
        HashMap val = new HashMap(X509Name.DefaultLookUp);
        HashMap val2 = new HashMap(X509Name.DefaultSymbols);
        SYM_TO_OID.put(runtime, val);
        OID_TO_SYM.put(runtime, val2);
        OID_TO_NID.put(runtime, new HashMap());
        NID_TO_OID.put(runtime, new HashMap());
        NID_TO_SN.put(runtime, new HashMap());
        NID_TO_LN.put(runtime, new HashMap());
        OpenSSLImpl.defaultObjects(runtime);
    }

    static synchronized Integer obj2nid(Ruby runtime, String oid) {
        return ASN1.obj2nid(runtime, new ASN1ObjectIdentifier(oid));
    }

    static synchronized String ln2oid(Ruby runtime, String ln) {
        Map<String, ASN1ObjectIdentifier> val = SYM_TO_OID.get(runtime);
        if (null == val) {
            ASN1.initMaps(runtime);
            val = SYM_TO_OID.get(runtime);
        }
        return val.get(ln).getId();
    }

    static synchronized Integer obj2nid(Ruby runtime, ASN1ObjectIdentifier oid) {
        Map<ASN1ObjectIdentifier, Integer> o2n = OID_TO_NID.get(runtime);
        if (null == o2n) {
            ASN1.initMaps(runtime);
            o2n = OID_TO_NID.get(runtime);
        }
        return o2n.get(oid);
    }

    static synchronized String o2a(Ruby runtime, ASN1ObjectIdentifier obj) {
        Integer nid = ASN1.obj2nid(runtime, obj);
        Map<Integer, String> n2l = NID_TO_LN.get(runtime);
        Map<Integer, String> n2s = NID_TO_SN.get(runtime);
        String one = n2l.get(nid);
        if (one == null) {
            one = n2s.get(nid);
        }
        return one;
    }

    static synchronized String nid2ln(Ruby runtime, int nid) {
        return ASN1.nid2ln(runtime, new Integer(nid));
    }

    static synchronized String nid2ln(Ruby runtime, Integer nid) {
        Map<Integer, String> n2l = NID_TO_LN.get(runtime);
        if (null == n2l) {
            ASN1.initMaps(runtime);
            n2l = NID_TO_LN.get(runtime);
        }
        return n2l.get(nid);
    }

    static synchronized Map<String, ASN1ObjectIdentifier> getOIDLookup(Ruby runtime) {
        Map<String, ASN1ObjectIdentifier> val = SYM_TO_OID.get(runtime);
        if (null == val) {
            ASN1.initMaps(runtime);
            val = SYM_TO_OID.get(runtime);
        }
        return val;
    }

    static synchronized Map<ASN1ObjectIdentifier, String> getSymLookup(Ruby runtime) {
        Map<ASN1ObjectIdentifier, String> val = OID_TO_SYM.get(runtime);
        if (null == val) {
            ASN1.initMaps(runtime);
            val = OID_TO_SYM.get(runtime);
        }
        return val;
    }

    public static int idForClass(Class type) {
        Integer v = null;
        while (type != Object.class && v == null) {
            v = CLASS_TO_ID.get(type);
            if (v != null) continue;
            type = type.getSuperclass();
        }
        return null == v ? -1 : v;
    }

    public static int idForRubyName(String name) {
        Integer v = RUBYNAME_TO_ID.get(name);
        return null == v ? -1 : v;
    }

    public static Class<? extends ASN1Encodable> classForId(int id) {
        Class result = (Class)ASN1_INFO[id][1];
        return result;
    }

    public static void createASN1(Ruby runtime, RubyModule ossl) {
        RubyModule mASN1 = ossl.defineModuleUnder("ASN1");
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mASN1.defineClassUnder("ASN1Error", openSSLError, openSSLError.getAllocator());
        mASN1.defineAnnotatedMethods(ASN1.class);
        ArrayList<Object> ary = new ArrayList<Object>();
        mASN1.setConstant("UNIVERSAL_TAG_NAME", (IRubyObject)runtime.newArray(ary));
        for (int i = 0; i < ASN1_INFO.length; ++i) {
            if (((String)ASN1_INFO[i][0]).charAt(0) != '[') {
                ary.add(runtime.newString((String)ASN1_INFO[i][0]));
                mASN1.setConstant((String)ASN1_INFO[i][0], (IRubyObject)runtime.newFixnum(i));
                continue;
            }
            ary.add(runtime.getNil());
        }
        RubyClass cASN1Data = mASN1.defineClassUnder("ASN1Data", runtime.getObject(), ASN1Data.ALLOCATOR);
        cASN1Data.addReadWriteAttribute(runtime.getCurrentContext(), "value");
        cASN1Data.addReadWriteAttribute(runtime.getCurrentContext(), "tag");
        cASN1Data.addReadWriteAttribute(runtime.getCurrentContext(), "tag_class");
        cASN1Data.defineAnnotatedMethods(ASN1Data.class);
        RubyClass cASN1Primitive = mASN1.defineClassUnder("Primitive", cASN1Data, ASN1Primitive.ALLOCATOR);
        cASN1Primitive.addReadWriteAttribute(runtime.getCurrentContext(), "tagging");
        cASN1Primitive.defineAnnotatedMethods(ASN1Primitive.class);
        RubyClass cASN1Constructive = mASN1.defineClassUnder("Constructive", cASN1Data, ASN1Constructive.ALLOCATOR);
        cASN1Constructive.includeModule((IRubyObject)runtime.getModule("Enumerable"));
        cASN1Constructive.addReadWriteAttribute(runtime.getCurrentContext(), "tagging");
        cASN1Constructive.defineAnnotatedMethods(ASN1Constructive.class);
        mASN1.defineClassUnder("Boolean", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Integer", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Enumerated", cASN1Primitive, cASN1Primitive.getAllocator());
        RubyClass cASN1BitString = mASN1.defineClassUnder("BitString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("OctetString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("UTF8String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("NumericString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("PrintableString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("T61String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("VideotexString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("IA5String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("GraphicString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("ISO64String", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("GeneralString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("UniversalString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("BMPString", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Null", cASN1Primitive, cASN1Primitive.getAllocator());
        RubyClass cASN1ObjectId = mASN1.defineClassUnder("ObjectId", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("UTCTime", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("GeneralizedTime", cASN1Primitive, cASN1Primitive.getAllocator());
        mASN1.defineClassUnder("Sequence", cASN1Constructive, cASN1Constructive.getAllocator());
        mASN1.defineClassUnder("Set", cASN1Constructive, cASN1Constructive.getAllocator());
        cASN1ObjectId.defineAnnotatedMethods(ObjectId.class);
        cASN1BitString.addReadWriteAttribute(runtime.getCurrentContext(), "unused_bits");
    }

    private static String getShortNameFor(Ruby runtime, String nameOrOid) {
        ASN1ObjectIdentifier oid = ASN1.getObjectIdentifier(runtime, nameOrOid);
        Map<String, ASN1ObjectIdentifier> em = ASN1.getOIDLookup(runtime);
        String name = null;
        for (String key : em.keySet()) {
            if (!oid.equals((Object)em.get(key)) || name != null && key.length() >= name.length()) continue;
            name = key;
        }
        return name;
    }

    private static String getLongNameFor(Ruby runtime, String nameOrOid) {
        ASN1ObjectIdentifier oid = ASN1.getObjectIdentifier(runtime, nameOrOid);
        Map<String, ASN1ObjectIdentifier> em = ASN1.getOIDLookup(runtime);
        String name = null;
        for (String key : em.keySet()) {
            if (!oid.equals((Object)em.get(key)) || name != null && key.length() <= name.length()) continue;
            name = key;
        }
        return name;
    }

    private static ASN1ObjectIdentifier getObjectIdentifier(Ruby runtime, String nameOrOid) {
        ASN1ObjectIdentifier val1 = ASN1.getOIDLookup(runtime).get(nameOrOid.toLowerCase());
        if (null != val1) {
            return val1;
        }
        ASN1ObjectIdentifier val2 = new ASN1ObjectIdentifier(nameOrOid);
        return val2;
    }

    @JRubyMethod(name={"Boolean"}, module=true, rest=true)
    public static IRubyObject fact_Boolean(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("Boolean").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"Integer"}, module=true, rest=true)
    public static IRubyObject fact_Integer(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("Integer").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"Enumerated"}, module=true, rest=true)
    public static IRubyObject fact_Enumerated(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("Enumerated").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"BitString"}, module=true, rest=true)
    public static IRubyObject fact_BitString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("BitString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"OctetString"}, module=true, rest=true)
    public static IRubyObject fact_OctetString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("OctetString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"UTF8String"}, module=true, rest=true)
    public static IRubyObject fact_UTF8String(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("UTF8String").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"NumericString"}, module=true, rest=true)
    public static IRubyObject fact_NumericString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("NumericString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"PrintableString"}, module=true, rest=true)
    public static IRubyObject fact_PrintableString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("PrintableString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"T61String"}, module=true, rest=true)
    public static IRubyObject fact_T61String(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("T61String").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"VideotexString"}, module=true, rest=true)
    public static IRubyObject fact_VideotexString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("VideotexString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"IA5String"}, module=true, rest=true)
    public static IRubyObject fact_IA5String(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("IA5String").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"GraphicString"}, module=true, rest=true)
    public static IRubyObject fact_GraphicString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("GraphicString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"ISO64String"}, module=true, rest=true)
    public static IRubyObject fact_ISO64String(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("ISO64String").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"GeneralString"}, module=true, rest=true)
    public static IRubyObject fact_GeneralString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("GeneralString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"UniversalString"}, module=true, rest=true)
    public static IRubyObject fact_UniversalString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("UniversalString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"BMPString"}, module=true, rest=true)
    public static IRubyObject fact_BMPString(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("BMPString").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"Nul"}, module=true, rest=true)
    public static IRubyObject fact_Null(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("Null").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"ObjectId"}, module=true, rest=true)
    public static IRubyObject fact_ObjectId(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("ObjectId").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"UTCTime"}, module=true, rest=true)
    public static IRubyObject fact_UTCTime(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("UTCTime").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"GeneralizedTime"}, module=true, rest=true)
    public static IRubyObject fact_GeneralizedTime(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("GeneralizedTime").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"Sequence"}, module=true, rest=true)
    public static IRubyObject fact_Sequence(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("Sequence").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(name={"Set"}, module=true, rest=true)
    public static IRubyObject fact_Set(IRubyObject recv, IRubyObject[] args) {
        return ((RubyModule)recv).getClass("Set").callMethod(recv.getRuntime().getCurrentContext(), "new", args);
    }

    @JRubyMethod(meta=true, required=1)
    public static IRubyObject traverse(IRubyObject recv, IRubyObject a) {
        System.err.println("WARNING: unimplemented method called: traverse");
        return null;
    }

    private static IRubyObject decodeObj(RubyModule asnM, Object v) throws IOException, ParseException {
        int ix = ASN1.idForClass(v.getClass());
        String v_name = ix == -1 ? null : (String)ASN1_INFO[ix][2];
        ThreadContext tc = asnM.getRuntime().getCurrentContext();
        if (null != v_name) {
            RubyClass c = asnM.getClass(v_name);
            if (v instanceof DERBitString) {
                ByteList bl = new ByteList(((DERBitString)v).getBytes(), false);
                IRubyObject bString = c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(bl));
                bString.callMethod(tc, "unused_bits=", (IRubyObject)asnM.getRuntime().newFixnum(((DERBitString)v).getPadBits()));
                return bString;
            }
            if (v instanceof ASN1String) {
                ByteList val = v instanceof DERUTF8String ? new ByteList(((DERUTF8String)v).getString().getBytes("UTF-8")) : ByteList.create((CharSequence)((ASN1String)v).getString());
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(val));
            }
            if (v instanceof ASN1Sequence) {
                ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
                Enumeration enm = ((ASN1Sequence)v).getObjects();
                while (enm.hasMoreElements()) {
                    l.add(ASN1.decodeObj(asnM, enm.nextElement()));
                }
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newArray(l));
            }
            if (v instanceof ASN1Set) {
                ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
                Enumeration enm = ((ASN1Set)v).getObjects();
                while (enm.hasMoreElements()) {
                    l.add(ASN1.decodeObj(asnM, enm.nextElement()));
                }
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newArray(l));
            }
            if (v instanceof DERNull) {
                return c.callMethod(tc, "new", asnM.getRuntime().getNil());
            }
            if (v instanceof ASN1Integer) {
                return c.callMethod(tc, "new", (IRubyObject)BN.newBN(asnM.getRuntime(), ((ASN1Integer)v).getValue()));
            }
            if (v instanceof DERUTCTime) {
                Date d = dateF.parse(((DERUTCTime)v).getAdjustedTime());
                Calendar cal = Calendar.getInstance();
                cal.setTime(d);
                IRubyObject[] argv = new IRubyObject[]{asnM.getRuntime().newFixnum(cal.get(1)), asnM.getRuntime().newFixnum(cal.get(2) + 1), asnM.getRuntime().newFixnum(cal.get(5)), asnM.getRuntime().newFixnum(cal.get(11)), asnM.getRuntime().newFixnum(cal.get(12)), asnM.getRuntime().newFixnum(cal.get(13))};
                return c.callMethod(tc, "new", asnM.getRuntime().getClass("Time").callMethod(tc, "local", argv));
            }
            if (v instanceof ASN1ObjectIdentifier) {
                String av = ((ASN1ObjectIdentifier)v).getId();
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(av));
            }
            if (v instanceof DEROctetString) {
                ByteList bl = new ByteList(((DEROctetString)v).getOctets(), false);
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newString(bl));
            }
            if (v instanceof DERBoolean) {
                return c.callMethod(tc, "new", (IRubyObject)(((DERBoolean)v).isTrue() ? asnM.getRuntime().getTrue() : asnM.getRuntime().getFalse()));
            }
            System.out.println("Should handle: " + v.getClass().getName());
        } else {
            if (v instanceof ASN1TaggedObject) {
                RubyClass c = asnM.getClass("ASN1Data");
                IRubyObject val = ASN1.decodeObj(asnM, ((ASN1TaggedObject)v).getObject());
                RubyFixnum tag = asnM.getRuntime().newFixnum(((ASN1TaggedObject)v).getTagNo());
                RubySymbol tag_class = asnM.getRuntime().newSymbol("CONTEXT_SPECIFIC");
                return c.callMethod(tc, "new", new IRubyObject[]{asnM.getRuntime().newArray(val), tag, tag_class});
            }
            if (v instanceof ASN1Sequence) {
                RubyClass c = asnM.getClass("Sequence");
                ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
                Enumeration enm = ((ASN1Sequence)v).getObjects();
                while (enm.hasMoreElements()) {
                    l.add(ASN1.decodeObj(asnM, enm.nextElement()));
                }
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newArray(l));
            }
            if (v instanceof ASN1Set) {
                RubyClass c = asnM.getClass("Set");
                ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
                Enumeration enm = ((ASN1Set)v).getObjects();
                while (enm.hasMoreElements()) {
                    l.add(ASN1.decodeObj(asnM, enm.nextElement()));
                }
                return c.callMethod(tc, "new", (IRubyObject)asnM.getRuntime().newArray(l));
            }
        }
        throw new IllegalArgumentException("jruby-openssl unable to decode object: " + v + "[" + v.getClass().getName() + "]");
    }

    @JRubyMethod(meta=true)
    public static IRubyObject decode(IRubyObject recv, IRubyObject obj) {
        try {
            IRubyObject obj2 = OpenSSLImpl.to_der_if_possible(obj);
            RubyModule asnM = (RubyModule)recv;
            ASN1InputStream asis = new ASN1InputStream(obj2.convertToString().getBytes());
            IRubyObject ret = ASN1.decodeObj(asnM, asis.readObject());
            return ret;
        }
        catch (IOException e) {
            throw recv.getRuntime().newIOErrorFromException(e);
        }
        catch (Exception e) {
            throw recv.getRuntime().newArgumentError(e.getMessage());
        }
    }

    @JRubyMethod(meta=true, required=1)
    public static IRubyObject decode_all(IRubyObject recv, IRubyObject a) {
        System.err.println("WARNING: unimplemented method called: decode_all");
        return null;
    }

    static {
        for (int i = 0; i < ASN1_INFO.length; ++i) {
            if (ASN1_INFO[i][1] != null) {
                CLASS_TO_ID.put((Class)ASN1_INFO[i][1], new Integer(i));
            }
            if (ASN1_INFO[i][2] == null) continue;
            RUBYNAME_TO_ID.put((String)ASN1_INFO[i][2], new Integer(i));
        }
        dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
    }

    public static class ASN1Constructive
    extends ASN1Data {
        private static final long serialVersionUID = -7166662655104776828L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Constructive(runtime, klass);
            }
        };

        public ASN1Constructive(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        @Override
        @JRubyMethod
        public IRubyObject to_der() {
            return super.to_der();
        }

        @JRubyMethod(required=1, optional=3)
        public IRubyObject initialize(IRubyObject[] args) {
            IRubyObject value = args[0];
            IRubyObject tag = this.getRuntime().getNil();
            IRubyObject tagging = this.getRuntime().getNil();
            IRubyObject tag_class = this.getRuntime().getNil();
            if (args.length > 1) {
                tag = args[1];
                if (args.length > 2) {
                    tagging = args[2];
                    if (args.length > 3) {
                        tag_class = args[3];
                    }
                }
                if (tag.isNil()) {
                    this.asn1Error("must specify tag number");
                }
                if (tagging.isNil()) {
                    tagging = this.getRuntime().newSymbol("EXPLICIT");
                }
                if (!(tagging instanceof RubySymbol)) {
                    this.asn1Error("invalid tag default");
                }
                if (tag_class.isNil()) {
                    tag_class = this.getRuntime().newSymbol("CONTEXT_SPECIFIC");
                }
                if (!(tag_class instanceof RubySymbol)) {
                    this.asn1Error("invalid tag class");
                }
                if (tagging.toString().equals(":IMPLICIT") && RubyNumeric.fix2int((IRubyObject)tag) > 31) {
                    this.asn1Error("tag number for Universal too large");
                }
            } else {
                tag = this.defaultTag();
                tagging = this.getRuntime().getNil();
                tag_class = this.getRuntime().newSymbol("UNIVERSAL");
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            this.callMethod(tc, "tag=", tag);
            this.callMethod(tc, "value=", value);
            this.callMethod(tc, "tagging=", tagging);
            this.callMethod(tc, "tag_class=", tag_class);
            return this;
        }

        @Override
        ASN1Encodable toASN1() {
            int id = ASN1.idForRubyName(this.getMetaClass().getRealClass().getBaseName());
            if (id != -1) {
                ASN1EncodableVector vec = new ASN1EncodableVector();
                RubyArray arr = (RubyArray)this.callMethod(this.getRuntime().getCurrentContext(), "value");
                for (IRubyObject obj : arr.toJavaArray()) {
                    if (obj instanceof ASN1Data) {
                        vec.add(((ASN1Data)obj).toASN1());
                        continue;
                    }
                    vec.add(((ASN1Data)ASN1.decode((IRubyObject)this.getRuntime().getClassFromPath("OpenSSL::ASN1"), OpenSSLImpl.to_der_if_possible(obj))).toASN1());
                }
                try {
                    ASN1Encodable result = (ASN1Encodable)((Class)ASN1_INFO[id][1]).getConstructor(ASN1EncodableVector.class).newInstance(vec);
                    return result;
                }
                catch (Exception e) {
                    throw RaiseException.createNativeRaiseException((Ruby)this.getRuntime(), (Throwable)e);
                }
            }
            return null;
        }

        @JRubyMethod
        public IRubyObject each(Block block) {
            RubyArray arr = (RubyArray)this.callMethod(this.getRuntime().getCurrentContext(), "value");
            for (IRubyObject obj : arr.toJavaArray()) {
                block.yield(this.getRuntime().getCurrentContext(), obj);
            }
            return this.getRuntime().getNil();
        }

        @Override
        protected void print(int indent) {
            this.printIndent(indent);
            System.out.println(this.getMetaClass().getRealClass().getBaseName() + ": ");
            RubyArray arr = (RubyArray)this.callMethod(this.getRuntime().getCurrentContext(), "value");
            for (IRubyObject obj : arr.toJavaArray()) {
                ((ASN1Data)obj).print(indent + 1);
            }
        }
    }

    public static class ASN1Primitive
    extends ASN1Data {
        private static final long serialVersionUID = 8489625559339190259L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Primitive(runtime, klass);
            }
        };

        public ASN1Primitive(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public String toString() {
            return this.callMethod(this.getRuntime().getCurrentContext(), "value").toString();
        }

        @Override
        @JRubyMethod
        public IRubyObject to_der() {
            return super.to_der();
        }

        @JRubyMethod(required=1, optional=4)
        public IRubyObject initialize(IRubyObject[] args) {
            String v;
            IRubyObject value = args[0];
            IRubyObject tag = this.getRuntime().getNil();
            IRubyObject tagging = this.getRuntime().getNil();
            IRubyObject tag_class = this.getRuntime().getNil();
            if (args.length > 1) {
                tag = args[1];
                if (args.length > 2) {
                    tagging = args[2];
                    if (args.length > 3) {
                        tag_class = args[3];
                    }
                }
                if (tag.isNil()) {
                    this.asn1Error("must specify tag number");
                }
                if (tagging.isNil()) {
                    tagging = this.getRuntime().newSymbol("EXPLICIT");
                }
                if (!(tagging instanceof RubySymbol)) {
                    this.asn1Error("invalid tag default");
                }
                if (tag_class.isNil()) {
                    tag_class = this.getRuntime().newSymbol("CONTEXT_SPECIFIC");
                }
                if (!(tag_class instanceof RubySymbol)) {
                    this.asn1Error("invalid tag class");
                }
                if (tagging.toString().equals(":IMPLICIT") && RubyNumeric.fix2int((IRubyObject)tag) > 31) {
                    this.asn1Error("tag number for Universal too large");
                }
            } else {
                tag = this.defaultTag();
                tagging = this.getRuntime().getNil();
                tag_class = this.getRuntime().newSymbol("UNIVERSAL");
            }
            if ("ObjectId".equals(this.getMetaClass().getRealClass().getBaseName()) && (v = ASN1.getSymLookup(this.getRuntime()).get(this.getObjectIdentifier(value.toString()))) != null) {
                value = this.getRuntime().newString(v);
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            this.callMethod(tc, "tag=", tag);
            this.callMethod(tc, "value=", value);
            this.callMethod(tc, "tagging=", tagging);
            this.callMethod(tc, "tag_class=", tag_class);
            return this;
        }

        private ASN1ObjectIdentifier getObjectIdentifier(String nameOrOid) {
            ASN1ObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return val1;
            }
            ASN1ObjectIdentifier val2 = new ASN1ObjectIdentifier(nameOrOid);
            return val2;
        }

        @Override
        ASN1Encodable toASN1() {
            int tag = ASN1.idForRubyName(this.getMetaClass().getRealClass().getBaseName());
            Class imp = (Class)ASN1_INFO[tag][1];
            IRubyObject val = this.callMethod(this.getRuntime().getCurrentContext(), "value");
            if (imp == ASN1ObjectIdentifier.class) {
                return this.getObjectIdentifier(val.toString());
            }
            if (imp == DERNull.class) {
                return new DERNull();
            }
            if (imp == DERBoolean.class) {
                return new DERBoolean(val.isTrue());
            }
            if (imp == DERUTCTime.class) {
                return new DERUTCTime(((RubyTime)val).getJavaDate());
            }
            if (imp == ASN1Integer.class && val instanceof RubyBignum) {
                return new ASN1Integer(((RubyBignum)val).getValue());
            }
            if (imp == ASN1Integer.class) {
                return new ASN1Integer(new BigInteger(val.toString()));
            }
            if (imp == DEROctetString.class) {
                return new DEROctetString(val.convertToString().getBytes());
            }
            if (imp == DERBitString.class) {
                byte[] bs = val.convertToString().getBytes();
                int unused = 0;
                for (int i = bs.length - 1; i > -1; --i) {
                    if (bs[i] == 0) {
                        unused += 8;
                        continue;
                    }
                    byte v2 = bs[i];
                    int x = 8;
                    while (v2 != 0) {
                        v2 = (byte)(v2 << 1);
                        --x;
                    }
                    unused += x;
                    break;
                }
                return new DERBitString(bs, unused);
            }
            if (val instanceof RubyString) {
                try {
                    return (ASN1Encodable)imp.getConstructor(String.class).newInstance(val.toString());
                }
                catch (Exception ex) {
                    throw RaiseException.createNativeRaiseException((Ruby)this.getRuntime(), (Throwable)ex);
                }
            }
            System.err.println("object with tag: " + tag + " and value: " + val + " and val.class: " + val.getClass().getName() + " and impl: " + imp.getName());
            System.err.println("WARNING: unimplemented method called: asn1data#toASN1");
            return null;
        }

        @Override
        protected void print(int indent) {
            this.printIndent(indent);
            System.out.println(this.getMetaClass().getRealClass().getBaseName() + ": " + this.callMethod(this.getRuntime().getCurrentContext(), "value").callMethod(this.getRuntime().getCurrentContext(), "inspect").toString());
        }
    }

    public static class ASN1Data
    extends RubyObject {
        private static final long serialVersionUID = 6117598347932209839L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ASN1Data(runtime, klass);
            }
        };

        public ASN1Data(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        protected void asn1Error() {
            this.asn1Error(null);
        }

        protected void asn1Error(String msg) {
            throw Utils.newError(this.getRuntime(), "OpenSSL::ASN1::ASN1Error", msg);
        }

        @JRubyMethod
        public IRubyObject initialize(IRubyObject value, IRubyObject tag, IRubyObject tag_class) {
            if (!(tag_class instanceof RubySymbol)) {
                this.asn1Error("invalid tag class");
            }
            if (tag_class.toString().equals(":UNIVERSAL") && RubyNumeric.fix2int((IRubyObject)tag) > 31) {
                this.asn1Error("tag number for Universal too large");
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            this.callMethod(tc, "tag=", tag);
            this.callMethod(tc, "value=", value);
            this.callMethod(tc, "tag_class=", tag_class);
            return this;
        }

        ASN1Encodable toASN1() {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            int tag = RubyNumeric.fix2int((IRubyObject)this.callMethod(tc, "tag"));
            IRubyObject val = this.callMethod(tc, "value");
            if (val instanceof RubyArray) {
                RubyArray arr = (RubyArray)this.callMethod(tc, "value");
                if (arr.size() > 1) {
                    ASN1EncodableVector vec = new ASN1EncodableVector();
                    for (IRubyObject obj : arr.toJavaArray()) {
                        vec.add(((ASN1Data)obj).toASN1());
                    }
                    return new DERTaggedObject(tag, (ASN1Encodable)new DLSequence(vec));
                }
                return new DERTaggedObject(tag, ((ASN1Data)((Object)arr.getList().get(0))).toASN1());
            }
            return new DERTaggedObject(tag, ((ASN1Data)val).toASN1());
        }

        @JRubyMethod
        public IRubyObject to_der() {
            try {
                return this.getRuntime().newString(new ByteList(this.toASN1().toASN1Primitive().getEncoded("DER"), false));
            }
            catch (IOException ex) {
                throw Utils.newError(this.getRuntime(), "OpenSSL::ASN1::ASN1Error", ex.getMessage());
            }
        }

        protected IRubyObject defaultTag() {
            int i = ASN1.idForRubyName(this.getMetaClass().getRealClass().getBaseName());
            if (i != -1) {
                return this.getRuntime().newFixnum(i);
            }
            return this.getRuntime().getNil();
        }

        protected void print() {
            this.print(0);
        }

        protected void printIndent(int indent) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
        }

        protected void print(int indent) {
            this.printIndent(indent);
            System.out.println("ASN1Data: ");
            IRubyObject val = this.callMethod(this.getRuntime().getCurrentContext(), "value");
            if (val instanceof RubyArray) {
                RubyArray arr = (RubyArray)val;
                for (IRubyObject obj : arr.toJavaArray()) {
                    ((ASN1Data)obj).print(indent + 1);
                }
            } else {
                ((ASN1Data)val).print(indent + 1);
            }
        }
    }

    public static class ObjectId {
        @JRubyMethod(meta=true, rest=true)
        public static IRubyObject register(IRubyObject recv, IRubyObject[] args) {
            ASN1ObjectIdentifier deroi = new ASN1ObjectIdentifier(args[0].toString());
            ASN1.getOIDLookup(recv.getRuntime()).put(args[1].toString().toLowerCase(), deroi);
            ASN1.getOIDLookup(recv.getRuntime()).put(args[2].toString().toLowerCase(), deroi);
            ASN1.getSymLookup(recv.getRuntime()).put(deroi, args[1].toString());
            return recv.getRuntime().getTrue();
        }

        @JRubyMethod(name={"sn", "short_name"})
        public static IRubyObject sn(IRubyObject self) {
            return self.getRuntime().newString(ASN1.getShortNameFor(self.getRuntime(), self.callMethod(self.getRuntime().getCurrentContext(), "value").toString()));
        }

        @JRubyMethod(name={"ln", "long_name"})
        public static IRubyObject ln(IRubyObject self) {
            return self.getRuntime().newString(ASN1.getLongNameFor(self.getRuntime(), self.callMethod(self.getRuntime().getCurrentContext(), "value").toString()));
        }

        @JRubyMethod
        public static IRubyObject oid(IRubyObject self) {
            return self.getRuntime().newString(ASN1.getObjectIdentifier(self.getRuntime(), self.callMethod(self.getRuntime().getCurrentContext(), "value").toString()).getId());
        }
    }
}

