#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/core_perl'
echo 'name: QuickCheck
version: 2.7.3
id: QuickCheck-2.7.3-548d271454f79ef75d2ca0650db4ace6

license: BSD3
copyright: 2000-2014 Koen Claessen, 2006-2008 Björn Bringert, 2009-2014 Nick Smallbone
maintainer: QuickCheck developers <quickcheck@projects.haskell.org>
stability:
homepage: http://code.haskell.org/QuickCheck
package-url:
synopsis: Automatic testing of Haskell programs
description: QuickCheck is a library for random testing of program properties.
             .
             The programmer provides a specification of the program, in
             the form of properties which functions should satisfy, and
             QuickCheck then tests that the properties hold in a large number
             of randomly generated cases.
             .
             Specifications are expressed in
             Haskell, using combinators defined in the QuickCheck library.
             QuickCheck provides combinators to define properties, observe
             the distribution of test data, and define test
             data generators.
category: Testing
author: Koen Claessen <koen@chalmers.se>
exposed: True
exposed-modules: Test.QuickCheck Test.QuickCheck.Arbitrary
                 Test.QuickCheck.Gen Test.QuickCheck.Gen.Unsafe
                 Test.QuickCheck.Monadic Test.QuickCheck.Modifiers
                 Test.QuickCheck.Property Test.QuickCheck.Test Test.QuickCheck.Text
                 Test.QuickCheck.Poly Test.QuickCheck.State Test.QuickCheck.Random
                 Test.QuickCheck.Exception Test.QuickCheck.Function
                 Test.QuickCheck.All
hidden-modules:
trusted: False
import-dirs: /usr/lib/ghc-7.8.2/site-local/QuickCheck-2.7.3
library-dirs: /usr/lib/ghc-7.8.2/site-local/QuickCheck-2.7.3
hs-libraries: HSQuickCheck-2.7.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.0-018311399e3b6350d5be3a16b144df9b
         random-1.0.1.1-6ee738046e61b4cfbe8ae4a5ddcd83ac
         template-haskell-2.9.0.0-dcc8c210fb02937e104bc1784d7b0f06
         tf-random-0.4-1b5678f2d3feb4ff5d029631ae0449e0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/share/doc/haskell-quickcheck/html/QuickCheck.haddock
haddock-html: /usr/share/doc/haskell-quickcheck/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
