/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheException;
import java.io.IOException;
import java.io.Writer;

public final class JsonEscapingMustacheFactory
extends DefaultMustacheFactory {
    @Override
    public void encode(String value, Writer writer) {
        try {
            JsonEscapingMustacheFactory.escape(value, writer);
        }
        catch (IOException e) {
            throw new MustacheException("Failed to encode value: " + value);
        }
    }

    public static Writer escape(String value, Writer writer) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            if (JsonEscapingMustacheFactory.isEscapeChar(character)) {
                writer.write(92);
            }
            writer.write(character);
        }
        return writer;
    }

    public static boolean isEscapeChar(char c) {
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\"': 
            case '\\': {
                return true;
            }
        }
        return false;
    }
}

