/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.hppc.AbstractIntCollection;
import org.elasticsearch.common.hppc.AbstractIterator;
import org.elasticsearch.common.hppc.HashContainerUtils;
import org.elasticsearch.common.hppc.IntContainer;
import org.elasticsearch.common.hppc.IntLookupContainer;
import org.elasticsearch.common.hppc.IntSet;
import org.elasticsearch.common.hppc.Internals;
import org.elasticsearch.common.hppc.cursors.IntCursor;
import org.elasticsearch.common.hppc.predicates.IntPredicate;
import org.elasticsearch.common.hppc.procedures.IntProcedure;

public class IntOpenHashSet
extends AbstractIntCollection
implements IntLookupContainer,
IntSet,
Cloneable {
    public static final int MIN_CAPACITY = 4;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public int[] keys;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    protected int resizeAt;
    protected int lastSlot;
    protected int perturbation;

    public IntOpenHashSet() {
        this(16, 0.75f);
    }

    public IntOpenHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntOpenHashSet(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainerUtils.roundCapacity(initialCapacity));
    }

    public IntOpenHashSet(IntContainer container) {
        this((int)((float)container.size() * 1.75f));
        this.addAll(container);
    }

    @Override
    public boolean add(int e) {
        assert (this.assigned < this.allocated.length);
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(e, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (e == this.keys[slot]) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(e, slot);
        } else {
            ++this.assigned;
            this.allocated[slot] = true;
            this.keys[slot] = e;
        }
        return true;
    }

    public int add(int e1, int e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(int ... elements) {
        int count = 0;
        for (int e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    public int addAll(IntContainer container) {
        return this.addAll((Iterable<? extends IntCursor>)container);
    }

    public int addAll(Iterable<? extends IntCursor> iterable) {
        int count = 0;
        for (IntCursor intCursor : iterable) {
            if (!this.add(intCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(int pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (!this.allocated[freeSlot]);
        int[] oldKeys = this.keys;
        boolean[] oldAllocated = this.allocated;
        this.allocateBuffers(HashContainerUtils.nextCapacity(this.keys.length));
        this.lastSlot = -1;
        ++this.assigned;
        oldAllocated[freeSlot] = true;
        oldKeys[freeSlot] = pendingKey;
        int[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int mask = allocated.length - 1;
        int i = oldAllocated.length;
        while (--i >= 0) {
            if (!oldAllocated[i]) continue;
            int k = oldKeys[i];
            int slot = Internals.rehash(k, this.perturbation) & mask;
            while (allocated[slot]) {
                slot = slot + 1 & mask;
            }
            allocated[slot] = true;
            keys[slot] = k;
        }
    }

    private void allocateBuffers(int capacity) {
        int[] keys = new int[capacity];
        boolean[] allocated = new boolean[capacity];
        this.keys = keys;
        this.allocated = allocated;
        this.resizeAt = Math.max(2, (int)Math.ceil((float)capacity * this.loadFactor)) - 1;
        this.perturbation = this.computePerturbationValue(capacity);
    }

    protected int computePerturbationValue(int capacity) {
        return HashContainerUtils.PERTURBATIONS[Integer.numberOfLeadingZeros(capacity)];
    }

    @Override
    public int removeAllOccurrences(int key) {
        return this.remove(key) ? 1 : 0;
    }

    public boolean remove(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                --this.assigned;
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    protected void shiftConflictingKeys(int slotCurr) {
        int mask = this.allocated.length - 1;
        while (true) {
            int slotPrev = slotCurr;
            slotCurr = slotPrev + 1 & mask;
            while (this.allocated[slotCurr]) {
                int slotOther = Internals.rehash(this.keys[slotCurr], this.perturbation) & mask;
                if (slotPrev <= slotCurr ? slotPrev >= slotOther || slotOther > slotCurr : slotPrev >= slotOther && slotOther > slotCurr) break;
                slotCurr = slotCurr + 1 & mask;
            }
            if (!this.allocated[slotCurr]) break;
            this.keys[slotPrev] = this.keys[slotCurr];
        }
        this.allocated[slotPrev] = false;
    }

    public int lslot() {
        assert (this.lastSlot >= 0) : "Call contains() first.";
        return this.lastSlot;
    }

    @Override
    public boolean contains(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key, this.perturbation) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        Arrays.fill(this.allocated, false);
        Arrays.fill(this.keys, 0);
    }

    @Override
    public int size() {
        return this.assigned;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        int i = states.length;
        while (--i >= 0) {
            if (!states[i]) continue;
            h += Internals.rehash(keys[i]);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null) {
            IntSet other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntSet && (other = (IntSet)obj).size() == this.size()) {
                for (IntCursor c : this) {
                    if (other.contains(c.value)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            procedure.apply(keys[i]);
        }
        return procedure;
    }

    @Override
    public int[] toArray() {
        int[] cloned = new int[this.assigned];
        int j = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.allocated[i]) continue;
            cloned[j++] = this.keys[i];
        }
        return cloned;
    }

    public IntOpenHashSet clone() {
        try {
            IntOpenHashSet cloned = (IntOpenHashSet)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        int[] keys = this.keys;
        boolean[] states = this.allocated;
        for (int i = 0; i < states.length && (!states[i] || predicate.apply(keys[i])); ++i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int[] keys = this.keys;
        boolean[] allocated = this.allocated;
        int before = this.assigned;
        int i = 0;
        while (i < allocated.length) {
            if (allocated[i] && predicate.apply(keys[i])) {
                --this.assigned;
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.assigned;
    }

    public static IntOpenHashSet from(int ... elements) {
        IntOpenHashSet set = new IntOpenHashSet((int)((float)elements.length * 1.75f));
        set.add(elements);
        return set;
    }

    public static IntOpenHashSet from(IntContainer container) {
        return new IntOpenHashSet(container);
    }

    public static IntOpenHashSet newInstance() {
        return new IntOpenHashSet();
    }

    public static IntOpenHashSet newInstanceWithoutPerturbations() {
        return new IntOpenHashSet(){

            @Override
            protected int computePerturbationValue(int capacity) {
                return 0;
            }
        };
    }

    public static IntOpenHashSet newInstanceWithCapacity(int initialCapacity, float loadFactor) {
        return new IntOpenHashSet(initialCapacity, loadFactor);
    }

    private final class EntryIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            int max = IntOpenHashSet.this.keys.length;
            for (i = this.cursor.index + 1; i < IntOpenHashSet.this.keys.length && !IntOpenHashSet.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = IntOpenHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

