/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.List;
import java.util.ListIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;

public class PlainShardsIterator
implements ShardsIterator {
    private final List<ShardRouting> shards;
    private ListIterator<ShardRouting> iterator;

    public PlainShardsIterator(List<ShardRouting> shards) {
        this.shards = shards;
        this.iterator = shards.listIterator();
    }

    @Override
    public void reset() {
        this.iterator = this.shards.listIterator();
    }

    @Override
    public int remaining() {
        return this.shards.size() - this.iterator.nextIndex();
    }

    @Override
    public ShardRouting firstOrNull() {
        if (this.shards.isEmpty()) {
            return null;
        }
        return this.shards.get(0);
    }

    @Override
    public ShardRouting nextOrNull() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return null;
    }

    @Override
    public int size() {
        return this.shards.size();
    }

    @Override
    public int sizeActive() {
        int count = 0;
        for (ShardRouting shard : this.shards) {
            if (!shard.active()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int assignedReplicasIncludingRelocating() {
        int count = 0;
        for (ShardRouting shard : this.shards) {
            if (shard.unassigned()) continue;
            if (shard.primary()) {
                if (!shard.relocating()) continue;
                ++count;
                continue;
            }
            ++count;
            if (!shard.relocating()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterable<ShardRouting> asUnordered() {
        return this.shards;
    }
}

