/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.source;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ShowElementCombinator;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.source.SourceRange;
import java.util.List;

public class SourceRangeFactory {
    public static SourceRange rangeElementName(Element element) {
        return SourceRangeFactory.rangeStartLength(element.getNameOffset(), element.getDisplayName().length());
    }

    public static SourceRange rangeEndEnd(AstNode astNode, AstNode astNode2) {
        int n = astNode.getEnd();
        int n2 = astNode2.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeEndEnd(AstNode astNode, int n) {
        int n2 = astNode.getEnd();
        return SourceRangeFactory.rangeStartEnd(n2, n);
    }

    public static SourceRange rangeEndEnd(AstNode astNode, SourceRange sourceRange) {
        int n = astNode.getEnd();
        int n2 = sourceRange.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeEndEnd(SourceRange sourceRange, AstNode astNode) {
        int n = sourceRange.getEnd();
        int n2 = astNode.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeEndEnd(SourceRange sourceRange, SourceRange sourceRange2) {
        int n = sourceRange.getEnd();
        int n2 = sourceRange2.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeEndLength(AstNode astNode, int n) {
        int n2 = astNode.getEnd();
        return new SourceRange(n2, n);
    }

    public static SourceRange rangeEndLength(SourceRange sourceRange, int n) {
        int n2 = sourceRange.getOffset() + sourceRange.getLength();
        return SourceRangeFactory.rangeStartLength(n2, n);
    }

    public static SourceRange rangeEndStart(AstNode astNode, AstNode astNode2) {
        int n = astNode.getEnd();
        int n2 = astNode2.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeEndStart(AstNode astNode, int n) {
        int n2 = astNode.getEnd();
        return SourceRangeFactory.rangeStartEnd(n2, n);
    }

    public static SourceRange rangeEndStart(AstNode astNode, Token token) {
        int n = astNode.getEnd();
        int n2 = token.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeEndStart(SourceRange sourceRange, SourceRange sourceRange2) {
        int n = sourceRange.getEnd();
        int n2 = sourceRange2.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeError(AnalysisError analysisError) {
        if (analysisError != null) {
            return new SourceRange(analysisError.getOffset(), analysisError.getLength());
        }
        return null;
    }

    public static SourceRange rangeFromBase(AstNode astNode, int n) {
        int n2 = astNode.getOffset() - n;
        int n3 = astNode.getLength();
        return SourceRangeFactory.rangeStartLength(n2, n3);
    }

    public static SourceRange rangeFromBase(AstNode astNode, SourceRange sourceRange) {
        return SourceRangeFactory.rangeFromBase(astNode, sourceRange.getOffset());
    }

    public static SourceRange rangeFromBase(SourceRange sourceRange, SourceRange sourceRange2) {
        int n = sourceRange.getOffset() - sourceRange2.getOffset();
        int n2 = sourceRange.getLength();
        return SourceRangeFactory.rangeStartLength(n, n2);
    }

    public static SourceRange rangeNode(AstNode astNode) {
        if (astNode != null) {
            return new SourceRange(astNode.getOffset(), astNode.getLength());
        }
        return null;
    }

    public static SourceRange rangeNodes(List<? extends AstNode> list) {
        if (list.isEmpty()) {
            return SourceRangeFactory.rangeStartLength(0, 0);
        }
        AstNode astNode = list.get(0);
        AstNode astNode2 = list.get(list.size() - 1);
        return SourceRangeFactory.rangeStartEnd(astNode, astNode2);
    }

    public static SourceRange rangeShowCombinator(ShowElementCombinator showElementCombinator) {
        return SourceRangeFactory.rangeStartEnd(showElementCombinator.getOffset(), showElementCombinator.getEnd());
    }

    public static SourceRange rangeStartEnd(AstNode astNode, AstNode astNode2) {
        int n = astNode.getOffset();
        int n2 = astNode2.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartEnd(AstNode astNode, int n) {
        int n2 = astNode.getOffset();
        return SourceRangeFactory.rangeStartEnd(n2, n);
    }

    public static SourceRange rangeStartEnd(AstNode astNode, Token token) {
        int n = astNode.getOffset();
        int n2 = token.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartEnd(int n, AstNode astNode) {
        int n2 = astNode.getEnd();
        return new SourceRange(n, n2 - n);
    }

    public static SourceRange rangeStartEnd(int n, int n2) {
        return new SourceRange(n, n2 - n);
    }

    public static SourceRange rangeStartEnd(SourceRange sourceRange, AstNode astNode) {
        int n = sourceRange.getOffset();
        int n2 = astNode.getEnd();
        return new SourceRange(n, n2 - n);
    }

    public static SourceRange rangeStartEnd(SourceRange sourceRange, int n) {
        int n2 = sourceRange.getOffset();
        return SourceRangeFactory.rangeStartEnd(n2, n);
    }

    public static SourceRange rangeStartEnd(SourceRange sourceRange, SourceRange sourceRange2) {
        int n = sourceRange.getOffset();
        int n2 = sourceRange2.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartEnd(Token token, AstNode astNode) {
        int n = token.getOffset();
        int n2 = astNode.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartEnd(Token token, int n) {
        int n2 = token.getOffset();
        return SourceRangeFactory.rangeStartEnd(n2, n);
    }

    public static SourceRange rangeStartEnd(Token token, Token token2) {
        int n = token.getOffset();
        int n2 = token2.getEnd();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartLength(AstNode astNode, int n) {
        int n2 = astNode.getOffset();
        return new SourceRange(n2, n);
    }

    public static SourceRange rangeStartLength(int n, int n2) {
        return new SourceRange(n, n2);
    }

    public static SourceRange rangeStartLength(SourceRange sourceRange, int n) {
        return SourceRangeFactory.rangeStartLength(sourceRange.getOffset(), n);
    }

    public static SourceRange rangeStartStart(AstNode astNode, AstNode astNode2) {
        int n = astNode.getOffset();
        int n2 = astNode2.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartStart(int n, AstNode astNode) {
        int n2 = astNode.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartStart(SourceRange sourceRange, AstNode astNode) {
        int n = sourceRange.getOffset();
        int n2 = astNode.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeStartStart(SourceRange sourceRange, SourceRange sourceRange2) {
        int n = sourceRange.getOffset();
        int n2 = sourceRange2.getOffset();
        return SourceRangeFactory.rangeStartEnd(n, n2);
    }

    public static SourceRange rangeToken(Token token) {
        return SourceRangeFactory.rangeStartLength(token.getOffset(), token.getLength());
    }

    public static SourceRange rangeWithBase(AstNode astNode, SourceRange sourceRange) {
        return SourceRangeFactory.rangeWithBase(astNode.getOffset(), sourceRange);
    }

    public static SourceRange rangeWithBase(int n, SourceRange sourceRange) {
        int n2 = n + sourceRange.getOffset();
        int n3 = sourceRange.getLength();
        return SourceRangeFactory.rangeStartLength(n2, n3);
    }

    public static SourceRange rangeWithBase(SourceRange sourceRange, SourceRange sourceRange2) {
        return SourceRangeFactory.rangeWithBase(sourceRange.getOffset(), sourceRange2);
    }
}

