/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.source;

public final class SourceRange {
    public static final SourceRange EMPTY = new SourceRange(0, 0);
    private final int offset;
    private final int length;

    public SourceRange(int n, int n2) {
        this.offset = n;
        this.length = n2;
    }

    public boolean contains(int n) {
        return this.offset <= n && n < this.offset + this.length;
    }

    public boolean containsExclusive(int n) {
        return this.offset < n && n < this.offset + this.length;
    }

    public boolean coveredBy(SourceRange sourceRange) {
        return sourceRange.covers(this);
    }

    public boolean covers(SourceRange sourceRange) {
        return this.getOffset() <= sourceRange.getOffset() && sourceRange.getEnd() <= this.getEnd();
    }

    public boolean endsIn(SourceRange sourceRange) {
        int n = this.getEnd();
        return sourceRange.contains(n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SourceRange)) {
            return false;
        }
        SourceRange sourceRange = (SourceRange)object;
        return sourceRange.getOffset() == this.offset && sourceRange.getLength() == this.length;
    }

    public int getEnd() {
        return this.offset + this.length;
    }

    public SourceRange getExpanded(int n) {
        return new SourceRange(this.offset - n, n + this.length + n);
    }

    public int getLength() {
        return this.length;
    }

    public SourceRange getMoveEnd(int n) {
        return new SourceRange(this.offset, this.length + n);
    }

    public int getOffset() {
        return this.offset;
    }

    public SourceRange getTranslated(int n) {
        return new SourceRange(this.offset + n, this.length);
    }

    public int hashCode() {
        return 31 * this.offset + this.length;
    }

    public boolean intersects(SourceRange sourceRange) {
        if (sourceRange == null) {
            return false;
        }
        if (this.getEnd() <= sourceRange.getOffset()) {
            return false;
        }
        return this.getOffset() < sourceRange.getEnd();
    }

    public boolean startsIn(SourceRange sourceRange) {
        return sourceRange.contains(this.offset);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[offset=");
        stringBuilder.append(this.offset);
        stringBuilder.append(", length=");
        stringBuilder.append(this.length);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

