/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.source;

public class LineInfo {
    private int[] lineStarts;

    public LineInfo(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("lineStarts must be non-null");
        }
        if (nArray.length < 1) {
            throw new IllegalArgumentException("lineStarts must be non-empty");
        }
        this.lineStarts = nArray;
    }

    public Location getLocation(int n) {
        int n2 = this.lineStarts.length;
        for (int i = 1; i < n2; ++i) {
            if (n >= this.lineStarts[i]) continue;
            return new Location(i, n - this.lineStarts[i - 1] + 1);
        }
        return new Location(n2, n - this.lineStarts[n2 - 1] + 1);
    }

    public static class Location {
        private int lineNumber;
        private int columnNumber;

        public Location(int n, int n2) {
            this.lineNumber = n;
            this.columnNumber = n2;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

