/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.os;

public final class OSUtilities {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String OS_PREFIX_MAC = "mac";
    private static final String OS_PREFIX_WIN = "win";
    private static final String OS_PROPERTY_NAME = "os.name";

    public static boolean isLinux() {
        return !OSUtilities.isMac() && !OSUtilities.isWindows();
    }

    public static boolean isMac() {
        return System.getProperty(OS_PROPERTY_NAME).toLowerCase().startsWith(OS_PREFIX_MAC);
    }

    public static boolean isWindows() {
        return System.getProperty(OS_PROPERTY_NAME).toLowerCase().startsWith(OS_PREFIX_WIN);
    }

    private OSUtilities() {
    }
}

