/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ProcessRunner {
    private ProcessBuilder processBuilder;
    private int exitCode;
    private StringBuilder stdout = new StringBuilder();
    private StringBuilder stderr = new StringBuilder();
    private Thread processThread;
    private Process process;

    public ProcessRunner(ProcessBuilder processBuilder) {
        this.processBuilder = processBuilder;
    }

    public ProcessRunner(String[] stringArray) {
        this(new ProcessBuilder(stringArray));
    }

    public void dispose() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getStdErr() {
        return this.stderr.toString();
    }

    public String getStdOut() {
        return this.stdout.toString();
    }

    public int runSync(long l) throws IOException {
        this.exitCode = 0;
        this.stdout.setLength(0);
        this.stderr.setLength(0);
        final Process process = this.processBuilder.start();
        this.processThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessRunner.this.exitCode = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessRunner.this.pipeOutput(process.getInputStream(), ProcessRunner.this.stdout);
            }
        });
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessRunner.this.pipeOutput(process.getErrorStream(), ProcessRunner.this.stderr);
            }
        });
        this.processThread.start();
        thread.start();
        thread2.start();
        try {
            this.processThread.join(l);
            if (this.processThread.isAlive()) {
                this.exitCode = -1;
            } else {
                thread.join();
                thread2.join();
            }
            return this.exitCode;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    protected void pipeOutput(InputStream inputStream, StringBuilder stringBuilder) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            char[] cArray = new char[512];
            int n = inputStreamReader.read(cArray);
            while (n != -1) {
                stringBuilder.append(cArray, 0, n);
                n = inputStreamReader.read(cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

