/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public final class FileUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = FileUtilities.getContents(bufferedReader);
            return string;
        }
        finally {
            fileReader.close();
        }
    }

    public static String getContents(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = reader.read();
        while (n >= 0) {
            stringBuilder.append((char)n);
            n = reader.read();
        }
        return stringBuilder.toString();
    }

    public static String getExtension(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static boolean makeExecutable(File file) {
        if (file.setExecutable(true, false)) {
            return true;
        }
        return file.setExecutable(true, true);
    }

    private FileUtilities() {
    }
}

