/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.instrumentation;

import com.google.dart.engine.utilities.instrumentation.Base64;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.instrumentation.InstrumentationBuilder;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;

public class HealthUtils {
    public static long getMaxMem() {
        long l = Long.MAX_VALUE;
        try {
            Method method = Runtime.class.getMethod("maxMemory", new Class[0]);
            Object object = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
            if (object instanceof Long) {
                l = (Long)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static void logMemory(InstrumentationBuilder instrumentationBuilder) {
        instrumentationBuilder.metric("MexMemory-FeedbackUtils", HealthUtils.getMaxMem());
        instrumentationBuilder.metric("TotalMemory", Runtime.getRuntime().totalMemory());
        instrumentationBuilder.metric("FreeMemory", Runtime.getRuntime().freeMemory());
    }

    public static void logThreads(InstrumentationBuilder instrumentationBuilder) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfoArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
        instrumentationBuilder.metric("threads-count", threadInfoArray.length);
        for (ThreadInfo threadInfo : threadInfoArray) {
            if (threadInfo == null) {
                instrumentationBuilder.metric("Thread-Name", "<unknown>");
                continue;
            }
            instrumentationBuilder.metric("Thread-Name", threadInfo.getThreadName());
            instrumentationBuilder.metric("Thread-ID", threadInfo.getThreadId());
            instrumentationBuilder.metric("Thread-State", threadInfo.getThreadState().toString());
            instrumentationBuilder.metric("Blocked-Count", threadInfo.getBlockedCount());
            instrumentationBuilder.metric("Blocked-Time", threadInfo.getBlockedTime());
            instrumentationBuilder.metric("Waited-Count", threadInfo.getWaitedCount());
            instrumentationBuilder.metric("Waited-Time", threadInfo.getWaitedTime());
            instrumentationBuilder.data("Thread-ST", Base64.encodeBytes(HealthUtils.stackTraceToString(threadInfo.getStackTrace()).getBytes()));
        }
    }

    public static void ReportHealth(final String string) {
        new Thread(){

            @Override
            public void run() {
                HealthUtils.ReportHealthImpl(string);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ReportHealthImpl(String string) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("HealthReport");
        try {
            instrumentationBuilder.metric("Reason", string);
            HealthUtils.logMemory(instrumentationBuilder);
            HealthUtils.logThreads(instrumentationBuilder);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    private static String stackTraceToString(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

