/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.general;

public class TimeCounter {
    public static final int NANOS_PER_MILLI = 1000000;
    private long totalTime = 0L;
    private long maxInterval = 0L;
    private long minInterval = Long.MAX_VALUE;
    private int intervalCount = 0;

    public long getAverage() {
        if (this.intervalCount == 0) {
            return 0L;
        }
        return this.totalTime / (long)(1000000 * this.intervalCount);
    }

    public int getCount() {
        return this.intervalCount;
    }

    public long getMax() {
        return this.maxInterval / 1000000L;
    }

    public long getMin() {
        if (this.intervalCount == 0) {
            return 0L;
        }
        return this.minInterval / 1000000L;
    }

    public long getResult() {
        return this.totalTime / 1000000L;
    }

    public void recordElapsedNanos(long l) {
        this.totalTime += l;
        ++this.intervalCount;
        this.minInterval = Math.min(this.minInterval, l);
        this.maxInterval = Math.max(this.maxInterval, l);
    }

    public TimeCounterHandle start() {
        return new TimeCounterHandle();
    }

    public class TimeCounterHandle {
        final long startTime = System.nanoTime();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            TimeCounter timeCounter = TimeCounter.this;
            synchronized (timeCounter) {
                TimeCounter.this.recordElapsedNanos(System.nanoTime() - this.startTime);
            }
        }
    }
}

