/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.general;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

public final class StringUtilities {
    public static final String EMPTY = "";
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final Interner<String> INTERNER = Interners.newWeakInterner();

    public static String abbreviateLeft(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            if (n < 4) {
                throw new IllegalArgumentException("Minimal width is 4");
            }
            return "..." + string.substring(n2 - (n - 3));
        }
        return string;
    }

    public static boolean endsWith3(String string, int n, int n2, int n3) {
        int n4 = string.length();
        return n4 >= 3 && string.charAt(n4 - 3) == n && string.charAt(n4 - 2) == n2 && string.charAt(n4 - 1) == n3;
    }

    public static boolean endsWithChar(String string, int n) {
        int n2 = string.length();
        return n2 > 0 && string.charAt(n2 - 1) == n;
    }

    public static int indexOf1(String string, int n, int n2) {
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            if (string.charAt(i) != n2) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf2(String string, int n, int n2, int n3) {
        int n4 = string.length() - 1;
        for (int i = n; i < n4; ++i) {
            if (string.charAt(i) != n2 || string.charAt(i + 1) != n3) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf4(String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = string.length() - 3;
        for (int i = n; i < n6; ++i) {
            if (string.charAt(i) != n2 || string.charAt(i + 1) != n3 || string.charAt(i + 2) != n4 || string.charAt(i + 3) != n5) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf5(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = string.length() - 4;
        for (int i = n; i < n7; ++i) {
            if (string.charAt(i) != n2 || string.charAt(i + 1) != n3 || string.charAt(i + 2) != n4 || string.charAt(i + 3) != n5 || string.charAt(i + 4) != n6) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfFirstNotLetterDigit(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            return i;
        }
        return n2;
    }

    public static String intern(String string) {
        if (string == null) {
            return null;
        }
        string = new String(string);
        return INTERNER.intern(string);
    }

    public static boolean isAlpha(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isLetter(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isTagName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) continue;
            if (i == 0) {
                return false;
            }
            if (Character.isDigit(c) || c == '-') continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith2(String string, int n, int n2, int n3) {
        return string.length() - n >= 2 && string.charAt(n) == n2 && string.charAt(n + 1) == n3;
    }

    public static boolean startsWith3(String string, int n, int n2, int n3, int n4) {
        return string.length() - n >= 3 && string.charAt(n) == n2 && string.charAt(n + 1) == n3 && string.charAt(n + 2) == n4;
    }

    public static boolean startsWith4(String string, int n, int n2, int n3, int n4, int n5) {
        return string.length() - n >= 4 && string.charAt(n) == n2 && string.charAt(n + 1) == n3 && string.charAt(n + 2) == n4 && string.charAt(n + 3) == n5;
    }

    public static boolean startsWith5(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        return string.length() - n >= 5 && string.charAt(n) == n2 && string.charAt(n + 1) == n3 && string.charAt(n + 2) == n4 && string.charAt(n + 3) == n5 && string.charAt(n + 4) == n6;
    }

    public static boolean startsWith6(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return string.length() - n >= 6 && string.charAt(n) == n2 && string.charAt(n + 1) == n3 && string.charAt(n + 2) == n4 && string.charAt(n + 3) == n5 && string.charAt(n + 4) == n6 && string.charAt(n + 5) == n7;
    }

    public static boolean startsWithChar(String string, int n) {
        return string.length() > 0 && string.charAt(0) == n;
    }

    public static String substringAfter(String string, String string2) {
        if (StringUtilities.isEmpty(string)) {
            return string;
        }
        if (string2 == null) {
            return EMPTY;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return EMPTY;
        }
        return string.substring(n + string2.length());
    }

    public static String substringBefore(String string, String string2) {
        if (StringUtilities.isEmpty(string) || string2 == null) {
            return string;
        }
        if (string2.length() == 0) {
            return EMPTY;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringBeforeChar(String string, int n) {
        if (StringUtilities.isEmpty(string)) {
            return string;
        }
        int n2 = string.indexOf(n);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2);
    }

    private StringUtilities() {
    }
}

