/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.collection;

import java.util.EmptyStackException;

public class IntStack {
    private int[] values;
    private int top;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;

    public IntStack() {
        this(10);
    }

    public IntStack(int n) {
        this.values = new int[n];
        this.top = 0;
    }

    public void clear() {
        this.top = 0;
    }

    public void increment(int n) {
        if (this.top == 0) {
            throw new EmptyStackException();
        }
        int n2 = this.top - 1;
        this.values[n2] = this.values[n2] + n;
    }

    public boolean isEmpty() {
        return this.top == 0;
    }

    public int peek() {
        if (this.top == 0) {
            throw new EmptyStackException();
        }
        return this.values[this.top - 1];
    }

    public int pop() {
        if (this.top == 0) {
            throw new EmptyStackException();
        }
        return this.values[--this.top];
    }

    public void push(int n) {
        int n2 = this.values.length;
        if (this.top == n2) {
            int[] nArray = new int[n2 + 10];
            System.arraycopy(this.values, 0, nArray, 0, n2);
            this.values = nArray;
        }
        this.values[this.top++] = n;
    }

    public void replaceTop(int n) {
        if (this.top == 0) {
            throw new EmptyStackException();
        }
        this.values[this.top - 1] = n;
    }

    public int size() {
        return this.top;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.top; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

