/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.utilities.collection;

import com.google.dart.engine.utilities.translation.DartBlockBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectedGraph<N> {
    private HashMap<N, HashSet<N>> edges = new HashMap();

    public void addEdge(N n, N n2) {
        HashSet<Object> hashSet;
        if (this.edges.get(n2) == null) {
            this.edges.put(n2, new HashSet());
        }
        if ((hashSet = this.edges.get(n)) == null) {
            hashSet = new HashSet();
            this.edges.put(n, hashSet);
        }
        hashSet.add(n2);
    }

    public void addNode(N n) {
        HashSet<N> hashSet = this.edges.get(n);
        if (hashSet == null) {
            this.edges.put(n, new HashSet());
        }
    }

    public List<N> findCycle() {
        return null;
    }

    public List<N> findCycleContaining(N n) {
        if (n == null) {
            throw new IllegalArgumentException();
        }
        SccFinder<N> sccFinder = new SccFinder<N>(this);
        return sccFinder.componentContaining(n);
    }

    public int getNodeCount() {
        return this.edges.size();
    }

    public Set<N> getTails(N n) {
        HashSet<N> hashSet = this.edges.get(n);
        if (hashSet == null) {
            return new HashSet();
        }
        return hashSet;
    }

    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public void removeAllNodes(List<N> list) {
        for (N n : list) {
            this.removeNode(n);
        }
    }

    public void removeEdge(N n, N n2) {
        HashSet<N> hashSet = this.edges.get(n);
        if (hashSet != null) {
            hashSet.remove(n2);
        }
    }

    public void removeNode(N n) {
        this.edges.remove(n);
        for (HashSet<N> hashSet : this.edges.values()) {
            hashSet.remove(n);
        }
    }

    public N removeSink() {
        N n = this.findSink();
        if (n == null) {
            return null;
        }
        this.removeNode(n);
        return n;
    }

    @DartBlockBody(value={"for (N key in _edges.keys) {", "  if (_edges[key].isEmpty) return key;", "}", "return null;"})
    private N findSink() {
        for (Map.Entry<N, HashSet<N>> entry : this.edges.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            return entry.getKey();
        }
        return null;
    }

    private static class SccFinder<N> {
        private DirectedGraph<N> graph;
        private int index = 0;
        private ArrayList<N> stack = new ArrayList();
        private HashMap<N, NodeInfo<N>> nodeMap = new HashMap();

        public SccFinder(DirectedGraph<N> directedGraph) {
            this.graph = directedGraph;
        }

        public ArrayList<N> componentContaining(N n) {
            return this.strongConnect(n).component;
        }

        private N pop() {
            N n = this.stack.remove(this.stack.size() - 1);
            this.nodeMap.get(n).onStack = false;
            return n;
        }

        private void push(N n) {
            this.nodeMap.get(n).onStack = true;
            this.stack.add(n);
        }

        private NodeInfo<N> strongConnect(N n) {
            NodeInfo nodeInfo = new NodeInfo(this.index++);
            this.nodeMap.put(n, nodeInfo);
            this.push(n);
            HashSet hashSet = (HashSet)((DirectedGraph)this.graph).edges.get(n);
            if (hashSet != null) {
                for (Object object : hashSet) {
                    NodeInfo<Object> nodeInfo2 = this.nodeMap.get(object);
                    if (nodeInfo2 == null) {
                        nodeInfo2 = this.strongConnect(object);
                        nodeInfo.lowlink = Math.min(nodeInfo.lowlink, nodeInfo2.lowlink);
                        continue;
                    }
                    if (!nodeInfo2.onStack) continue;
                    nodeInfo.lowlink = Math.min(nodeInfo.lowlink, nodeInfo2.index);
                }
            }
            if (nodeInfo.lowlink == nodeInfo.index) {
                Object object;
                ArrayList arrayList = new ArrayList();
                do {
                    object = this.pop();
                    arrayList.add(object);
                    this.nodeMap.get(object).component = arrayList;
                } while (object != n);
            }
            return nodeInfo;
        }
    }

    private static class NodeInfo<N> {
        public int index;
        public int lowlink;
        public boolean onStack;
        public ArrayList<N> component;

        public NodeInfo(int n) {
            this.index = n;
            this.lowlink = n;
            this.onStack = false;
        }
    }
}

